/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ecore;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.domain.EGFResourceSet;
import org.eclipse.egf.core.genmodel.IPlatformGenModel;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointListener;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;

public class EPackageHelper {
    private static final EPackageHelper INSTANCE = new EPackageHelper();
    public static final String INSTANCE_FIELD_NAME = "eINSTANCE";
    public final EPackage.Registry REGISTRY = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
    private Map<String, String> nsuri2basePackage = null;
    private IPlatformExtensionPointListener _extensionPointListener = new IPlatformExtensionPointListener(){

        public void platformExtensionPointChanged(IPlatformExtensionPointDelta delta) {
            IPlatformGenModel genModel;
            if (EPackageHelper.this.nsuri2basePackage == null) {
                EPackageHelper.this.init();
            }
            IPlatformGenModel[] iPlatformGenModelArray = (IPlatformGenModel[])delta.getAddedPlatformExtensionPoints(IPlatformGenModel.class);
            int n = iPlatformGenModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                genModel = iPlatformGenModelArray[n2];
                EPackageHelper.this.addEcoreModel(genModel);
                ++n2;
            }
            iPlatformGenModelArray = (IPlatformGenModel[])delta.getRemovedPlatformExtensionPoints(IPlatformGenModel.class);
            n = iPlatformGenModelArray.length;
            n2 = 0;
            while (n2 < n) {
                genModel = iPlatformGenModelArray[n2];
                EPackageHelper.this.removePackageFromRegistry(genModel);
                ++n2;
            }
        }
    };

    private EPackageHelper() {
    }

    public static EPackageHelper getInstance() {
        return INSTANCE;
    }

    public void dispose() {
        EGFPlatformPlugin.getPlatformManager().removePlatformExtensionPointListener(this._extensionPointListener);
    }

    private void init() {
        if (this.nsuri2basePackage != null) {
            return;
        }
        this.nsuri2basePackage = new HashMap<String, String>();
        IPlatformGenModel[] iPlatformGenModelArray = EGFCorePlugin.getPlatformGenModels();
        int n = iPlatformGenModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformGenModel genModel = iPlatformGenModelArray[n2];
            this.addEcoreModel(genModel);
            ++n2;
        }
        EGFPlatformPlugin.getPlatformManager().addPlatformExtensionPointListener(this._extensionPointListener);
    }

    private void addEcoreModel(IPlatformGenModel genModel) {
        try {
            try {
                URI uri = genModel.getGenModelURI();
                if (uri == null) {
                    this.handleClassname(genModel);
                } else {
                    this.handleURI(uri);
                }
            }
            catch (Exception uri) {
                // empty catch block
            }
            this.addPackage2registry(genModel);
        }
        catch (Exception e) {
            EGFPatternPlugin.getDefault().logError(e);
        }
    }

    private void handleClassname(IPlatformGenModel genModel) {
        String classname = genModel.getGeneratedPackage();
        int index = classname.lastIndexOf(".");
        if (index == -1) {
            throw new IllegalStateException();
        }
        if (index == 0) {
            this.nsuri2basePackage.put(genModel.getNamespace(), "");
        } else {
            this.nsuri2basePackage.put(genModel.getNamespace(), classname.substring(0, index));
        }
    }

    private void handleURI(URI uri) {
        EGFResourceSet set = new EGFResourceSet();
        Resource res = set.getResource(uri, true);
        try {
            for (EObject obj : res.getContents()) {
                if (!(obj instanceof GenModel)) continue;
                GenModel genModel2 = (GenModel)obj;
                for (GenPackage gPack : genModel2.getAllGenPackagesWithClassifiers()) {
                    EPackage ecorePackage = gPack.getEcorePackage();
                    String basePackageName = gPack.getInterfacePackageName();
                    this.nsuri2basePackage.put(ecorePackage.getNsURI(), basePackageName);
                }
            }
        }
        finally {
            res.unload();
        }
    }

    public String getBasePackage(EPackage ePackage) {
        String nsURI;
        String name;
        if (this.nsuri2basePackage == null) {
            this.init();
        }
        if ((name = this.nsuri2basePackage.get(nsURI = ePackage.getNsURI())) == null) {
            throw new IllegalStateException();
        }
        return name;
    }

    private void addPackage2registry(IPlatformGenModel genModel) {
        String nsURI = genModel.getNamespace();
        if (!this.REGISTRY.containsKey((Object)nsURI)) {
            this.REGISTRY.put((Object)nsURI, (Object)new Descriptor2(genModel));
        }
    }

    private void removePackageFromRegistry(IPlatformGenModel genModel) {
        String nsURI = genModel.getNamespace();
        this.REGISTRY.remove((Object)nsURI);
    }

    public EPackage getEPackage(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        if (eObject instanceof EPackage) {
            return (EPackage)eObject;
        }
        if (eObject instanceof EClassifier) {
            return ((EClassifier)eObject).getEPackage();
        }
        if (eObject instanceof EOperation) {
            return ((EOperation)eObject).getEContainingClass().getEPackage();
        }
        if (eObject instanceof EStructuralFeature) {
            return ((EStructuralFeature)eObject).getEContainingClass().getEPackage();
        }
        if (eObject instanceof EAnnotation) {
            return this.getEPackage((EObject)((EAnnotation)eObject).getEModelElement());
        }
        if (eObject instanceof EParameter) {
            return this.getEPackage((EObject)((EParameter)eObject).getEOperation());
        }
        throw new UnsupportedOperationException(NLS.bind((String)"EPackage couldn't be resolved ''{0}''", (Object)EcoreUtil.getURI((EObject)eObject)));
    }

    private static class Descriptor2
    implements EPackage.Descriptor {
        private final IPlatformGenModel genModel;

        private Descriptor2(IPlatformGenModel genModel) {
            this.genModel = genModel;
        }

        public EFactory getEFactory() {
            return null;
        }

        public EPackage getEPackage() {
            try {
                Class javaClass = this.getGenModel().getPlatformBundle().getBundle().loadClass(this.getGenModel().getGeneratedPackage());
                Field field = javaClass.getField(EPackageHelper.INSTANCE_FIELD_NAME);
                Object result = field.get(null);
                return (EPackage)result;
            }
            catch (ClassNotFoundException e) {
                throw new WrappedException((Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new WrappedException((Exception)e);
            }
            catch (NoSuchFieldException e) {
                throw new WrappedException((Exception)e);
            }
        }

        public IPlatformGenModel getGenModel() {
            return this.genModel;
        }
    }

    public static class RegistrationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private RegistrationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

