/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.common.helper.CollectionHelper;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformExtensionPointDelta
implements IPlatformExtensionPointDelta {
    private Map<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>> _added = new HashMap<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>>();
    private Map<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>> _removed = new HashMap<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>>();

    protected static IPlatformExtensionPoint[] getPlatformExtensionPoints(Map<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>> map) {
        ArrayList extensionPoints = new ArrayList();
        for (Map.Entry<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>> entry : map.entrySet()) {
            extensionPoints.addAll(entry.getValue());
        }
        return extensionPoints.toArray(new IPlatformExtensionPoint[extensionPoints.size()]);
    }

    protected static IPlatformExtensionPoint[] getPlatformExtensionPoints(Map<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>> map, boolean isTarget) {
        ArrayList<IPlatformExtensionPoint> extensionPoints = new ArrayList<IPlatformExtensionPoint>();
        for (Map.Entry<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>> entry : map.entrySet()) {
            for (IPlatformExtensionPoint platformExtensionPoint : entry.getValue()) {
                if (platformExtensionPoint.getPlatformBundle().isTarget() != isTarget) continue;
                extensionPoints.add(platformExtensionPoint);
            }
        }
        return extensionPoints.toArray(new IPlatformExtensionPoint[extensionPoints.size()]);
    }

    protected static boolean storePlatformExtensionPoint(Map<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>> map, Class<? extends IPlatformExtensionPoint> clazz, IPlatformExtensionPoint extensionPoint) {
        if (clazz == null || !EGFPlatformPlugin.getPlatformExtensionPointClasses().contains(clazz) || extensionPoint == null) {
            return false;
        }
        List<IPlatformExtensionPoint> extensionPoints = map.get(clazz);
        if (extensionPoints == null) {
            extensionPoints = new ArrayList<IPlatformExtensionPoint>();
            map.put(clazz, extensionPoints);
        }
        return extensionPoints.add(extensionPoint);
    }

    protected static <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(Map<Class<? extends IPlatformExtensionPoint>, List<IPlatformExtensionPoint>> map, Class<T> clazz) {
        ArrayList extensionPoints = new ArrayList();
        if (clazz != null && EGFPlatformPlugin.getPlatformExtensionPointClasses().contains(clazz) && map.get(clazz) != null) {
            extensionPoints.addAll(map.get(clazz));
        }
        return (IPlatformExtensionPoint[])CollectionHelper.toArray(extensionPoints, clazz);
    }

    @Override
    public IPlatformExtensionPoint[] getAddedPlatformExtensionPoints() {
        return PlatformExtensionPointDelta.getPlatformExtensionPoints(this._added);
    }

    @Override
    public IPlatformExtensionPoint[] getTargetAddedPlatformExtensionPoints() {
        return PlatformExtensionPointDelta.getPlatformExtensionPoints(this._added, true);
    }

    @Override
    public IPlatformExtensionPoint[] getWorkspaceAddedPlatformExtensionPoints() {
        return PlatformExtensionPointDelta.getPlatformExtensionPoints(this._added, false);
    }

    @Override
    public <T extends IPlatformExtensionPoint> T[] getAddedPlatformExtensionPoints(Class<T> clazz) {
        return PlatformExtensionPointDelta.getPlatformExtensionPoints(this._added, clazz);
    }

    @Override
    public IPlatformExtensionPoint[] getRemovedPlatformExtensionPoints() {
        return PlatformExtensionPointDelta.getPlatformExtensionPoints(this._removed);
    }

    @Override
    public IPlatformExtensionPoint[] getTargetRemovedPlatformExtensionPoints() {
        return PlatformExtensionPointDelta.getPlatformExtensionPoints(this._removed, true);
    }

    @Override
    public IPlatformExtensionPoint[] getWorkspaceRemovedPlatformExtensionPoints() {
        return PlatformExtensionPointDelta.getPlatformExtensionPoints(this._removed, false);
    }

    @Override
    public <T extends IPlatformExtensionPoint> T[] getRemovedPlatformExtensionPoints(Class<T> clazz) {
        return PlatformExtensionPointDelta.getPlatformExtensionPoints(this._removed, clazz);
    }

    protected boolean isEmpty() {
        return this._added.size() == 0 && this._removed.size() == 0;
    }

    protected boolean storeAddedPlatformExtensionPoint(Class<? extends IPlatformExtensionPoint> clazz, IPlatformExtensionPoint extensionPoint) {
        return PlatformExtensionPointDelta.storePlatformExtensionPoint(this._added, clazz, extensionPoint);
    }

    protected boolean storeRemovedPlatformExtensionPoint(Class<? extends IPlatformExtensionPoint> clazz, IPlatformExtensionPoint extensionPoint) {
        return PlatformExtensionPointDelta.storePlatformExtensionPoint(this._removed, clazz, extensionPoint);
    }
}

