/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ChangeMessageInfo;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.GitPersonInfo;
import org.eclipse.egerrit.internal.model.MergeableInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.table.model.SubmitType;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;

public class DataConverter {
    private DataConverter() {
    }

    public static IConverter gerritTimeConverter(final SimpleDateFormat outputTime) {
        return new Converter(String.class, String.class){

            public Object convert(Object fromObject) {
                SimpleDateFormat formatIn = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.");
                Date dateNew = null;
                if (fromObject != null && !"".equals(fromObject)) {
                    try {
                        formatIn.setTimeZone(TimeZone.getTimeZone("UTC"));
                        dateNew = formatIn.parse((String)fromObject);
                    }
                    catch (ParseException ex) {
                        EGerritCorePlugin.logError((String)ex.getMessage());
                    }
                    return outputTime.format(dateNew);
                }
                return "";
            }
        };
    }

    public static IConverter gitPersonConverter() {
        return new Converter(GitPersonInfo.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject != null && !"".equals(fromObject)) {
                    GitPersonInfo person = (GitPersonInfo)fromObject;
                    if (person.getName() != null && person.getEmail() != null) {
                        return "<a>" + person.getName() + "<" + person.getEmail() + ">" + "</a>";
                    }
                    return null;
                }
                return null;
            }
        };
    }

    public static IConverter submitTypeConverter() {
        return new Converter(MergeableInfo.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject != null && !"".equals(fromObject)) {
                    MergeableInfo mInfo = (MergeableInfo)fromObject;
                    return SubmitType.getEnumName(mInfo.getSubmit_type());
                }
                return null;
            }
        };
    }

    public static IConverter cannotMergeConverter() {
        return new Converter(Boolean.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject != null && !"".equals(fromObject)) {
                    return new Boolean((Boolean)fromObject) != false ? "" : Messages.DataConverter_0;
                }
                return null;
            }
        };
    }

    public static IConverter linkText() {
        return new Converter(String.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject == null) {
                    return "";
                }
                return "<a>" + fromObject + "</a>";
            }
        };
    }

    public static IConverter fromStringToDocument(final GerritClient gerritClient) {
        return new Converter(String.class, IDocument.class){

            public Object convert(Object fromObject) {
                if (fromObject == null) {
                    return null;
                }
                ChangeMessageInfo message = (ChangeMessageInfo)fromObject;
                if (!message.isComment()) {
                    return new Document(message.getMessage());
                }
                ChangeInfo containingChange = (ChangeInfo)message.eContainer();
                RevisionInfo selectedRevision = containingChange.getRevisionByNumber(message.get_revision_number());
                if (selectedRevision != null) {
                    QueryHelpers.loadComments(gerritClient, selectedRevision);
                }
                return new Document(String.valueOf(message.getMessage()) + "\n" + DataConverter.formatMessageWithComments(message, selectedRevision));
            }
        };
    }

    private static String formatMessageWithComments(ChangeMessageInfo chmsgInfo, RevisionInfo revInfo) {
        StringBuilder sb = new StringBuilder();
        if (revInfo != null) {
            Collection files = revInfo.getFiles().values();
            for (FileInfo fileInfo : files) {
                if (fileInfo.getComments().isEmpty()) continue;
                sb.append("\n");
                sb.append(fileInfo.getPath());
                for (CommentInfo comment : fileInfo.getComments()) {
                    if (!chmsgInfo.getDate().equals(comment.getUpdated())) continue;
                    sb.append(NLS.bind((String)Messages.DataConverter_4, (Object[])new Object[]{comment.getLine(), comment.getMessage()}));
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static IConverter patchSetSelected(final ChangeInfo changeInfo) {
        return new Converter(String.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject == null || changeInfo.getUserSelectedRevision() == null) {
                    return "                               ";
                }
                RevisionInfo revInfo = changeInfo.getUserSelectedRevision();
                StringBuilder sb = new StringBuilder();
                sb.append(Messages.DataConverter_5);
                sb.append(revInfo.get_number());
                sb.append("/");
                sb.append(changeInfo.getRevision().get_number());
                return sb.toString();
            }
        };
    }
}

