/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.editors.BranchSelectionDialog;
import org.eclipse.egerrit.internal.ui.editors.FindLocalRepository;
import org.eclipse.egerrit.internal.ui.table.model.BranchMatch;
import org.eclipse.egerrit.internal.ui.utils.ActiveWorkspaceRevision;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.egit.ui.internal.dialogs.CheckoutConflictDialog;
import org.eclipse.egit.ui.internal.fetch.FetchGerritChangeWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CheckoutResult;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RenameBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CheckoutRevision
extends Action {
    private RevisionInfo revisionCheckedOut;
    private GerritClient gerritClient;
    private ChangeInfo changeInfo;
    private String selectedBranch;
    private static final String RENAME_KEY = "branchRenameTip";

    public CheckoutRevision(RevisionInfo revision, GerritClient gerritClient) {
        this.revisionCheckedOut = revision;
        this.gerritClient = gerritClient;
        this.changeInfo = this.revisionCheckedOut.getChangeInfo();
        this.setText(Messages.CheckoutRevision_0);
    }

    public void run() {
        Repository localRepo = new FindLocalRepository(this.gerritClient, this.changeInfo.getProject()).getRepository();
        boolean reActivateWorkspaceRevision = true;
        if (localRepo == null) {
            Status status = new Status(4, "org.eclipse.egerrit.core", Messages.CheckoutRevision_1);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CheckoutRevision_2, (String)Messages.CheckoutRevision_3, (IStatus)status);
            return;
        }
        String refSelected = this.revisionCheckedOut.getRef();
        if (refSelected == null || refSelected.isEmpty()) {
            Status status = new Status(4, "org.eclipse.egerrit.core", Messages.CheckoutRevision_4);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CheckoutRevision_2, (String)Messages.CheckoutRevision_3, (IStatus)status);
        }
        Map<String, BranchMatch> potentialBranches = this.findAllPotentialBranches(localRepo);
        reActivateWorkspaceRevision = this.selectAndCheckoutBranch(localRepo, refSelected, potentialBranches);
        this.shouldRenameBranch(potentialBranches, refSelected, localRepo);
        if (reActivateWorkspaceRevision) {
            ActiveWorkspaceRevision.getInstance().activateCurrentRevision(this.gerritClient, this.revisionCheckedOut);
        }
    }

    private boolean selectAndCheckoutBranch(Repository localRepo, String refSelected, Map<String, BranchMatch> potentialBranches) {
        boolean reActivateWorkspaceRevision = true;
        if (potentialBranches.size() > 1) {
            reActivateWorkspaceRevision = this.branchUiSelection(localRepo, potentialBranches);
        } else if (potentialBranches.isEmpty()) {
            FetchGerritChangeWizard var = new FetchGerritChangeWizard(localRepo, refSelected);
            WizardDialog w = new WizardDialog(this.getShell(), (IWizard)var);
            w.create();
            int ret = w.open();
            if (ret == 1) {
                reActivateWorkspaceRevision = false;
            }
        } else if (potentialBranches.entrySet().iterator().next().getValue().equals((Object)BranchMatch.PERFECT_MATCH)) {
            this.setSelectedBranch(potentialBranches.keySet().iterator().next());
            try {
                this.checkoutBranch(this.getSelectedBranch(), localRepo);
            }
            catch (Exception exception) {}
        } else {
            reActivateWorkspaceRevision = this.branchUiSelection(localRepo, potentialBranches);
        }
        return reActivateWorkspaceRevision;
    }

    private void shouldRenameBranch(Map<String, BranchMatch> potentialBranches, String refSelected, Repository localRepo) {
        Change revisionRef;
        boolean isPerfect;
        if (this.getSelectedBranch() == null) {
            return;
        }
        BranchMatch branchMatch = potentialBranches.get(this.getSelectedBranch());
        boolean bl = isPerfect = branchMatch != null ? branchMatch.equals((Object)BranchMatch.PERFECT_MATCH) : false;
        if (isPerfect && !this.getSelectedBranch().trim().isEmpty() && (revisionRef = Change.fromRef(refSelected)) != null && !revisionRef.getBranchNameLabel().contains(this.getSelectedBranch())) {
            int lastSlash = this.getSelectedBranch().lastIndexOf(47);
            String perfectMatchModified = lastSlash == -1 ? this.getSelectedBranch() : this.getSelectedBranch().substring(0, lastSlash);
            this.checkBranchWithNoPatchSet(localRepo, revisionRef, perfectMatchModified);
        }
    }

    private void checkBranchWithNoPatchSet(Repository localRepo, Change revisionRef, String branchNoPatchSet) {
        if (revisionRef.getBranchNameLabel().contains(branchNoPatchSet)) {
            String newName = revisionRef.getBranchNameLabel();
            if (UIUtils.renameBranch(RENAME_KEY, Display.getDefault().getActiveShell(), Messages.CheckoutRevisionRenameBranchTitle, NLS.bind((String)Messages.CheckoutRevisionRenameBranch, (Object[])new String[]{Integer.toString(revisionRef.getPatchSet()), Integer.toString(revisionRef.getChangeNumber()), this.getSelectedBranch(), newName})) == 2) {
                this.renameBranch(newName, localRepo);
            }
        }
    }

    public Map<String, BranchMatch> findAllPotentialBranches(Repository localRepo) {
        Git gitRepo = new Git(localRepo);
        HashMap<String, String> mapBranches = new HashMap<String, String>();
        Map<String, BranchMatch> potentialBranches = null;
        HashMap<String, Map<String, List<String>>> mapBranchesChangeId = new HashMap<String, Map<String, List<String>>>();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (RevWalk walk = new RevWalk(localRepo);){
                this.mapBranchNameWithCommitId(gitRepo, mapBranches, mapBranchesChangeId, walk);
                potentialBranches = this.mapPotentialBranch(mapBranchesChangeId);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (GitAPIException e) {
            EGerritCorePlugin.logError((String)("find All Potential Branches()" + e.getMessage()));
        }
        gitRepo.close();
        return potentialBranches;
    }

    private void mapBranchNameWithCommitId(Git gitRepo, Map<String, String> mapBranches, Map<String, Map<String, List<String>>> mapBranchesChangeId, RevWalk walk) throws GitAPIException {
        for (Ref current : gitRepo.branchList().call()) {
            try {
                RevCommit commit = walk.parseCommit((AnyObjectId)current.getObjectId());
                mapBranches.put(Repository.shortenRefName((String)current.getName()), commit.getName());
                HashMap<String, List> mapCommitChangeid = new HashMap<String, List>();
                List footerLines = commit.getFooterLines("Change-Id");
                mapCommitChangeid.put(commit.getName(), footerLines);
                mapBranchesChangeId.put(Repository.shortenRefName((String)current.getName()), mapCommitChangeid);
            }
            catch (IOException e) {
                EGerritCorePlugin.logError((String)(String.valueOf(this.gerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
            }
        }
    }

    private boolean branchUiSelection(Repository localRepo, Map<String, BranchMatch> potentialBranches) {
        BranchSelectionDialog branchSelectDialog = new BranchSelectionDialog(null, potentialBranches, this.changeInfo, this.revisionCheckedOut);
        int result = branchSelectDialog.open();
        boolean returnOK = true;
        if (result == 1) {
            returnOK = false;
        }
        if (result == 0) {
            String psSelected = this.revisionCheckedOut.getRef();
            FetchGerritChangeWizard var = new FetchGerritChangeWizard(localRepo, psSelected);
            WizardDialog w = new WizardDialog(this.getShell(), (IWizard)var);
            w.create();
            int retCode = w.open();
            if (retCode == 1) {
                returnOK = false;
            }
        } else if (result == 1024) {
            try {
                this.setSelectedBranch(branchSelectDialog.getSelectedBranch());
                if (this.getSelectedBranch() != null) {
                    this.checkoutBranch(this.getSelectedBranch(), localRepo);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return returnOK;
    }

    private Map<String, BranchMatch> mapPotentialBranch(Map<String, Map<String, List<String>>> mapBranchesChangeId) {
        TreeMap<String, BranchMatch> mapBranches = new TreeMap<String, BranchMatch>();
        String defaultBranchName = String.valueOf(this.changeInfo.get_number()) + "/" + this.revisionCheckedOut.get_number();
        for (Map.Entry<String, Map<String, List<String>>> entryBranch : mapBranchesChangeId.entrySet()) {
            Map<String, List<String>> mapCommitId = entryBranch.getValue();
            for (Map.Entry<String, List<String>> entryCommitIds : mapCommitId.entrySet()) {
                List<String> listChangeIds = entryCommitIds.getValue();
                Iterator<String> iterChangeId = listChangeIds.iterator();
                while (iterChangeId.hasNext()) {
                    this.fillMappForPotentialBranch(mapBranches, defaultBranchName, entryBranch, entryCommitIds, iterChangeId);
                }
            }
        }
        return mapBranches;
    }

    private void fillMappForPotentialBranch(Map<String, BranchMatch> mapBranches, String defaultBranchName, Map.Entry<String, Map<String, List<String>>> entryBranch, Map.Entry<String, List<String>> entryCommitIds, Iterator<String> iterChangeId) {
        String lookingChangeId = this.revisionCheckedOut.getChangeInfo().getChange_id().trim();
        String lookingCommitIdForRevision = this.revisionCheckedOut.getCommit().getCommit().trim();
        String changeId = iterChangeId.next().trim();
        if (this.matchesPerfectlyAnotherRevision(this.revisionCheckedOut, entryCommitIds.getKey())) {
            return;
        }
        if (lookingCommitIdForRevision.equals(entryCommitIds.getKey())) {
            mapBranches.put(entryBranch.getKey(), BranchMatch.PERFECT_MATCH);
            return;
        }
        if (lookingChangeId.equals(changeId)) {
            mapBranches.put(entryBranch.getKey(), BranchMatch.CHANGE_ID_MATCH);
            return;
        }
        if (entryBranch.getKey().contains(defaultBranchName)) {
            mapBranches.put(entryBranch.getKey(), BranchMatch.BRANCH_NAME_MATCH);
            return;
        }
    }

    private boolean matchesPerfectlyAnotherRevision(RevisionInfo revisionToCheckOut, String commitId) {
        ChangeInfo review = revisionToCheckOut.getChangeInfo();
        for (RevisionInfo aRevision : review.getRevisions().values()) {
            if (aRevision == revisionToCheckOut || !commitId.equals(aRevision.getCommit().getCommit().trim())) continue;
            return true;
        }
        return false;
    }

    private void checkoutBranch(String branchName, Repository repo) throws Exception {
        block12: {
            CheckoutCommand command = null;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (Git gitRepo = new Git(repo);){
                    command = gitRepo.checkout();
                    command.setCreateBranch(false);
                    command.setName(branchName);
                    command.setForce(false);
                    command.call();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable t) {
                if (command == null) break block12;
                CheckoutResult result = command.getResult();
                if (result != null) {
                    new CheckoutConflictDialog(Display.getDefault().getActiveShell(), repo, result.getConflictList()).open();
                }
                EGerritCorePlugin.logError((String)(String.valueOf(this.gerritClient.getRepository().formatGerritVersion()) + t.getMessage()));
            }
        }
    }

    private Shell getShell() {
        return Display.getDefault().getActiveShell();
    }

    private void setSelectedBranch(String selectedBranch) {
        this.selectedBranch = selectedBranch;
    }

    private String getSelectedBranch() {
        return this.selectedBranch;
    }

    private void renameBranch(String newName, Repository repo) {
        RenameBranchCommand command = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Git gitRepo = new Git(repo);){
                command = gitRepo.branchRename();
                command.setNewName(newName);
                command.call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            UIUtils.displayInformation(Messages.CheckoutRevisionRenameBranchTitle, NLS.bind((String)Messages.CheckoutRevisionRenameException, (Object)e.getMessage()));
        }
    }

    private static final class Change {
        private final String refName;
        private final Integer changeNumber;
        private final Integer patchSetNumber;
        private static final String REF_CHANGES = "refs/changes/";

        static Change fromRef(String refName) {
            String[] tokens;
            block6: {
                block5: {
                    if (refName.startsWith(REF_CHANGES)) break block5;
                    return null;
                }
                int reflen = REF_CHANGES.length();
                tokens = refName.substring(reflen).split("/");
                if (tokens.length == 3) break block6;
                return null;
            }
            try {
                Integer changeNumber = Integer.valueOf(tokens[1]);
                Integer patchSetNumber = Integer.valueOf(tokens[2]);
                return new Change(refName, changeNumber, patchSetNumber);
            }
            catch (NumberFormatException e) {
                return null;
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }

        private Change(String refName, Integer changeNumber, Integer patchSetNumber) {
            this.refName = refName;
            this.changeNumber = changeNumber;
            this.patchSetNumber = patchSetNumber;
        }

        public String getBranchNameLabel() {
            return "change/" + this.changeNumber + "/" + this.patchSetNumber;
        }

        public Integer getPatchSet() {
            return this.patchSetNumber;
        }

        public Integer getChangeNumber() {
            return this.changeNumber;
        }

        public String toString() {
            return this.refName;
        }
    }
}

