/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.model.impl.StringToFileInfoImpl;
import org.eclipse.egerrit.internal.ui.table.UIFilesTable;
import org.eclipse.egerrit.internal.ui.table.provider.HandleFileSelection;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.egerrit.internal.ui.utils.UIUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class FilesDialog
extends Dialog {
    private static final String FILES_DIALOG = "egerrit.FilesDialog";
    private static final String VIEW_FILTER = "egerritViewFilter";
    private RevisionInfo fRevisionInfo;
    private GerritClient fGerritClient;
    private UIFilesTable tableUIFiles = null;
    private ModifyListener textModifyListener = null;
    private static final int WIDTH = 800;
    private static final int HEIGHT = 500;
    private FileEditorInput fFileInput = null;
    private TableViewer fViewer;
    private List<Button> listFilter = new ArrayList<Button>(5);
    private static FilesDialog openedDialog;

    public FilesDialog(RevisionInfo revisionInfo, GerritClient gerritClient, FileEditorInput fileInput) {
        super(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell());
        this.setShellStyle(0x10C70 | FilesDialog.getDefaultOrientation());
        this.fRevisionInfo = revisionInfo;
        this.fGerritClient = gerritClient;
        this.fFileInput = fileInput;
        openedDialog = this;
    }

    private static String buildDefaultMessage(RevisionInfo revisionInfo) {
        return NLS.bind((String)Messages.FileDialog_PatchSet, (Object[])new Object[]{revisionInfo.getChangeInfo().get_number(), revisionInfo.getChangeInfo().getSubject(), UIUtils.getPatchSetString(revisionInfo)});
    }

    protected int getShellStyle() {
        return 1232;
    }

    protected Control createDialogArea(final Composite parent) {
        parent.getShell().setText(Messages.FileDialog_title);
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText(FilesDialog.buildDefaultMessage(this.fRevisionInfo));
        GridData data = new GridData(4, 128, true, false);
        label.setLayoutData((Object)data);
        this.createTextMsgHandling(composite);
        this.tableUIFiles = new UIFilesTable(this.fGerritClient, this.fRevisionInfo, FILES_DIALOG);
        this.tableUIFiles.enablePopup(false);
        this.tableUIFiles.createTableViewerSection(composite);
        this.fViewer = this.tableUIFiles.getViewer();
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FilesDialog.this.storeDialogSettings();
                FilesDialog.this.close();
            }
        });
        this.tableUIFiles.setDialogSelection();
        this.createFilterArea(composite, this.tableUIFiles);
        this.restoreDialogSettings();
        parent.getShell().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Point size = parent.getShell().computeSize(800, 500);
                parent.getShell().setMinimumSize(size);
                parent.getShell().setSize(size);
                parent.getShell().removeControlListener((ControlListener)this);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.fViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 32) {
                    HandleFileSelection handleSelection = new HandleFileSelection(FilesDialog.this.fGerritClient, (ColumnViewer)FilesDialog.this.fViewer);
                    handleSelection.showFileSelection();
                    return;
                }
            }
        });
        Control[] children = this.getChildren(composite);
        this.addNavigationListener(children);
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            if (element instanceof Composite) {
                Control[] subChildren = this.getChildren((Composite)element);
                this.addNavigationListener(subChildren);
            }
            ++n2;
        }
        return parent;
    }

    private void addNavigationListener(Control[] control) {
        Control[] controlArray = control;
        int n = control.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            element.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    FilesDialog.this.handleKeyboardEvent(e);
                }
            });
            ++n2;
        }
    }

    private Control[] getChildren(Composite composite) {
        return composite.getChildren();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            HandleFileSelection handleSelection = new HandleFileSelection(this.fGerritClient, (ColumnViewer)this.fViewer);
            handleSelection.showFileSelection();
            this.storeDialogSettings();
        }
        super.buttonPressed(buttonId);
    }

    private void createFilterArea(Composite parent, UIFilesTable tableUIFiles) {
        Composite composite = new Composite(parent, 2048);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.listFilter.add(this.createDeleteFilterHandling(composite, tableUIFiles));
        this.listFilter.add(this.createCommitMsgHandling(composite, tableUIFiles));
        this.listFilter.add(this.createReviewedFilesHandling(composite, tableUIFiles));
        this.listFilter.add(this.createCommentedFilesHandling(composite, tableUIFiles));
    }

    private Button createDeleteFilterHandling(Composite composite, final UIFilesTable tableUIFiles) {
        final Button deleteFilter = new Button(composite, 32);
        deleteFilter.setText(Messages.FilesDialogDeleteFilter);
        deleteFilter.setSelection(false);
        GridData data = new GridData(4, 4, true, false);
        deleteFilter.setLayoutData((Object)data);
        deleteFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (deleteFilter.getSelection()) {
                    tableUIFiles.enableDeletedFilesFilter(false);
                } else {
                    tableUIFiles.enableDeletedFilesFilter(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return deleteFilter;
    }

    private Button createCommitMsgHandling(Composite composite, final UIFilesTable tableUIFiles) {
        final Button commitMsgFilter = new Button(composite, 32);
        commitMsgFilter.setText(Messages.FilesDialogCommitMessageFilter);
        commitMsgFilter.setSelection(true);
        GridData data = new GridData(4, 4, true, false);
        commitMsgFilter.setLayoutData((Object)data);
        commitMsgFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (commitMsgFilter.getSelection()) {
                    tableUIFiles.enableCommitMsgFilter(false);
                    int index = FilesDialog.this.getcommitMessageIndex(FilesDialog.this.fViewer.getTable());
                    if (index >= 0) {
                        FilesDialog.this.fViewer.getTable().setSelection(index);
                        FilesDialog.this.fViewer.setSelection(FilesDialog.this.fViewer.getSelection(), true);
                    }
                } else {
                    tableUIFiles.enableCommitMsgFilter(true);
                    if (FilesDialog.this.fViewer.getTable().getItemCount() >= 1) {
                        FilesDialog.this.fViewer.getTable().setSelection(0);
                        FilesDialog.this.fViewer.setSelection(FilesDialog.this.fViewer.getSelection(), true);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return commitMsgFilter;
    }

    private int getcommitMessageIndex(Table table) {
        TableItem[] items = table.getItems();
        int size = items.length;
        String COMMIT_MSG = "COMMIT_MSG".toLowerCase();
        int index = 0;
        while (index < size) {
            StringToFileInfoImpl data = (StringToFileInfoImpl)items[index].getData();
            if (data.getKey().toLowerCase().contains(COMMIT_MSG)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private Button createReviewedFilesHandling(Composite composite, final UIFilesTable tableUIFiles) {
        final Button reviewedFilesFilter = new Button(composite, 32);
        reviewedFilesFilter.setText(Messages.FilesDialogReviewedFilesFilter);
        reviewedFilesFilter.setSelection(true);
        GridData data = new GridData(4, 4, true, false);
        reviewedFilesFilter.setLayoutData((Object)data);
        reviewedFilesFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (reviewedFilesFilter.getSelection()) {
                    tableUIFiles.enableReviewedFilesFilter(false);
                } else {
                    tableUIFiles.enableReviewedFilesFilter(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        tableUIFiles.enableReviewedFilesFilter(false);
        return reviewedFilesFilter;
    }

    private Button createCommentedFilesHandling(Composite composite, final UIFilesTable tableUIFiles) {
        final Button commentedFilesFilter = new Button(composite, 32);
        commentedFilesFilter.setText(Messages.FilesDialogCommentedFilesFilter);
        commentedFilesFilter.setSelection(false);
        GridData data = new GridData(4, 4, true, false);
        commentedFilesFilter.setLayoutData((Object)data);
        commentedFilesFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (commentedFilesFilter.getSelection()) {
                    tableUIFiles.enableCommentedFilesFilter(true);
                } else {
                    tableUIFiles.enableCommentedFilesFilter(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return commentedFilesFilter;
    }

    private void createTextMsgHandling(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setBackground(parent.getDisplay().getSystemColor(25));
        final Text textMsgFilter = new Text(composite, 2048);
        GridData data = new GridData(4, 4, true, false);
        textMsgFilter.setLayoutData((Object)data);
        textMsgFilter.setText(Messages.TypeFilterText);
        textMsgFilter.setToolTipText(Messages.TypeFilterText);
        textMsgFilter.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ViewerFilter searchFilter;
                if (textMsgFilter.getText().isEmpty() && FilesDialog.this.textModifyListener != null) {
                    textMsgFilter.removeModifyListener(FilesDialog.this.textModifyListener);
                    FilesDialog.this.textModifyListener = null;
                }
                if ((searchFilter = FilesDialog.this.tableUIFiles.getSearchingFilter()) == null) {
                    textMsgFilter.append(Messages.TypeFilterText);
                }
            }

            public void focusGained(FocusEvent e) {
                ViewerFilter searchFilter = FilesDialog.this.tableUIFiles.getSearchingFilter();
                if (searchFilter == null) {
                    textMsgFilter.setText("");
                    textMsgFilter.addModifyListener(FilesDialog.this.modifyListener(textMsgFilter));
                }
            }
        });
        Button clearBtn = new Button(composite, 30);
        data = new GridData(131072, 4, false, false);
        clearBtn.setLayoutData((Object)data);
        clearBtn.setText(Messages.FilterClear);
        clearBtn.setToolTipText(Messages.FilterClearTooltip);
        clearBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                textMsgFilter.setText("");
                textMsgFilter.notifyListeners(16, new Event());
            }
        });
    }

    private void handleKeyboardEvent(KeyEvent e) {
        if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
            this.fViewer.getTable().setFocus();
        }
        if (e.keyCode == 13) {
            this.buttonPressed(0);
        }
    }

    private ModifyListener modifyListener(final Text textMsgFilter) {
        this.textModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FilesDialog.this.tableUIFiles != null) {
                    FilesDialog.this.tableUIFiles.filterFileText(textMsgFilter.getText().trim());
                }
            }
        };
        return this.textModifyListener;
    }

    private int findActiveFileInReview() {
        String filepath;
        if (this.tableUIFiles == null) {
            this.create();
        }
        if ((filepath = this.fFileInput.getFile().getFullPath().toString()).startsWith("/")) {
            filepath = filepath.substring(1, filepath.length());
        }
        TableItem[] tableItems = this.fViewer.getTable().getItems();
        int index = 0;
        while (index < tableItems.length) {
            StringToFileInfoImpl entry;
            if (tableItems[index].getData() instanceof StringToFileInfoImpl && (entry = (StringToFileInfoImpl)tableItems[index].getData()).getKey().endsWith(filepath)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void revealElementAt(int currentIndex) {
        Table table = this.fViewer.getTable();
        table.deselectAll();
        int maxTableItem = table.getItemCount() - 1;
        int nextIndex = currentIndex + 1;
        if (nextIndex < 0) {
            nextIndex = 0;
        }
        if (nextIndex <= maxTableItem) {
            table.setSelection(nextIndex);
        } else {
            table.setSelection(maxTableItem);
        }
        table.showSelection();
    }

    public int open() {
        int currentIndex;
        if (this.fFileInput != null && (currentIndex = this.findActiveFileInReview()) != -1) {
            this.revealElementAt(currentIndex);
        }
        return super.open();
    }

    private void storeDialogSettings() {
        String[] arrayBoolean = new String[this.listFilter.size()];
        int i = 0;
        while (i < this.listFilter.size()) {
            arrayBoolean[i] = String.valueOf(this.listFilter.get(i).getSelection());
            ++i;
        }
        this.tableUIFiles.getDialogSettings().put(VIEW_FILTER, arrayBoolean);
    }

    private void restoreDialogSettings() {
        String[] backedUpValue = this.tableUIFiles.getDialogSettings().getArray(VIEW_FILTER);
        if (backedUpValue != null) {
            int i = 0;
            while (i < backedUpValue.length) {
                this.listFilter.get(i).setSelection(StringConverter.asBoolean((String)backedUpValue[i]));
                this.listFilter.get(i).notifyListeners(13, new Event());
                ++i;
            }
        }
    }

    public boolean close() {
        openedDialog = null;
        return super.close();
    }

    public static FilesDialog openedDialog() {
        return openedDialog;
    }

    public void selectNextFile() {
        this.revealElementAt(this.fViewer.getTable().getSelectionIndex());
    }

    public void selectPreviousFile() {
        this.revealElementAt(this.fViewer.getTable().getSelectionIndex() - 2);
    }
}

