/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.commands.table;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egerrit.internal.dashboard.ui.commands.table.DashboardFactoryHandler;
import org.eclipse.egerrit.internal.dashboard.ui.preferences.Utils;
import org.eclipse.egerrit.internal.model.ActionConstants;
import org.eclipse.egerrit.internal.model.ActionInfo;
import org.eclipse.egerrit.internal.process.RebaseProcess;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class RebaseHandler
extends DashboardFactoryHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.getChangeInfo() != null && this.getGerritClient() != null) {
            ActionInfo rebaseInfo = this.getRevisionAction(ActionConstants.REBASE.getName());
            if (rebaseInfo != null && rebaseInfo.isEnabled()) {
                RebaseProcess rebaseProcess = new RebaseProcess();
                rebaseProcess.handleRebase(HandlerUtil.getActiveShell((ExecutionEvent)event), this.getChangeInfo(), this.getLatestRevision(), this.getGerritClient());
            } else {
                Utils.displayInformation(null, Messages.RebaseHandler_title, NLS.bind((String)Messages.RebaseHandler_notNecessary, (Object)this.getChangeInfo().getSubject()));
            }
        }
        return null;
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        boolean state = true;
        ActionInfo rebaseInfo = this.getRevisionAction(ActionConstants.REBASE.getName());
        state = rebaseInfo != null && rebaseInfo.isEnabled();
        this.setBaseEnabled(state);
    }

    @Override
    public void updateElement(UIElement element, Map parameters) {
        super.updateElement(element, parameters);
        String message = Messages.RebaseHandler_generalMessage;
        if (this.getChangeInfo() != null && this.getGerritClient() != null) {
            message = NLS.bind((String)Messages.RebaseHandler_specificMessage, (Object[])new Object[]{this.getLatestRevision().get_number(), this.getChangeInfo().get_number()});
        }
        element.setTooltip(message);
    }
}

