/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.tabs;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ChangeMessageInfo;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.ui.table.UIFilesTable;
import org.eclipse.egerrit.internal.ui.table.UIHistoryTable;
import org.eclipse.egerrit.internal.ui.table.provider.HistoryTableLabelProvider;
import org.eclipse.egerrit.internal.ui.tabs.HyperLinkDetector;
import org.eclipse.egerrit.internal.ui.tabs.HyperLinkPresenter;
import org.eclipse.egerrit.internal.ui.tabs.ObservableCollector;
import org.eclipse.egerrit.internal.ui.tabs.TextViewerWithLinks;
import org.eclipse.egerrit.internal.ui.utils.DataConverter;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class HistoryTabView {
    private TableViewer tableHistoryViewer;
    private TextViewerWithLinks msgTextData;
    private GerritClient gerritClient;
    private UIFilesTable tableUIFiles;
    private DataBindingContext dataBindingContext = new DataBindingContext();
    private ObservableCollector observableCollector = null;

    public void create(GerritClient gerritClient, TabFolder tabFolder, ChangeInfo changeInfo) {
        this.gerritClient = gerritClient;
        this.createControls(tabFolder, changeInfo);
    }

    private void createControls(TabFolder tabFolder, final ChangeInfo changeInfo) {
        TabItem tbtmHistory = new TabItem(tabFolder, 0);
        tbtmHistory.setText(Messages.HistoryTabView_0);
        SashForm sashForm = new SashForm((Composite)tabFolder, 512);
        tbtmHistory.setControl((Control)sashForm);
        UIHistoryTable tableUIHistory = new UIHistoryTable();
        tableUIHistory.createTableViewerSection((Composite)sashForm);
        this.tableHistoryViewer = tableUIHistory.getViewer();
        SashForm sashFormHorizon = new SashForm((Composite)sashForm, 256);
        this.msgTextData = new TextViewerWithLinks((Composite)sashFormHorizon, 2626);
        this.tableUIFiles = new UIFilesTable(this.gerritClient, changeInfo);
        this.tableUIFiles.createTableViewerSection((Composite)sashFormHorizon);
        sashFormHorizon.setWeights(new int[]{40, 60});
        this.msgTextData.configure(new SourceViewerConfiguration(){

            public int getHyperlinkStateMask(ISourceViewer sourceViewer) {
                return 0;
            }

            public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
                return new IHyperlinkDetector[]{new HyperLinkDetector(HistoryTabView.this.gerritClient, changeInfo)};
            }

            public IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
                HyperLinkPresenter presenter = new HyperLinkPresenter(new RGB(0, 0, 255), sourceViewer, HistoryTabView.this.gerritClient, changeInfo);
                return presenter;
            }
        });
        sashForm.setWeights(new int[]{40, 60});
        this.bind(changeInfo);
    }

    private void bind(ChangeInfo changeInfo) {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.tableHistoryViewer.setContentProvider((IContentProvider)contentProvider);
        FeaturePath authorName = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_MESSAGE_INFO__AUTHOR, ModelPackage.Literals.ACCOUNT_INFO__NAME});
        IObservableMap[] watchedProperties = Properties.observeEach((IObservableSet)contentProvider.getKnownElements(), (IValueProperty[])new IValueProperty[]{EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_MESSAGE_INFO__DATE), EMFProperties.value((FeaturePath)authorName), EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_MESSAGE_INFO__MESSAGE)});
        this.tableHistoryViewer.setLabelProvider((IBaseLabelProvider)new HistoryTableLabelProvider(watchedProperties, this.gerritClient));
        this.tableHistoryViewer.setInput((Object)EMFProperties.list((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__MESSAGES).observe((Object)changeInfo));
        IViewerObservableValue selection = ViewersObservables.observeSingleSelection((Viewer)this.tableHistoryViewer);
        IObservableValue textViewerDocument = BeanProperties.value(((Object)((Object)this.msgTextData)).getClass(), (String)"document").observe(Realm.getDefault(), (Object)this.msgTextData);
        UpdateValueStrategy textToDocumentStrategy = new UpdateValueStrategy();
        textToDocumentStrategy.setConverter(DataConverter.fromStringToDocument(this.gerritClient));
        this.dataBindingContext.bindValue(textViewerDocument, (IObservableValue)selection, null, textToDocumentStrategy);
        IObservableValue settableUserRevision = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__USER_SELECTED_REVISION).observe((Object)changeInfo);
        this.dataBindingContext.bindValue(settableUserRevision, (IObservableValue)selection, null, new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return null;
                }
                ChangeMessageInfo message = (ChangeMessageInfo)value;
                ChangeInfo containingChange = (ChangeInfo)message.eContainer();
                return containingChange.getRevisionByNumber(message.get_revision_number());
            }
        });
        this.observableCollector = new ObservableCollector(this.dataBindingContext);
    }

    public void dispose() {
        this.observableCollector.dispose();
        this.dataBindingContext.dispose();
        this.tableUIFiles.dispose();
    }
}

