/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.commands;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Status;
import org.eclipse.egerrit.internal.core.GerritServerInformation;
import org.eclipse.egerrit.internal.core.ServersStore;
import org.eclipse.egerrit.internal.core.command.ChangeState;
import org.eclipse.egerrit.internal.core.command.ChangeStatus;
import org.eclipse.egerrit.internal.dashboard.ui.preferences.GerritDashboardPreferencePage;
import org.eclipse.egerrit.internal.dashboard.ui.views.GerritTableView;
import org.eclipse.egerrit.internal.dashboard.utils.GerritServerUtility;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.menus.UIElement;

public class SelectReviewSiteHandler
extends AbstractHandler
implements IElementUpdater {
    private GerritServerUtility fServerUtil = GerritServerUtility.getInstance();

    public Object execute(ExecutionEvent aEvent) {
        GerritTableView reviewTableView = GerritTableView.getActiveView(true);
        GerritServerInformation server = this.getServer(aEvent.getParameter("org.eclipse.egerrit.dashboard.ui.selectCurrentGerrit.serverId"));
        if (server == null) {
            return Status.OK_STATUS;
        }
        reviewTableView.openView();
        this.fServerUtil.saveLastGerritServer(server);
        if (!server.getUserName().isEmpty()) {
            reviewTableView.processCommands("is:open AND (owner:self OR reviewer:self)");
        } else {
            reviewTableView.processCommands(String.valueOf(ChangeState.IS_OPEN.getValue()) + " " + ChangeStatus.OPEN.getValue());
        }
        return Status.OK_STATUS;
    }

    private GerritServerInformation getServer(String id) {
        GerritServerInformation resolvedServer = ServersStore.getServer((String)id);
        if (resolvedServer != null) {
            return resolvedServer;
        }
        GerritServerInformation savedServer = GerritServerUtility.getInstance().getLastSavedGerritServer();
        if (savedServer != null) {
            return savedServer;
        }
        List allServers = ServersStore.getAllServers();
        if (allServers.size() == 1) {
            return (GerritServerInformation)ServersStore.getAllServers().get(0);
        }
        if (allServers.size() == 0) {
            PreferenceDialog prefDialog = PreferencesUtil.createPreferenceDialogOn(null, (String)GerritDashboardPreferencePage.getID(), null, null);
            prefDialog.setBlockOnOpen(true);
            prefDialog.open();
            allServers = ServersStore.getAllServers();
            if (allServers.size() == 1) {
                return (GerritServerInformation)ServersStore.getAllServers().get(0);
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        String serverId = (String)parameters.get("org.eclipse.egerrit.dashboard.ui.selectCurrentGerrit.serverId");
        if (serverId == null) {
            element.setChecked(false);
            return;
        }
        GerritServerInformation savedServer = GerritServerUtility.getInstance().getLastSavedGerritServer();
        if (savedServer == null) {
            element.setChecked(false);
            return;
        }
        GerritServerInformation server = ServersStore.getServer((String)serverId);
        if (server == null) {
            element.setChecked(false);
            return;
        }
        if (savedServer.equals((Object)server)) {
            element.setChecked(true);
        } else {
            element.setChecked(false);
        }
    }
}

