/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.pde.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fx.ide.jdt.core.FXVersion;
import org.eclipse.fx.ide.jdt.core.FXVersionUtil;
import org.eclipse.fx.ide.jdt.core.internal.BuildPathSupport;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.IClasspathContributor;
import org.osgi.framework.Bundle;

public class JavaFXClassPathExtender
implements IClasspathContributor {
    private static boolean DEBUG = Boolean.getBoolean("efxclipse.pde.debug");

    private IVMInstall findVMForEnv(IExecutionEnvironment env) {
        IVMInstall vm;
        if (DEBUG) {
            System.err.println("JavaFXClasspathExtender - Look up vm for: " + env.getId());
        }
        if ((vm = env.getDefaultVM()) == null) {
            IVMInstall[] iVMInstallArray = env.getCompatibleVMs();
            int n = iVMInstallArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstall compatibleVM = iVMInstallArray[n2];
                if (env.isStrictlyCompatible(compatibleVM)) {
                    vm = compatibleVM;
                    break;
                }
                ++n2;
            }
        }
        if (DEBUG) {
            if (vm == null) {
                System.err.println("JavaFXClasspathExtender - No vm found");
            } else {
                System.err.println("JavaFXClasspathExtender - The default VM is: " + vm.getInstallLocation());
            }
        }
        return vm;
    }

    private IVMInstall getVM(BundleDescription project) {
        String[] stringArray = project.getExecutionEnvironments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            IExecutionEnvironment env = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(e);
            IVMInstall vm = this.findVMForEnv(env);
            if (vm != null) {
                return vm;
            }
            ++n2;
        }
        return null;
    }

    private IClasspathEntry getJavaCssExtEntry(FXVersion version) {
        switch (version) {
            case FX2: {
                return JavaFXClassPathExtender.getBundleAsEntryByName("org.eclipse.fx.ide.css.jfx2");
            }
            case FX8: {
                return JavaFXClassPathExtender.getBundleAsEntryByName("org.eclipse.fx.ide.css.jfx8");
            }
            case FX9: {
                return JavaFXClassPathExtender.getBundleAsEntryByName("org.eclipse.fx.ide.css.jfx8");
            }
        }
        return null;
    }

    private static IClasspathEntry getBundleAsEntryByName(String name) {
        try {
            Bundle bundle = Platform.getBundle((String)name);
            if (bundle != null) {
                File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                Path path = new Path(bundleFile.getAbsolutePath());
                return JavaCore.newLibraryEntry((IPath)path, null, null);
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private IClasspathEntry getSWTFXEntry(IVMInstall vm) {
        IPath[] swtFxJarPath = BuildPathSupport.getSwtFxJarPath((IVMInstall)vm);
        if (swtFxJarPath != null) {
            if (DEBUG) {
                System.err.println("JavaFXClasspathExtender - SWTFX is located at: " + swtFxJarPath[0]);
            }
            ArrayList<IAccessRule> l = new ArrayList<IAccessRule>();
            l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf("javafx.embed.swt".replace('.', '/')) + "/*"), (int)0));
            IClasspathAttribute[] extraAttributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)(swtFxJarPath[1] == null || !swtFxJarPath[1].toFile().exists() ? "http://docs.oracle.com/javase/8/javafx/api/" : swtFxJarPath[1].toFile().toURI().toString()))};
            return JavaCore.newLibraryEntry((IPath)swtFxJarPath[0], (IPath)swtFxJarPath[2], null, (IAccessRule[])l.toArray(new IAccessRule[0]), (IClasspathAttribute[])extraAttributes, (boolean)false);
        }
        if (DEBUG) {
            System.err.println("JavaFXClasspathExtender - Could not find swtfx.jar");
        }
        return null;
    }

    private IClasspathEntry getJavaFX2RuntimeEntry(IVMInstall vm, BundleDescription project) {
        IPath[] paths = BuildPathSupport.getFxJarPath((IVMInstall)vm);
        if (paths == null) {
            return null;
        }
        ArrayList<IAccessRule> l = new ArrayList<IAccessRule>();
        ImportPackageSpecification[] importPackageSpecificationArray = project.getImportPackages();
        int n = importPackageSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImportPackageSpecification i = importPackageSpecificationArray[n2];
            if (i.getName().startsWith("javafx")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)0));
            } else if (i.getName().startsWith("com.sun.browser")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.deploy")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.glass")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.javafx")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.media")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.openpisces")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.prism")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.scenario")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.t2k")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.webpane")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("netscape.javascript")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            } else if (i.getName().startsWith("com.sun.javafx.scene.text")) {
                l.add(JavaCore.newAccessRule((IPath)new Path(String.valueOf(i.getName().replace('.', '/')) + "/*"), (int)2));
            }
            ++n2;
        }
        IClasspathAttribute[] extraAttributes = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)(paths[1] == null || !paths[1].toFile().exists() ? "http://docs.oracle.com/javase/8/javafx/api/" : paths[1].toFile().toURI().toString()))};
        return JavaCore.newLibraryEntry((IPath)paths[0], null, null, (IAccessRule[])l.toArray(new IAccessRule[0]), (IClasspathAttribute[])extraAttributes, (boolean)false);
    }

    public List<IClasspathEntry> getInitialEntries(BundleDescription project) {
        IClasspathEntry jfx2Runtime;
        IClasspathEntry javaCssExtEntry;
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        IVMInstall vm = this.getVM(project);
        FXVersion version = FXVersionUtil.getFxVersion((IVMInstall)vm);
        if (DEBUG) {
            System.err.println("JavaFXClasspathExtender - The javafx version is: " + version);
        }
        if ((javaCssExtEntry = this.getJavaCssExtEntry(version)) != null) {
            entries.add(javaCssExtEntry);
        }
        if (version == FXVersion.FX8 || version == FXVersion.FX9) {
            IClasspathEntry swtFxEntry;
            if (DEBUG) {
                System.err.println("JavaFXClasspathExtender - This is FX8 only add the SWT-Lib ");
            }
            if ((swtFxEntry = this.getSWTFXEntry(vm)) != null) {
                if (DEBUG) {
                    System.err.println("JavaFXClasspathExtender - Adding swt entry");
                }
                entries.add(swtFxEntry);
            }
        }
        if (version == FXVersion.FX2 && (jfx2Runtime = this.getJavaFX2RuntimeEntry(vm, project)) != null) {
            entries.add(jfx2Runtime);
        }
        return entries;
    }

    public List<IClasspathEntry> getEntriesForDependency(BundleDescription project, BundleDescription addedDependency) {
        return Collections.emptyList();
    }
}

