/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxgraph.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ide.fxgraph.ui.contentassist.FXGraphProposalProvider;
import org.eclipse.fx.ide.fxgraph.ui.internal.FXGraphActivator;
import org.eclipse.fx.ide.fxgraph.ui.util.prop.IProposalProvider;
import org.eclipse.fx.ide.fxgraph.ui.util.prop.KeyCombinationProvider;
import org.eclipse.fx.ide.fxgraph.ui.util.prop.PaintProposalProvider;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.common.types.xtext.ui.JdtHoverProvider;
import org.eclipse.xtext.ui.editor.hover.IEObjectHover;

public class JDTHelper {
    public static final String FIELD_KEY = FXGraphProposalProvider.class.getName() + ".FIELD";
    public static final String EVENT_KEY = FXGraphProposalProvider.class.getName() + ".EVENT";
    public static final String LIST_KEY = FXGraphProposalProvider.class.getName() + ".LIST";
    public static final String MAP_KEY = FXGraphProposalProvider.class.getName() + ".MAP";
    public static final String ENUM_KEY = FXGraphProposalProvider.class.getName() + ".ENUM_KEY";
    public static final String METHOD_PRIVATE_KEY = FXGraphProposalProvider.class.getName() + ".METHOD_PRIVATE";
    public static final String METHOD_DEFAULT_KEY = FXGraphProposalProvider.class.getName() + ".METHOD_DEFAULT";
    public static final String METHOD_PROTECTED_KEY = FXGraphProposalProvider.class.getName() + ".METHOD_PROTECTED";
    public static final String METHOD_PUBLIC_KEY = FXGraphProposalProvider.class.getName() + ".METHOD_PUBLIC";
    public static final String STAT_METHOD_PUBLIC_KEY = FXGraphProposalProvider.class.getName() + ".STAT_METHOD_PUBLIC_KEY";
    public static final String EXTERNALIZED_STRING_KEY = FXGraphProposalProvider.class.getName() + ".EXTERNALIZED_STRING_KEY";
    public static final String CLASS_KEY = FXGraphProposalProvider.class.getName() + ".CLASS_KEY";
    public static final String PACKAGE_KEY = FXGraphProposalProvider.class.getName() + ".PACKAGE_KEY";
    public static final String COMPONENT_KEY = FXGraphProposalProvider.class.getName() + ".COMPONENT_KEY";
    public static final String IMPORT_LIST_KEY = FXGraphProposalProvider.class.getName() + ".IMPORT_LIST_KEY";
    public static final String IMPORT_KEY = FXGraphProposalProvider.class.getName() + ".IMPORT_KEY";
    public static final String BINDING_KEY = FXGraphProposalProvider.class.getName() + ".BINDING_KEY";
    public static final String REFERENCE_KEY = FXGraphProposalProvider.class.getName() + ".REFERENCE_KEY";
    public static final String INCLUDE_KEY = FXGraphProposalProvider.class.getName() + ".INCLUDE_KEY";
    public static final String COPY_KEY = FXGraphProposalProvider.class.getName() + ".COPY_KEY";
    public static final String LOCATION_KEY = FXGraphProposalProvider.class.getName() + ".LOCATION_KEY";
    public static final String DEFINES_KEY = FXGraphProposalProvider.class.getName() + ".DEFINES_KEY";
    public static final String SCRIPTS_KEY = FXGraphProposalProvider.class.getName() + ".SCRIPTS_KEY";
    private static final Map<String, IProposalProvider> PROVIDERS = new HashMap<String, IProposalProvider>();
    private Map<String, TypeData> typeCache = new HashMap<String, TypeData>();

    static {
        JFaceResources.getImageRegistry().put(FIELD_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/field_public_obj.gif"));
        JFaceResources.getImageRegistry().put(EVENT_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/correction_change.gif"));
        JFaceResources.getImageRegistry().put(LIST_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/class_hi.gif"));
        JFaceResources.getImageRegistry().put(MAP_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/types.gif"));
        JFaceResources.getImageRegistry().put(METHOD_PRIVATE_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/methpri_obj.gif"));
        JFaceResources.getImageRegistry().put(METHOD_DEFAULT_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/methdef_obj.gif"));
        JFaceResources.getImageRegistry().put(METHOD_PROTECTED_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/methpro_obj.gif"));
        JFaceResources.getImageRegistry().put(METHOD_PUBLIC_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/methpub_obj.gif"));
        JFaceResources.getImageRegistry().put(STAT_METHOD_PUBLIC_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/statmethpub_obj.gif"));
        JFaceResources.getImageRegistry().put(EXTERNALIZED_STRING_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/internalize.gif"));
        JFaceResources.getImageRegistry().put(CLASS_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/class_obj.gif"));
        JFaceResources.getImageRegistry().put(PACKAGE_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/packd_obj.gif"));
        JFaceResources.getImageRegistry().put(COMPONENT_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/cu_obj.gif"));
        JFaceResources.getImageRegistry().put(IMPORT_LIST_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/impc_obj.gif"));
        JFaceResources.getImageRegistry().put(IMPORT_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/imp_obj.gif"));
        JFaceResources.getImageRegistry().put(BINDING_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/occ_write.gif"));
        JFaceResources.getImageRegistry().put(REFERENCE_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/no_breakpoint.gif"));
        JFaceResources.getImageRegistry().put(INCLUDE_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/inclusion_filter_attrib.gif"));
        JFaceResources.getImageRegistry().put(COPY_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/template_obj.gif"));
        JFaceResources.getImageRegistry().put(LOCATION_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/jar_desc_obj.gif"));
        JFaceResources.getImageRegistry().put(DEFINES_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/correction_cast.gif"));
        JFaceResources.getImageRegistry().put(SCRIPTS_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/classf_generate.gif"));
        JFaceResources.getImageRegistry().put(ENUM_KEY, FXGraphActivator.imageDescriptorFromPlugin((String)"org.eclipse.fx.ide.fxgraph.ui", (String)"/icons/enum_obj.gif"));
        PROVIDERS.put("javafx.scene.paint.Paint", new PaintProposalProvider());
        PROVIDERS.put("javafx.scene.input.KeyCombination", new KeyCombinationProvider());
    }

    public TypeData getTypeData(IJavaProject jproject, IType jdtType) {
        if (jdtType == null) {
            return null;
        }
        TypeData data = this.typeCache.get(jdtType.getFullyQualifiedName());
        if (data == null) {
            try {
                ArrayList<IMethod> allMethods = new ArrayList<IMethod>();
                allMethods.addAll(Arrays.asList(jdtType.getMethods()));
                IType parentType = jdtType;
                while (parentType != null && parentType.getSuperclassName() != null) {
                    if (parentType instanceof SourceType) {
                        String[][] typeDefs = parentType.resolveType(parentType.getSuperclassName());
                        if (typeDefs != null) {
                            String[][] stringArray = typeDefs;
                            int n = typeDefs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String[] type = stringArray[n2];
                                parentType = jproject.findType(type[0] + "." + type[1]);
                                ++n2;
                            }
                        }
                    } else {
                        parentType = jproject.findType(parentType.getSuperclassName());
                    }
                    if (parentType == null) continue;
                    allMethods.addAll(Arrays.asList(parentType.getMethods()));
                }
                data = this.createData(allMethods, jproject);
                if (!(jdtType instanceof SourceType)) {
                    this.typeCache.put(jdtType.getFullyQualifiedName(), data);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    private TypeData createData(List<IMethod> allMethods, IJavaProject jproject) throws JavaModelException {
        TypeData d = new TypeData();
        for (IMethod m : allMethods) {
            String propName;
            boolean isReadonly;
            JDTHelperProperty p;
            if (!Flags.isPublic((int)m.getFlags()) || m.getElementName().startsWith("impl_") || m.getElementName().startsWith("getImpl_")) continue;
            if (m.getElementName().startsWith("get") && m.getParameterNames().length == 0) {
                JDTHelperProperty p2;
                String i;
                int n;
                int n2;
                String[] stringArray;
                PrimitivValueProperty p3;
                String returnSignature = Signature.toString((String)m.getReturnType());
                if (returnSignature.startsWith("javafx.event.EventHandler<? super ") || returnSignature.startsWith("javafx.event.EventHandler<")) {
                    String eventType = returnSignature.startsWith("javafx.event.EventHandler<? super ") ? returnSignature.substring("javafx.event.EventHandler<? super ".length(), returnSignature.length() - 1) : returnSignature.substring("javafx.event.EventHandler<".length(), returnSignature.length() - 1);
                    p = new EventValueProperty(m, JDTHelper.extractAttributename(m.getElementName()), m.getParent().getElementName(), eventType);
                    d.properties.add(p);
                    continue;
                }
                String propName2 = JDTHelper.extractAttributename(m.getElementName());
                String ownerName = m.getParent().getElementName();
                boolean isReadonly2 = this.isReadonlySetter(propName2, allMethods);
                if ("double".equals(returnSignature) || "float".equals(returnSignature)) {
                    if (isReadonly2) continue;
                    p3 = new FloatingValueProperty(m, propName2, ownerName, returnSignature);
                    d.properties.add(p3);
                    continue;
                }
                if ("int".equals(returnSignature) || "long".equals(returnSignature) || "short".equals(returnSignature) || "byte".equals(returnSignature) || "char".equals(returnSignature)) {
                    if (isReadonly2) continue;
                    p3 = new IntegerValueProperty(m, propName2, ownerName, returnSignature);
                    d.properties.add(p3);
                    continue;
                }
                IType type = returnSignature.indexOf(60) == -1 ? jproject.findType(returnSignature) : jproject.findType(returnSignature.substring(0, returnSignature.indexOf(60)));
                if (type == null) continue;
                if (type.isEnum()) {
                    if (isReadonly2) continue;
                    EnumValueProperty p4 = new EnumValueProperty(m, propName2, ownerName, returnSignature, type);
                    d.properties.add(p4);
                    continue;
                }
                boolean isLists = false;
                boolean isMap = false;
                if ("java.util.List".equals(type.getFullyQualifiedName())) {
                    isLists = true;
                } else {
                    stringArray = type.getSuperInterfaceNames();
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        i = stringArray[n];
                        if (i.equals("java.util.List")) {
                            isLists = true;
                        }
                        ++n;
                    }
                }
                if (!isLists) {
                    if ("java.util.Map".equals(type.getFullyQualifiedName())) {
                        isMap = true;
                    } else {
                        stringArray = type.getSuperInterfaceNames();
                        n2 = stringArray.length;
                        n = 0;
                        while (n < n2) {
                            i = stringArray[n];
                            if (i.equals("java.util.Map")) {
                                isMap = true;
                            }
                            ++n;
                        }
                    }
                }
                if (isLists) {
                    String listType = returnSignature.indexOf(60) != -1 ? returnSignature.substring(returnSignature.indexOf(60) + 1, returnSignature.lastIndexOf(62)) : "?";
                    if (propName2.endsWith("Unmodifiable")) continue;
                    ListValueProperty p5 = new ListValueProperty(m, propName2, ownerName, listType, isReadonly2);
                    d.properties.add(p5);
                    continue;
                }
                if (isMap) {
                    p2 = new MapValueProperty(m, propName2, ownerName);
                    d.properties.add(p2);
                    continue;
                }
                if (type.getFullyQualifiedName().equals("java.lang.String")) {
                    if (isReadonly2) continue;
                    p2 = new StringValueProperty(m, propName2, ownerName, returnSignature);
                    d.properties.add(p2);
                    continue;
                }
                if (isReadonly2) continue;
                List<Proposal> props = this.getProposals(type, jproject);
                ElementValueProperty p6 = new ElementValueProperty(m, propName2, ownerName, returnSignature, props);
                d.properties.add(p6);
                continue;
            }
            if (!m.getElementName().startsWith("is") || m.getParameterNames().length != 0 || !"Z".equals(m.getReturnType()) || (isReadonly = this.isReadonlySetter(propName = JDTHelper.extractAttributename(m.getElementName()), allMethods))) continue;
            p = new BooleanValueProperty(m, propName, m.getParent().getElementName(), "boolean");
            d.properties.add(p);
        }
        return d;
    }

    private List<Proposal> getProposals(IType type, IJavaProject jp) {
        if (PROVIDERS.containsKey(type.getFullyQualifiedName())) {
            return PROVIDERS.get(type.getFullyQualifiedName()).getProposals(jp);
        }
        try {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                if (Flags.isStatic((int)m.getFlags()) && "valueOf".equals(m.getElementName())) {
                    Proposal p = new Proposal("\"<string>\"");
                    p.hover = new HoverImpl(m);
                    return Collections.singletonList(p);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    private boolean isReadonlySetter(String name, List<IMethod> methods) throws JavaModelException {
        for (IMethod m : methods) {
            if (!m.getElementName().startsWith("set") || !Flags.isPublic((int)m.getFlags()) || !name.equals(JDTHelper.extractAttributename(m.getElementName()))) continue;
            return false;
        }
        return true;
    }

    public static String extractAttributename(String name) {
        Object rv = null;
        if (name.startsWith("get") || name.startsWith("set")) {
            rv = name.substring(3);
        } else if (name.startsWith("is")) {
            rv = name.substring(2);
        }
        if (rv != null) {
            rv = ((String)rv).substring(0, 1).toLowerCase() + ((String)rv).substring(1);
        }
        return rv;
    }

    public static class BooleanValueProperty
    extends PrimitivValueProperty {
        private static final List<Proposal> PROPOSALS = new ArrayList<Proposal>();

        static {
            PROPOSALS.add(new Proposal("true"));
            PROPOSALS.add(new Proposal("false"));
        }

        public BooleanValueProperty(IMethod method, String name, String owner, String returnType) {
            super(method, name, owner, returnType);
        }

        @Override
        public List<Proposal> getProposals() {
            return PROPOSALS;
        }
    }

    public static abstract class DialogProposal
    extends Proposal {
        public DialogProposal(int prio, String label) {
            super(label, prio);
        }

        public abstract String openProposal();
    }

    public static class ElementValueProperty
    extends JDTHelperSingleValueProperty {
        private List<Proposal> props;

        public ElementValueProperty(IMethod method, String name, String owner, String returnType, List<Proposal> props) {
            super(method, name, owner, returnType);
            this.props = props;
        }

        @Override
        public List<Proposal> getProposals() {
            return this.props;
        }
    }

    public static class EnumValueProperty
    extends JDTHelperSingleValueProperty {
        private final List<Proposal> proposals = new ArrayList<Proposal>();

        public EnumValueProperty(IMethod method, String name, String owner, String returnType, IType type) {
            super(method, name, owner, returnType);
            try {
                IField[] iFieldArray = type.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IField c = iFieldArray[n2];
                    if (Flags.isEnum((int)c.getFlags())) {
                        StyledString s = new StyledString(c.getElementName());
                        s.append(" : " + type.getElementName(), StyledString.QUALIFIER_STYLER);
                        this.proposals.add(new Proposal("\"" + c.getElementName() + "\"", s, JFaceResources.getImage((String)ENUM_KEY)));
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }

        @Override
        public List<Proposal> getProposals() {
            return this.proposals;
        }
    }

    public static class EventValueProperty
    extends JDTHelperProperty {
        final String eventType;

        public EventValueProperty(IMethod method, String name, String owner, String eventType) {
            super(method, name, owner);
            this.eventType = eventType;
        }

        @Override
        public StyledString getDescription() {
            StyledString description = new StyledString(this.name + "(" + this.eventType.substring(this.eventType.lastIndexOf(46) + 1) + ")");
            description.append(" - " + this.owner, StyledString.QUALIFIER_STYLER);
            return description;
        }

        @Override
        public Image getIcon() {
            return JFaceResources.getImage((String)EVENT_KEY);
        }

        @Override
        public List<Proposal> getProposals() {
            return Collections.emptyList();
        }
    }

    public static class FloatingValueProperty
    extends PrimitivValueProperty {
        private static final List<Proposal> PROPOSALS = new ArrayList<Proposal>();

        static {
            PROPOSALS.add(new Proposal("1.0"));
        }

        public FloatingValueProperty(IMethod method, String name, String owner, String returnType) {
            super(method, name, owner, returnType);
        }

        @Override
        public List<Proposal> getProposals() {
            return PROPOSALS;
        }
    }

    public static class HoverImpl
    implements IEObjectHover,
    ITextHoverExtension {
        private JdtHoverProvider.JavadocHoverWrapper javadocHover = new JdtHoverProvider.JavadocHoverWrapper();
        private IMethod method;

        public HoverImpl(IMethod method) {
            this.method = method;
        }

        public Object getHoverInfo(EObject eObject, ITextViewer textViewer, IRegion hoverRegion) {
            this.javadocHover.setJavaElement((IJavaElement)this.method);
            return this.javadocHover.getHoverInfo2(textViewer, hoverRegion);
        }

        public IInformationControlCreator getHoverControlCreator() {
            return this.javadocHover.getHoverControlCreator();
        }
    }

    public static class IntegerValueProperty
    extends PrimitivValueProperty {
        private static final List<Proposal> PROPOSALS = new ArrayList<Proposal>();

        static {
            PROPOSALS.add(new Proposal("1"));
        }

        public IntegerValueProperty(IMethod method, String name, String owner, String returnType) {
            super(method, name, owner, returnType);
        }

        @Override
        public List<Proposal> getProposals() {
            return PROPOSALS;
        }
    }

    public static abstract class JDTHelperProperty
    implements Comparable<JDTHelperProperty> {
        public final String name;
        public final String owner;
        public final IMethod method;

        public JDTHelperProperty(IMethod method, String name, String owner) {
            this.method = method;
            this.name = name;
            this.owner = owner;
        }

        public abstract StyledString getDescription();

        public abstract Image getIcon();

        public abstract List<Proposal> getProposals();

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JDTHelperProperty other = (JDTHelperProperty)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        @Override
        public int compareTo(JDTHelperProperty arg0) {
            return this.name.compareTo(arg0.name);
        }
    }

    public static abstract class JDTHelperSingleValueProperty
    extends JDTHelperProperty {
        private String returnType;

        public JDTHelperSingleValueProperty(IMethod method, String name, String owner, String returnType) {
            super(method, name, owner);
            this.returnType = returnType;
        }

        @Override
        public Image getIcon() {
            return JFaceResources.getImage((String)FIELD_KEY);
        }

        @Override
        public StyledString getDescription() {
            StyledString description = new StyledString(this.name + " : " + this.returnType);
            description.append(" - " + this.owner, StyledString.QUALIFIER_STYLER);
            return description;
        }
    }

    public static class ListValueProperty
    extends MultiValueProperty {
        String elementType;
        boolean isReadonly;

        public ListValueProperty(IMethod method, String name, String owner, String elementType, boolean isReadonly) {
            super(method, name, owner);
            this.elementType = elementType;
            this.isReadonly = isReadonly;
        }

        @Override
        public StyledString getDescription() {
            if (this.isReadonly) {
                StyledString description = new StyledString(this.name + " : [" + this.elementType + "]");
                description.append(" - " + this.owner, StyledString.QUALIFIER_STYLER);
                return description;
            }
            try {
                StyledString description = new StyledString(this.name + " : " + Signature.getSignatureSimpleName((String)this.method.getReturnType()));
                description.append(" - " + this.owner, StyledString.QUALIFIER_STYLER);
                return description;
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                return new StyledString(this.name + " : <UnknownType>");
            }
        }

        @Override
        public Image getIcon() {
            return JFaceResources.getImage((String)LIST_KEY);
        }

        @Override
        public List<Proposal> getProposals() {
            if (this.isReadonly) {
                return Collections.singletonList(new Proposal("[]"));
            }
            return Collections.emptyList();
        }
    }

    public static class MapValueProperty
    extends MultiValueProperty {
        public MapValueProperty(IMethod method, String name, String owner) {
            super(method, name, owner);
        }

        @Override
        public StyledString getDescription() {
            StyledString description = new StyledString(this.name + " : {}");
            description.append(" - " + this.owner, StyledString.QUALIFIER_STYLER);
            return description;
        }

        @Override
        public Image getIcon() {
            return JFaceResources.getImage((String)MAP_KEY);
        }

        @Override
        public List<Proposal> getProposals() {
            return Collections.singletonList(new Proposal("{}"));
        }
    }

    public static abstract class MultiValueProperty
    extends JDTHelperProperty {
        public MultiValueProperty(IMethod method, String name, String owner) {
            super(method, name, owner);
        }
    }

    public static abstract class PrimitivValueProperty
    extends JDTHelperSingleValueProperty {
        public PrimitivValueProperty(IMethod method, String name, String owner, String returnType) {
            super(method, name, owner, returnType);
        }
    }

    public static abstract class ProcessedProposal
    extends Proposal {
        public ProcessedProposal(String label) {
            super(label);
        }

        public abstract String getProcessed();
    }

    public static class Proposal {
        public final String value;
        public final StyledString description;
        public final Image icon;
        public final int prio;
        public IEObjectHover hover;

        public Proposal(String value) {
            this(value, null, null);
        }

        public Proposal(String value, int prio) {
            this(value, null, null, prio);
        }

        public Proposal(String value, StyledString description, Image icon) {
            this.value = value;
            this.description = description;
            this.icon = icon;
            this.prio = 600;
        }

        public Proposal(String value, StyledString description, Image icon, int prio) {
            this.value = value;
            this.description = description;
            this.icon = icon;
            this.prio = prio;
        }
    }

    public static class StringValueProperty
    extends PrimitivValueProperty {
        private static final List<Proposal> PROPOSALS = new ArrayList<Proposal>();

        static {
            PROPOSALS.add(new Proposal("\"value\""));
        }

        public StringValueProperty(IMethod method, String name, String owner, String returnType) {
            super(method, name, owner, returnType);
        }

        @Override
        public List<Proposal> getProposals() {
            return PROPOSALS;
        }
    }

    public static class TypeData {
        public SortedSet<JDTHelperProperty> properties = new TreeSet<JDTHelperProperty>();
    }
}

