/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.compiler;

import com.google.common.base.Objects;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import org.eclipse.fx.ide.fxml.compiler.BitOperations;
import org.eclipse.fx.ide.fxml.compiler.ReflectionFX;
import org.eclipse.fx.ide.fxml.compiler.ValueType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ReflectionHelper {
    private static Class<?> EVENT_HANDLER_CLASS = new Functions.Function0<Class<?>>(){

        public Class<?> apply() {
            try {
                ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
                Class<?> _forName = Class.forName("javafx.event.EventHandler", false, _classLoader);
                return _forName;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }.apply();
    private static Class<?> OBSERVABLELIST_CLASS = new Functions.Function0<Class<?>>(){

        public Class<?> apply() {
            try {
                ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
                Class<?> _forName = Class.forName("javafx.collections.ObservableList", false, _classLoader);
                return _forName;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
    }.apply();

    public static boolean isAssignable(JvmTypeReference target, JvmTypeReference source) {
        try {
            String _qualifiedName = target.getQualifiedName();
            ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
            Class<?> targetClass = Class.forName(_qualifiedName, false, _classLoader);
            String _qualifiedName_1 = source.getQualifiedName();
            ClassLoader _classLoader_1 = ReflectionHelper.class.getClassLoader();
            Class<?> sourceClass = Class.forName(_qualifiedName_1, false, _classLoader_1);
            return targetClass.isAssignableFrom(sourceClass);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean hasNoArgConstructor(JvmTypeReference type) {
        try {
            Constructor<?> _constructor;
            boolean _notEquals;
            int _modifiers;
            boolean _isAbstract;
            boolean _not_1;
            boolean _not;
            String _qualifiedName = type.getQualifiedName();
            ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
            Class<?> c = Class.forName(_qualifiedName, false, _classLoader);
            boolean _and = false;
            boolean _and_1 = false;
            boolean _isInterface = c.isInterface();
            boolean bl = _not = !_isInterface;
            _and_1 = !_not ? false : (_not_1 = !(_isAbstract = Modifier.isAbstract(_modifiers = c.getModifiers())));
            _and = !_and_1 ? false : (_notEquals = !Objects.equal(_constructor = c.getConstructor(new Class[0]), null));
            return _and;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getEnumType(JvmTypeReference type, String attributeName, final boolean layoutConstraint) {
        try {
            boolean _isEnum;
            String _qualifiedName = type.getQualifiedName();
            ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
            Class<?> c = Class.forName(_qualifiedName, false, _classLoader);
            String _firstUpper = StringExtensions.toFirstUpper((String)attributeName);
            final String methodName = "set" + _firstUpper;
            Method[] _methods = c.getMethods();
            Functions.Function1<Method, Boolean> _function = new Functions.Function1<Method, Boolean>(){

                public Boolean apply(Method it) {
                    boolean _and = false;
                    String _name = it.getName();
                    boolean _equals = Objects.equal((Object)_name, (Object)methodName);
                    if (!_equals) {
                        _and = false;
                    } else {
                        boolean _equals_1;
                        boolean _or = false;
                        Class<?>[] _parameterTypes = it.getParameterTypes();
                        int _length = _parameterTypes.length;
                        boolean bl = _equals_1 = _length == 1;
                        if (_equals_1) {
                            _or = true;
                        } else {
                            Class<?>[] _parameterTypes_1;
                            int _length_1;
                            boolean _equals_2;
                            boolean _and_1 = false;
                            _and_1 = !layoutConstraint ? false : (_equals_2 = (_length_1 = (_parameterTypes_1 = it.getParameterTypes()).length) == 2);
                            _or = _and_1;
                        }
                        _and = _or;
                    }
                    return _and;
                }
            };
            Method m = (Method)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_methods)), (Functions.Function1)_function);
            Class<?>[] _parameterTypes = null;
            if (m != null) {
                _parameterTypes = m.getParameterTypes();
            }
            Class<?> _get = null;
            if (_parameterTypes != null) {
                int _xifexpression = 0;
                _xifexpression = layoutConstraint ? 1 : 0;
                _get = _parameterTypes[_xifexpression];
            }
            Class<?> t = _get;
            String _xifexpression_1 = null;
            boolean _and = false;
            boolean _notEquals = !Objects.equal(t, null);
            _and = !_notEquals ? false : (_isEnum = t.isEnum());
            if (_and) {
                String _name = null;
                if (t != null) {
                    _name = t.getName();
                }
                _xifexpression_1 = _name;
            } else {
                _xifexpression_1 = null;
            }
            return _xifexpression_1;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean hasMethod(JvmTypeReference type, String name, Class<?> ... parameters) {
        String _qualifiedName = type.getQualifiedName();
        ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
        Class<?> c = Class.forName(_qualifiedName, false, _classLoader);
        try {
            c.getDeclaredMethod(name, parameters);
            return true;
        }
        catch (Throwable _t) {
            block6: {
                try {
                    if (!(_t instanceof NoSuchMethodException)) break block6;
                    NoSuchMethodException cfr_ignored_0 = (NoSuchMethodException)_t;
                    return false;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static Field findField(Class<?> c, String name) {
        try {
            NoSuchFieldException initialException = null;
            Class<?> l = c;
            while (!Objects.equal(l, null) && !Objects.equal(l, Object.class)) {
                try {
                    return l.getDeclaredField(name);
                }
                catch (Throwable _t) {
                    if (_t instanceof NoSuchFieldException) {
                        NoSuchFieldException e = (NoSuchFieldException)_t;
                        boolean _equals = Objects.equal(initialException, null);
                        if (_equals) {
                            initialException = e;
                        }
                    } else {
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    Class<?> _superclass = l.getSuperclass();
                    l = _superclass;
                }
            }
            throw initialException;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean hasField(JvmTypeReference type, String refPackage, String name) {
        String _qualifiedName = type.getQualifiedName();
        ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
        Class<?> c = Class.forName(_qualifiedName, false, _classLoader);
        try {
            ReflectionHelper.findField(c, name);
            return true;
        }
        catch (Throwable _t) {
            block6: {
                try {
                    if (!(_t instanceof NoSuchFieldException)) break block6;
                    NoSuchFieldException cfr_ignored_0 = (NoSuchFieldException)_t;
                    return false;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static boolean hasAccessibleField(JvmTypeReference type, String refPackage, String name) {
        Class<?> c;
        block5: {
            Field field;
            block4: {
                try {
                    String _qualifiedName = type.getQualifiedName();
                    ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
                    c = Class.forName(_qualifiedName, false, _classLoader);
                    field = ReflectionHelper.findField(c, name);
                    int _modifiers = field.getModifiers();
                    boolean _bitSet = BitOperations.bitSet(_modifiers, 1);
                    if (!_bitSet) break block4;
                    return true;
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
            int _modifiers_1 = field.getModifiers();
            boolean _bitSet_1 = BitOperations.bitSet(_modifiers_1, 2);
            if (!_bitSet_1) break block5;
            return false;
        }
        Package _package = c.getPackage();
        String _name = _package.getName();
        boolean _equals = Objects.equal((Object)_name, (Object)refPackage);
        return _equals;
    }

    public static String getFieldOwner(JvmTypeReference type, String name) {
        try {
            String _qualifiedName = type.getQualifiedName();
            ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
            Class<?> c = Class.forName(_qualifiedName, false, _classLoader);
            Field _findField = ReflectionHelper.findField(c, name);
            Class<?> _declaringClass = _findField.getDeclaringClass();
            return _declaringClass.getName();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean needsBuilder(JvmTypeReference type) {
        try {
            String _qualifiedName = type.getQualifiedName();
            ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
            Class<?> c = Class.forName(_qualifiedName, false, _classLoader);
            Constructor<?>[] _constructors = c.getConstructors();
            Functions.Function1 _function = new Functions.Function1<Constructor<?>, Boolean>(){

                public Boolean apply(Constructor<?> it) {
                    Class<?>[] _parameterTypes = it.getParameterTypes();
                    int _length = _parameterTypes.length;
                    return _length == 0;
                }
            };
            Constructor _findFirst = (Constructor)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray(_constructors)), (Functions.Function1)_function);
            return Objects.equal((Object)_findFirst, null);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String defaultAttribute(JvmTypeReference type) {
        try {
            return ReflectionFX.defaultAttribute(type);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String eventType(JvmTypeReference type, String name) {
        try {
            String _qualifiedName = type.getQualifiedName();
            ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
            Class<?> c = Class.forName(_qualifiedName, false, _classLoader);
            String _firstUpper = StringExtensions.toFirstUpper((String)name);
            String _plus = "get" + _firstUpper;
            Method m = c.getMethod(_plus, new Class[0]);
            Class<?> _returnType = m.getReturnType();
            boolean _equals = _returnType.equals(EVENT_HANDLER_CLASS);
            if (_equals) {
                Type _genericReturnType = m.getGenericReturnType();
                ParameterizedType gt = (ParameterizedType)_genericReturnType;
                Type[] _actualTypeArguments = gt.getActualTypeArguments();
                Type t = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_actualTypeArguments)));
                if (t instanceof WildcardType) {
                    WildcardType wt = (WildcardType)t;
                    Type[] _lowerBounds = wt.getLowerBounds();
                    Type _head = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_lowerBounds)));
                    return _head.getTypeName();
                }
                return t.getTypeName();
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String listType(JvmTypeReference type, String name) {
        try {
            String _qualifiedName = type.getQualifiedName();
            ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
            Class<?> c = Class.forName(_qualifiedName, false, _classLoader);
            String _firstUpper = StringExtensions.toFirstUpper((String)name);
            String _plus = "get" + _firstUpper;
            Method m = c.getMethod(_plus, new Class[0]);
            Class<?> _returnType = m.getReturnType();
            boolean _equals = _returnType.equals(OBSERVABLELIST_CLASS);
            if (_equals) {
                Type _genericReturnType = m.getGenericReturnType();
                ParameterizedType gt = (ParameterizedType)_genericReturnType;
                Type[] _actualTypeArguments = gt.getActualTypeArguments();
                Type t = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_actualTypeArguments)));
                if (t instanceof WildcardType) {
                    WildcardType wt = (WildcardType)t;
                    Type[] _lowerBounds = wt.getLowerBounds();
                    Type _head = (Type)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_lowerBounds)));
                    return _head.getTypeName();
                }
                return t.getTypeName();
            }
            return null;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static String getFqnType(String simpleName, Map<String, String> imports, List<String> globalImports) {
        boolean _contains = simpleName.contains(".");
        if (_contains) {
            return simpleName;
        }
        String rv = imports.get(simpleName);
        boolean _equals = Objects.equal((Object)rv, null);
        if (_equals) {
            for (String ns : globalImports) {
                try {
                    ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
                    Class<?> c = Class.forName(String.valueOf(ns) + "." + simpleName, false, _classLoader);
                    String _simpleName = c.getSimpleName();
                    String _name = c.getName();
                    imports.put(_simpleName, _name);
                    return c.getName();
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception cfr_ignored_0 = (Exception)_t;
                        continue;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        return rv;
    }

    public static String getType(JvmType type, String attribute) {
        try {
            String _qualifiedName = type.getQualifiedName();
            ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
            Class<?> c = Class.forName(_qualifiedName, false, _classLoader);
            Method m = null;
            try {
                Method _method;
                String _firstUpper = StringExtensions.toFirstUpper((String)attribute);
                String _plus = "get" + _firstUpper;
                m = _method = c.getMethod(_plus, new Class[0]);
            }
            catch (Throwable _t) {
                if (_t instanceof NoSuchMethodException) {
                    NoSuchMethodException e = (NoSuchMethodException)_t;
                    try {
                        Method _method_1;
                        String _firstUpper_1 = StringExtensions.toFirstUpper((String)attribute);
                        String _plus_1 = "is" + _firstUpper_1;
                        m = _method_1 = c.getMethod(_plus_1, new Class[0]);
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof NoSuchMethodException) {
                            NoSuchMethodException cfr_ignored_0 = (NoSuchMethodException)_t_1;
                            throw e;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Class<?> _returnType = m.getReturnType();
            return _returnType.getName();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static ValueType getValueType(JvmType type, String attribute) {
        try {
            String _qualifiedName = type.getQualifiedName();
            ClassLoader _classLoader = ReflectionHelper.class.getClassLoader();
            Class<?> c = Class.forName(_qualifiedName, false, _classLoader);
            Method m = null;
            try {
                Method _method;
                String _firstUpper = StringExtensions.toFirstUpper((String)attribute);
                String _plus = "get" + _firstUpper;
                m = _method = c.getMethod(_plus, new Class[0]);
            }
            catch (Throwable _t) {
                if (_t instanceof NoSuchMethodException) {
                    NoSuchMethodException e = (NoSuchMethodException)_t;
                    try {
                        Method _method_1;
                        String _firstUpper_1 = StringExtensions.toFirstUpper((String)attribute);
                        String _plus_1 = "is" + _firstUpper_1;
                        m = _method_1 = c.getMethod(_plus_1, new Class[0]);
                    }
                    catch (Throwable _t_1) {
                        if (_t_1 instanceof NoSuchMethodException) {
                            NoSuchMethodException cfr_ignored_0 = (NoSuchMethodException)_t_1;
                            throw e;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t_1);
                    }
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            Class<?> _returnType = m.getReturnType();
            boolean _isBoolean = ReflectionHelper.isBoolean(_returnType);
            if (_isBoolean) {
                return ValueType.BOOLEAN;
            }
            Class<?> _returnType_1 = m.getReturnType();
            boolean _isNumeric = ReflectionHelper.isNumeric(_returnType_1);
            if (_isNumeric) {
                return ValueType.NUMBER;
            }
            Class<?> _returnType_2 = m.getReturnType();
            boolean _equals = Objects.equal(_returnType_2, String.class);
            if (_equals) {
                return ValueType.STRING;
            }
            Class<?> _returnType_3 = m.getReturnType();
            boolean _isAssignableFrom = List.class.isAssignableFrom(_returnType_3);
            if (_isAssignableFrom) {
                return ValueType.LIST;
            }
            Class<?> _returnType_4 = m.getReturnType();
            boolean _isAssignableFrom_1 = EVENT_HANDLER_CLASS.isAssignableFrom(_returnType_4);
            if (_isAssignableFrom_1) {
                return ValueType.EVENT_CLASS;
            }
            return ValueType.CLASS;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static ValueType getStaticValueType(JvmType type, String attribute) {
        try {
            Method m = ReflectionFX.getStaticMethod(type, attribute);
            Class<?> _returnType = m.getReturnType();
            boolean _isBoolean = ReflectionHelper.isBoolean(_returnType);
            if (_isBoolean) {
                return ValueType.BOOLEAN;
            }
            Class<?> _returnType_1 = m.getReturnType();
            boolean _isNumeric = ReflectionHelper.isNumeric(_returnType_1);
            if (_isNumeric) {
                return ValueType.NUMBER;
            }
            Class<?> _returnType_2 = m.getReturnType();
            boolean _equals = Objects.equal(_returnType_2, String.class);
            if (_equals) {
                return ValueType.STRING;
            }
            Class<?> _returnType_3 = m.getReturnType();
            boolean _isAssignableFrom = List.class.isAssignableFrom(_returnType_3);
            if (_isAssignableFrom) {
                return ValueType.LIST;
            }
            return ValueType.CLASS;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static boolean isBoolean(Class<?> c) {
        boolean _equals_1;
        boolean _or = false;
        boolean _equals = Objects.equal(c, Boolean.TYPE);
        _or = _equals ? true : (_equals_1 = Objects.equal(c, Boolean.class));
        return _or;
    }

    public static boolean isNumeric(Class<?> c) {
        boolean _equals_3;
        boolean _equals_2;
        boolean _equals_1;
        boolean _or = false;
        boolean _or_1 = false;
        boolean _or_2 = false;
        boolean _equals = Objects.equal(c, Double.TYPE);
        _or_2 = _equals ? true : (_equals_1 = Objects.equal(c, Integer.TYPE));
        _or_1 = _or_2 ? true : (_equals_2 = Objects.equal(c, Integer.class));
        _or = _or_1 ? true : (_equals_3 = Objects.equal(c, Double.class));
        return _or;
    }
}

