/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.provisional;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.core.AbstractModule;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;

public class JavaModelAccess {
    public static IPackageFragmentRoot[] getUnfilteredPackageFragmentRoots(IJavaProject javaProject, IClasspathEntry entry) {
        try {
            JavaProject internalProject = (JavaProject)javaProject;
            IClasspathEntry[] resolvedEntries = internalProject.resolveClasspath(new IClasspathEntry[]{entry});
            return internalProject.computePackageFragmentRoots(resolvedEntries, false, false, null);
        }
        catch (JavaModelException javaModelException) {
            return new IPackageFragmentRoot[0];
        }
    }

    public static String[] getRequiredModules(IModuleDescription module) throws JavaModelException {
        IModule.IModuleReference[] references = ((AbstractModule)module).getRequiredModules();
        return (String[])Arrays.stream(references).map(ref -> String.valueOf(ref.name())).toArray(String[]::new);
    }

    public static List<String> defaultRootModules(Iterable<IPackageFragmentRoot> allSystemRoots) {
        return JavaProject.defaultRootModules(allSystemRoots);
    }

    public static IModuleDescription getAutomaticModuleDescription(IJavaElement element) throws JavaModelException, IllegalArgumentException {
        switch (element.getElementType()) {
            case 2: {
                return ((JavaProject)element).getAutomaticModuleDescription();
            }
            case 3: {
                return ((PackageFragmentRoot)element).getAutomaticModuleDescription();
            }
        }
        throw new IllegalArgumentException("Illegal kind of java element: " + element.getElementType());
    }
}

