/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.emf.edit.ui;

import javafx.application.Platform;
import javafx.scene.control.Cell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fx.emf.edit.ui.AdapterFactoryCellFactory;
import org.eclipse.jdt.annotation.NonNull;

public class AdapterFactoryTableCellFactory<S, T>
extends AdapterFactoryCellFactory
implements Callback<TableColumn<S, T>, TableCell<S, T>> {
    protected int columnIndex;

    public AdapterFactoryTableCellFactory(@NonNull AdapterFactory adapterFactory, int columnIndex) {
        super(adapterFactory);
        this.columnIndex = columnIndex;
    }

    public TableCell<S, T> call(TableColumn<S, T> arg0) {
        TableCell<Object, Object> tableCell = new TableCell<Object, Object>(){
            Object currentItem = null;
            AdapterFactoryCellFactory.ICellEditHandler cellEditHandler;
            AdapterImpl adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    this.update(msg.getNotifier());
                }
            };

            protected void updateItem(Object item, boolean empty) {
                super.updateItem(item, empty);
                if (item != this.currentItem) {
                    if (this.currentItem instanceof Notifier) {
                        ((Notifier)this.currentItem).eAdapters().remove((Object)this.adapter);
                    }
                    this.currentItem = item;
                    if (this.currentItem instanceof Notifier) {
                        ((Notifier)this.currentItem).eAdapters().add((Object)this.adapter);
                    }
                }
                for (AdapterFactoryCellFactory.ICellUpdateListener cellUpdateListener : AdapterFactoryTableCellFactory.this.cellUpdateListeners) {
                    cellUpdateListener.updateItem((Cell<?>)this, item, empty);
                }
                this.update(item);
            }

            public void startEdit() {
                super.startEdit();
                this.cellEditHandler = AdapterFactoryTableCellFactory.this.getCellEditHandler((Cell<?>)this);
                if (this.cellEditHandler != null) {
                    this.cellEditHandler.startEdit((Cell<?>)this);
                }
            }

            public void commitEdit(Object newValue) {
                super.commitEdit(newValue);
                if (this.cellEditHandler != null) {
                    this.cellEditHandler.commitEdit((Cell<?>)this, newValue);
                }
            }

            public void cancelEdit() {
                super.cancelEdit();
                if (this.cellEditHandler != null) {
                    this.cellEditHandler.cancelEdit((Cell<?>)this);
                }
                this.update(this.getItem());
            }

            void update(Object item) {
                if (Platform.isFxApplicationThread()) {
                    this.updateOnFxThread(item);
                } else {
                    Platform.runLater(() -> this.updateOnFxThread(item));
                }
            }

            private void updateOnFxThread(Object item) {
                AdapterFactoryTableCellFactory.applyTableItemProviderStyle(item, AdapterFactoryTableCellFactory.this.columnIndex, this, AdapterFactoryTableCellFactory.this.adapterFactory);
            }
        };
        for (AdapterFactoryCellFactory.ICellCreationListener cellCreationListener : this.cellCreationListeners) {
            cellCreationListener.cellCreated((Cell<?>)tableCell);
        }
        return tableCell;
    }
}

