/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.backend;

import org.eclipse.fx.drift.Vec2i;
import org.eclipse.fx.drift.internal.GL;
import org.eclipse.fx.drift.internal.backend.Image;
import org.eclipse.fx.drift.internal.backend.NVDXInteropDevice;
import org.eclipse.fx.drift.internal.common.ImageData;
import org.eclipse.fx.drift.internal.common.NVDXInteropImageData;
import org.eclipse.fx.drift.internal.jni.win32.D3D9;
import org.eclipse.fx.drift.internal.jni.win32.NVDXInterop;
import org.eclipse.fx.drift.internal.jni.win32.Win32;
import org.eclipse.fx.drift.internal.jni.win32.WindowsError;

public class NVDXInteropImage
implements Image {
    public static final Object syncedNVDXInterop = new Object();
    public static final Image.ImageType TYPE = new Image.ImageType("NVDXInterop");
    private int number;
    private Vec2i size;
    private NVDXInteropImageData data;
    int glTexture;
    static Win32.IDirect3DDevice9Ex dxDevice = D3D9.CreateOffscreenDevice();
    private NVDXInteropDevice device;
    private Win32.IDirect3DTexture9 dxTexture;
    private Win32.HANDLE dxTextureShareHandle;
    private Win32.HANDLE hObject;

    public NVDXInteropImage(int number, Vec2i size) {
        this.number = number;
        this.size = size;
    }

    @Override
    public ImageData getData() {
        return this.data;
    }

    @Override
    public int getGLTexture() {
        return this.glTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocate() {
        Object object = syncedNVDXInterop;
        synchronized (object) {
            try {
                this.device = NVDXInteropDevice.openDevice(dxDevice);
                this.glTexture = GL.glGenTexture();
                this.dxTexture = dxDevice.CreateTexture(this.size.x, this.size.y, 0, 512, 21, 0);
                NVDXInterop.wglDXSetResourceShareHandleNV(this.dxTexture, this.dxTexture.shareHandle);
                this.hObject = NVDXInterop.wglDXRegisterObjectNV(this.device.hDevice, this.dxTexture, this.glTexture, 3553, 1);
                this.data = new NVDXInteropImageData(this.number, this.size, this.dxTexture.shareHandle.address);
            }
            catch (WindowsError e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = syncedNVDXInterop;
        synchronized (object) {
            try {
                NVDXInterop.wglDXUnregisterObjectNV(this.device.hDevice, this.hObject);
                GL.glDeleteTexture(this.glTexture);
                this.dxTexture.Release();
                this.device.closeDevice();
            }
            catch (WindowsError e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAcquire() {
        Object object = syncedNVDXInterop;
        synchronized (object) {
            try {
                NVDXInterop.wglDXLockObjectsNV(this.device.hDevice, this.hObject);
            }
            catch (WindowsError e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPresent() {
        Object object = syncedNVDXInterop;
        synchronized (object) {
            try {
                NVDXInterop.wglDXUnlockObjectsNV(this.device.hDevice, this.hObject);
            }
            catch (WindowsError e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return TYPE + "Image(" + this.number + ")";
    }
}

