/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.workspace;

import com.google.common.base.Objects;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.util.UriUtil;
import org.eclipse.xtext.workspace.FileSourceFolder;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.workspace.WorkspaceConfig;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FileProjectConfig
implements IProjectConfig {
    private final URI path;
    private final String name;
    private final Set<FileSourceFolder> sourceFolders = new HashSet<FileSourceFolder>();
    private final IWorkspaceConfig workspaceConfig;

    public FileProjectConfig(URI path) {
        this(path, (IWorkspaceConfig)null);
    }

    public FileProjectConfig(URI path, String name) {
        this(path, name, (IWorkspaceConfig)null);
    }

    public FileProjectConfig(File root, String name) {
        this(root, name, (IWorkspaceConfig)null);
    }

    public FileProjectConfig(File root) {
        this(root, (IWorkspaceConfig)null);
    }

    public FileProjectConfig(URI path, IWorkspaceConfig workspaceConfig) {
        this(path, path.lastSegment(), workspaceConfig);
    }

    public FileProjectConfig(URI path, String name, IWorkspaceConfig workspaceConfig) {
        this.path = UriUtil.toFolderURI((URI)path);
        this.name = name;
        this.workspaceConfig = workspaceConfig != null ? workspaceConfig : new WorkspaceConfig(this);
    }

    public FileProjectConfig(File root, String name, IWorkspaceConfig workspaceConfig) {
        this(UriUtil.createFolderURI((File)root), name, workspaceConfig);
    }

    public FileProjectConfig(File root, IWorkspaceConfig workspaceConfig) {
        this(UriUtil.createFolderURI((File)root), root.getName(), workspaceConfig);
    }

    public FileSourceFolder addSourceFolder(String relativePath) {
        FileSourceFolder sourceFolder = new FileSourceFolder(this, relativePath);
        this.sourceFolders.add(sourceFolder);
        return sourceFolder;
    }

    @Override
    public FileSourceFolder findSourceFolderContaining(URI member) {
        return (FileSourceFolder)IterableExtensions.findFirst(this.sourceFolders, f -> f.contains(member));
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileProjectConfig) {
            return Objects.equal((Object)this.path, (Object)((FileProjectConfig)obj).path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "Project " + this.name + " (" + this.path + ")";
    }

    @Override
    public URI getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Set<FileSourceFolder> getSourceFolders() {
        return this.sourceFolders;
    }

    @Override
    public IWorkspaceConfig getWorkspaceConfig() {
        return this.workspaceConfig;
    }
}

