/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.util.concurrent.CompletableFuture;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.MinimalFuture;

class PushGroup<U, T> {
    final CompletableFuture<Void> resultCF;
    final CompletableFuture<Void> noMorePushesCF;
    volatile Throwable error;
    final CompletableFuture<HttpResponse<T>> mainResponse;
    final HttpResponse.MultiProcessor<U, T> multiProcessor;
    final HttpResponse.BodyHandler<T> mainBodyHandler;
    int numberOfPushes;
    int remainingPushes;
    boolean noMorePushes = false;

    PushGroup(HttpResponse.MultiProcessor<U, T> multiProcessor, HttpRequestImpl httpRequestImpl) {
        this(multiProcessor, httpRequestImpl, new MinimalFuture<HttpResponse<T>>());
    }

    private PushGroup(HttpResponse.MultiProcessor<U, T> multiProcessor, HttpRequestImpl httpRequestImpl, CompletableFuture<HttpResponse<T>> completableFuture) {
        this(multiProcessor, completableFuture, multiProcessor.onRequest(httpRequestImpl).orElseThrow(() -> new IllegalArgumentException("A valid body processor for the main response is required")));
    }

    private PushGroup(HttpResponse.MultiProcessor<U, T> multiProcessor, CompletableFuture<HttpResponse<T>> completableFuture, HttpResponse.BodyHandler<T> bodyHandler) {
        assert (completableFuture != null);
        assert (bodyHandler != null);
        this.resultCF = new MinimalFuture<Void>();
        this.noMorePushesCF = new MinimalFuture<Void>();
        this.multiProcessor = multiProcessor;
        this.mainResponse = completableFuture.thenApply(httpResponse -> {
            multiProcessor.onResponse((HttpResponse)httpResponse);
            return httpResponse;
        });
        this.mainBodyHandler = bodyHandler;
    }

    CompletableFuture<Void> groupResult() {
        return this.resultCF;
    }

    HttpResponse.MultiProcessor<U, T> processor() {
        return this.multiProcessor;
    }

    HttpResponse.BodyHandler<T> mainResponseHandler() {
        return this.mainBodyHandler;
    }

    synchronized void setMainResponse(CompletableFuture<HttpResponse<T>> completableFuture) {
        completableFuture.whenComplete((httpResponse, throwable) -> {
            if (throwable != null) {
                this.mainResponse.completeExceptionally((Throwable)throwable);
            } else {
                this.mainResponse.complete((HttpResponse<HttpResponse>)httpResponse);
            }
        });
    }

    synchronized CompletableFuture<HttpResponse<T>> mainResponse() {
        return this.mainResponse;
    }

    synchronized void addPush() {
        ++this.numberOfPushes;
        ++this.remainingPushes;
    }

    synchronized int numberOfPushes() {
        return this.numberOfPushes;
    }

    synchronized void noMorePushes(boolean bl) {
        this.noMorePushes = bl;
        this.checkIfCompleted();
        this.noMorePushesCF.complete(null);
    }

    CompletableFuture<Void> pushesCF() {
        return this.noMorePushesCF;
    }

    synchronized boolean noMorePushes() {
        return this.noMorePushes;
    }

    synchronized void pushCompleted() {
        --this.remainingPushes;
        this.checkIfCompleted();
    }

    synchronized void checkIfCompleted() {
        if (Log.trace()) {
            Log.logTrace("PushGroup remainingPushes={0} error={1} noMorePushes={2}", this.remainingPushes, this.error == null ? this.error : this.error.getClass().getSimpleName(), this.noMorePushes);
        }
        if (this.remainingPushes == 0 && this.error == null && this.noMorePushes) {
            if (Log.trace()) {
                Log.logTrace("push completed", new Object[0]);
            }
            this.resultCF.complete(null);
        }
    }

    synchronized void pushError(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        this.error = throwable;
        this.resultCF.completeExceptionally(throwable);
    }
}

