/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.common;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.NetPermission;
import java.net.URI;
import java.net.URLPermission;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import javax.net.ssl.SSLParameters;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.common.ExceptionallyCloseable;
import jdk.incubator.http.internal.common.Utils8;
import sun.misc.InnocuousThread;
import sun.net.NetProperties;
import sun.net.util.IPAddressUtil;

public final class Utils {
    public static final int DEFAULT_BUFSIZE = 16384;
    public static final int BUFSIZE;
    private static final Set<String> DISALLOWED_HEADERS_SET;
    public static final Predicate<String> ALLOWED_HEADERS;
    public static final Predicate<String> ALL_HEADERS;
    private static final boolean[] tchar;
    private static final boolean[] fieldvchar;
    public static final CompletableFuture[] EMPTY_CFARRAY;
    public static final ByteBuffer EMPTY_BYTEBUFFER;
    public static final ByteBuffer[] EMPTY_BB_ARRAY;

    public static ByteBuffer getBuffer() {
        return ByteBuffer.allocate(BUFSIZE);
    }

    public static IOException getIOException(Throwable throwable) {
        if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            return Utils.getIOException(throwable2);
        }
        return new IOException(throwable);
    }

    public static ByteBuffer getExchangeBuffer() {
        ByteBuffer byteBuffer = Utils.getBuffer();
        byteBuffer.limit(0);
        return byteBuffer;
    }

    static void resumeChannelRead(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.limit();
        byteBuffer.position(n2);
        int n3 = byteBuffer.capacity() - n2;
        if (n > 0 && n < n3) {
            byteBuffer.limit(n2 + n);
        } else {
            byteBuffer.limit(byteBuffer.capacity());
        }
    }

    private Utils() {
    }

    public static ExecutorService innocuousThreadPool() {
        return Executors.newCachedThreadPool(runnable -> new InnocuousThread(runnable));
    }

    public static boolean isValidName(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u00ff' && tchar[c]) continue;
            return false;
        }
        return !string.isEmpty();
    }

    public static String getServerName(InetSocketAddress inetSocketAddress) {
        String string = inetSocketAddress.getHostString();
        if (IPAddressUtil.textToNumericFormatV4(string) != null) {
            return null;
        }
        if (IPAddressUtil.textToNumericFormatV6(string) != null) {
            return null;
        }
        return string;
    }

    public static boolean isValidValue(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                return false;
            }
            if (bl) {
                if (c == ' ' || c == '\t') {
                    bl = false;
                    continue;
                }
                if (fieldvchar[c]) continue;
                return false;
            }
            if (c == ' ' || c == '\t') continue;
            if (fieldvchar[c]) {
                bl = true;
                continue;
            }
            return false;
        }
        return bl;
    }

    public static URLPermission getPermission(URI uRI, String string, Map<String, List<String>> map) {
        String string2;
        String string3;
        StringBuilder stringBuilder = new StringBuilder();
        if (string.equals("CONNECT")) {
            string3 = uRI.toString();
            string2 = "CONNECT";
        } else {
            stringBuilder.append(uRI.getScheme()).append("://").append(uRI.getAuthority()).append(uRI.getPath());
            string3 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            if (map != null && !map.isEmpty()) {
                stringBuilder.append(':');
                Set<String> set = map.keySet();
                boolean bl = true;
                for (String string4 : set) {
                    if (!bl) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(string4);
                    bl = false;
                }
            }
            string2 = stringBuilder.toString();
        }
        return new URLPermission(string3, string2);
    }

    public static void checkNetPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        NetPermission netPermission = new NetPermission(string);
        securityManager.checkPermission(netPermission);
    }

    public static int getIntegerNetProperty(String string, int n) {
        return AccessController.doPrivileged(() -> NetProperties.getInteger(string, n));
    }

    static String getNetProperty(String string) {
        return AccessController.doPrivileged(() -> NetProperties.get(string));
    }

    public static SSLParameters copySSLParameters(SSLParameters sSLParameters) {
        SSLParameters sSLParameters2 = new SSLParameters();
        sSLParameters2.setAlgorithmConstraints(sSLParameters.getAlgorithmConstraints());
        sSLParameters2.setCipherSuites(sSLParameters.getCipherSuites());
        sSLParameters2.setEndpointIdentificationAlgorithm(sSLParameters.getEndpointIdentificationAlgorithm());
        sSLParameters2.setNeedClientAuth(sSLParameters.getNeedClientAuth());
        String[] stringArray = sSLParameters.getProtocols();
        if (stringArray != null) {
            sSLParameters2.setProtocols((String[])stringArray.clone());
        }
        sSLParameters2.setSNIMatchers(sSLParameters.getSNIMatchers());
        sSLParameters2.setServerNames(sSLParameters.getServerNames());
        sSLParameters2.setUseCipherSuitesOrder(sSLParameters.getUseCipherSuitesOrder());
        sSLParameters2.setWantClientAuth(sSLParameters.getWantClientAuth());
        return sSLParameters2;
    }

    public static void flipToMark(ByteBuffer byteBuffer, int n) {
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.position(n);
    }

    public static String stackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String string = null;
        try {
            PrintStream printStream = new PrintStream((OutputStream)byteArrayOutputStream, true, "US-ASCII");
            throwable.printStackTrace(printStream);
            string = byteArrayOutputStream.toString("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public static int copy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n;
        int n2 = byteBuffer.remaining();
        if (n2 > (n = byteBuffer2.remaining())) {
            int n3 = n2 - n;
            int n4 = byteBuffer.limit();
            byteBuffer.limit(n4 - n3);
            byteBuffer2.put(byteBuffer);
            byteBuffer.limit(n4);
        } else {
            byteBuffer2.put(byteBuffer);
        }
        return n2 - byteBuffer.remaining();
    }

    public static int copyUpTo(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) {
        int n2 = Math.min(byteBuffer.remaining(), Math.min(byteBuffer2.remaining(), n));
        Utils.copy(byteBuffer, byteBuffer2, n2);
        return n2;
    }

    public static void copy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) {
        int n2 = byteBuffer.remaining() - n;
        assert (n2 >= 0);
        if (n2 > 0) {
            int n3 = byteBuffer.limit();
            byteBuffer.limit(n3 - n2);
            byteBuffer2.put(byteBuffer);
            byteBuffer.limit(n3);
        } else {
            byteBuffer2.put(byteBuffer);
        }
    }

    public static ByteBuffer copy(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        byteBuffer2.flip();
        return byteBuffer2;
    }

    public static String dump(Object ... objectArray) {
        return Arrays.toString(objectArray);
    }

    public static String stringOf(Collection<?> collection) {
        return Arrays.toString(collection.toArray());
    }

    public static int remaining(ByteBuffer[] byteBufferArray) {
        int n = 0;
        for (ByteBuffer byteBuffer : byteBufferArray) {
            n += byteBuffer.remaining();
        }
        return n;
    }

    public static int remaining(List<ByteBuffer> list) {
        int n = 0;
        for (ByteBuffer byteBuffer : list) {
            n += byteBuffer.remaining();
        }
        return n;
    }

    public static int remaining(ByteBufferReference[] byteBufferReferenceArray) {
        int n = 0;
        for (ByteBufferReference byteBufferReference : byteBufferReferenceArray) {
            n += byteBufferReference.get().remaining();
        }
        return n;
    }

    static void unflip(ByteBuffer byteBuffer) {
        byteBuffer.position(byteBuffer.limit());
        byteBuffer.limit(byteBuffer.capacity());
    }

    public static void close(Closeable ... closeableArray) {
        for (Closeable closeable : closeableArray) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Throwable throwable, Closeable ... closeableArray) {
        for (Closeable closeable : closeableArray) {
            try {
                ExceptionallyCloseable.close(throwable, closeable);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static ByteBuffer[] reduce(ByteBuffer[] byteBufferArray, int n, int n2) {
        if (n == 0 && n2 == byteBufferArray.length) {
            return byteBufferArray;
        }
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n2];
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            byteBufferArray2[n3++] = byteBufferArray[i];
        }
        return byteBufferArray2;
    }

    static String asString(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return new String(byArray, StandardCharsets.US_ASCII);
    }

    public static Executor singleThreadExecutor(Executor executor) {
        final LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue();
        executor.execute(() -> {
            try {
                while (true) {
                    Optional optional;
                    if (!(optional = (Optional)linkedBlockingQueue.take()).isPresent()) {
                        return;
                    }
                    ((Runnable)optional.get()).run();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        });
        return new Executor(){

            @Override
            public void execute(Runnable runnable) {
                linkedBlockingQueue.offer(Optional.ofNullable(runnable));
            }
        };
    }

    private static void executeInline(Runnable runnable) {
        runnable.run();
    }

    static Executor callingThreadExecutor() {
        return Utils::executeInline;
    }

    public static ByteBuffer slice(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.limit(n);
        byteBuffer.position(byteBuffer.position() + n);
        return byteBuffer2;
    }

    public static Charset charsetFrom(HttpHeaders httpHeaders) {
        String string = httpHeaders.firstValue("Content-encoding").orElse("UTF_8");
        try {
            return Charset.forName(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return StandardCharsets.UTF_8;
        }
    }

    public static UncheckedIOException unchecked(IOException iOException) {
        return new UncheckedIOException(iOException);
    }

    static {
        char[] cArray;
        BUFSIZE = Utils.getIntegerNetProperty("jdk.httpclient.bufsize", 16384);
        DISALLOWED_HEADERS_SET = Utils8.setOf("authorization", "connection", "cookie", "content-length", "date", "expect", "from", "host", "origin", "proxy-authorization", "referer", "user-agent", "upgrade", "via", "warning");
        ALLOWED_HEADERS = string -> !DISALLOWED_HEADERS_SET.contains(string);
        ALL_HEADERS = string -> true;
        tchar = new boolean[256];
        fieldvchar = new boolean[256];
        for (char c : cArray = "!#$%&'*+-.^_`|~0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray()) {
            Utils.tchar[c] = true;
        }
        for (int n = 33; n < 255; n = (int)((char)(n + 1))) {
            Utils.fieldvchar[n] = true;
        }
        Utils.fieldvchar[127] = false;
        EMPTY_CFARRAY = new CompletableFuture[0];
        EMPTY_BYTEBUFFER = ByteBuffer.allocate(0);
        EMPTY_BB_ARRAY = new ByteBuffer[0];
    }
}

