/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.UnbindRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.OutputStream;
import java.util.List;
import javax.net.ssl.SSLSocketFactory;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class StartTLSRequestHandler
extends LDAPListenerRequestHandler {
    private final LDAPListenerClientConnection connection;
    private final LDAPListenerRequestHandler requestHandler;
    private final SSLSocketFactory sslSocketFactory;

    public StartTLSRequestHandler(SSLSocketFactory sslSocketFactory, LDAPListenerRequestHandler requestHandler) {
        this.sslSocketFactory = sslSocketFactory;
        this.requestHandler = requestHandler;
        this.connection = null;
    }

    private StartTLSRequestHandler(SSLSocketFactory sslSocketFactory, LDAPListenerRequestHandler requestHandler, LDAPListenerClientConnection connection) {
        this.sslSocketFactory = sslSocketFactory;
        this.requestHandler = requestHandler;
        this.connection = connection;
    }

    @Override
    public StartTLSRequestHandler newInstance(LDAPListenerClientConnection connection) throws LDAPException {
        return new StartTLSRequestHandler(this.sslSocketFactory, this.requestHandler.newInstance(connection), connection);
    }

    @Override
    public void closeInstance() {
        this.requestHandler.closeInstance();
    }

    @Override
    public void processAbandonRequest(int messageID, AbandonRequestProtocolOp request, List<Control> controls) {
        this.requestHandler.processAbandonRequest(messageID, request, controls);
    }

    @Override
    public LDAPMessage processAddRequest(int messageID, AddRequestProtocolOp request, List<Control> controls) {
        return this.requestHandler.processAddRequest(messageID, request, controls);
    }

    @Override
    public LDAPMessage processBindRequest(int messageID, BindRequestProtocolOp request, List<Control> controls) {
        return this.requestHandler.processBindRequest(messageID, request, controls);
    }

    @Override
    public LDAPMessage processCompareRequest(int messageID, CompareRequestProtocolOp request, List<Control> controls) {
        return this.requestHandler.processCompareRequest(messageID, request, controls);
    }

    @Override
    public LDAPMessage processDeleteRequest(int messageID, DeleteRequestProtocolOp request, List<Control> controls) {
        return this.requestHandler.processDeleteRequest(messageID, request, controls);
    }

    @Override
    public LDAPMessage processExtendedRequest(int messageID, ExtendedRequestProtocolOp request, List<Control> controls) {
        if (request.getOID().equals("1.3.6.1.4.1.1466.20037")) {
            try {
                StartTLSExtendedRequest startTLSRequest = new StartTLSExtendedRequest(new ExtendedRequest(request.getOID(), request.getValue()));
                OutputStream clearOutputStream = this.connection.convertToTLS(this.sslSocketFactory);
                LDAPMessage responseMessage = new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(0, null, null, null, null, null), new Control[0]);
                ASN1Buffer buffer = new ASN1Buffer();
                responseMessage.writeTo(buffer);
                try {
                    buffer.writeTo(clearOutputStream);
                    clearOutputStream.flush();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    LDAPException le = new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_START_TLS_REQUEST_HANDLER_WRITE_RESPONSE_FAILURE.get(StaticUtils.getExceptionMessage(e)), e);
                    this.connection.close(le);
                    throw le;
                }
                return responseMessage;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                return new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(le.getResultCode().intValue(), le.getMatchedDN(), le.getDiagnosticMessage(), StaticUtils.toList(le.getReferralURLs()), null, null), le.getResponseControls());
            }
        }
        return this.requestHandler.processExtendedRequest(messageID, request, controls);
    }

    @Override
    public LDAPMessage processModifyRequest(int messageID, ModifyRequestProtocolOp request, List<Control> controls) {
        return this.requestHandler.processModifyRequest(messageID, request, controls);
    }

    @Override
    public LDAPMessage processModifyDNRequest(int messageID, ModifyDNRequestProtocolOp request, List<Control> controls) {
        return this.requestHandler.processModifyDNRequest(messageID, request, controls);
    }

    @Override
    public LDAPMessage processSearchRequest(int messageID, SearchRequestProtocolOp request, List<Control> controls) {
        return this.requestHandler.processSearchRequest(messageID, request, controls);
    }

    @Override
    public void processUnbindRequest(int messageID, UnbindRequestProtocolOp request, List<Control> controls) {
        this.requestHandler.processUnbindRequest(messageID, request, controls);
    }
}

