/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.ClusterExtension;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.CopyConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.config.serverbeans.VirtualMachineExtension;
import com.sun.enterprise.config.serverbeans.customvalidators.ConfigRefConstraint;
import com.sun.enterprise.config.serverbeans.customvalidators.ConfigRefValidator;
import com.sun.enterprise.config.serverbeans.customvalidators.NotDuplicateTargetName;
import com.sun.enterprise.config.serverbeans.customvalidators.NotTargetKeyword;
import com.sun.enterprise.config.serverbeans.customvalidators.ReferenceConstraint;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import jakarta.validation.Payload;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.PropertyDesc;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.config.support.CreationDecorator;
import org.glassfish.config.support.DeletionDecorator;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.quality.ToDo;
import org.glassfish.security.common.SharedSecureRandom;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
@ConfigRefConstraint(message="{configref.invalid}", payload={ConfigRefValidator.class})
@NotDuplicateTargetName(message="{cluster.duplicate.name}", payload={Cluster.class})
@ReferenceConstraint(skipDuringCreation=true, payload={Cluster.class})
public interface Cluster
extends ConfigBeanProxy,
PropertyBag,
Named,
SystemPropertyBag,
ReferenceContainer,
RefContainer,
Payload {
    @Param(name="name", primary=true)
    public void setName(String var1) throws PropertyVetoException;

    @NotTargetKeyword(message="{cluster.reserved.name}", payload={Cluster.class})
    @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="{cluster.invalid.name}", payload={Cluster.class})
    public @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="{cluster.invalid.name}", payload={Cluster.class}) String getName();

    @Attribute
    @NotNull
    @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="{config.invalid.name}")
    @ReferenceConstraint.RemoteKey(message="{resourceref.invalid.configref}", type=Config.class)
    public @NotNull @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="{config.invalid.name}") String getConfigRef();

    @Param(name="config", optional=true)
    @I18n(value="generic.config")
    public void setConfigRef(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class, required=true)
    @NotNull
    public String getGmsEnabled();

    @Param(name="gmsenabled", optional=true)
    public void setGmsEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="udpmulticast", required=true)
    @NotNull
    public String getBroadcast();

    @Param(name="gmsbroadcast", optional=true)
    public void setBroadcast(String var1) throws PropertyVetoException;

    @Attribute
    @Min(value=2048L)
    @Max(value=49151L)
    public @Min(value=2048L) @Max(value=49151L) String getGmsMulticastPort();

    @Param(name="multicastport", optional=true, alias="heartbeatport")
    public void setGmsMulticastPort(String var1) throws PropertyVetoException;

    @Attribute
    public String getGmsMulticastAddress();

    @Param(name="multicastaddress", optional=true, alias="heartbeataddress")
    public void setGmsMulticastAddress(String var1) throws PropertyVetoException;

    @Attribute
    public String getGmsBindInterfaceAddress();

    @Param(name="bindaddress", optional=true)
    public void setGmsBindInterfaceAddress(String var1) throws PropertyVetoException;

    @Deprecated
    @Attribute
    public String getHeartbeatEnabled();

    @Deprecated
    public void setHeartbeatEnabled(String var1) throws PropertyVetoException;

    @Attribute
    @Deprecated
    public String getHeartbeatPort();

    @Deprecated
    public void setHeartbeatPort(String var1) throws PropertyVetoException;

    @Attribute
    @Deprecated
    public String getHeartbeatAddress();

    @Deprecated
    public void setHeartbeatAddress(String var1) throws PropertyVetoException;

    @Element
    public List<ServerRef> getServerRef();

    @Override
    @Element
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal system props")
    @Param(name="systemproperties", optional=true)
    public List<SystemProperty> getSystemProperty();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Complete PropertyDesc for legal props")
    @PropertiesDesc(props={@PropertyDesc(name="GMS_LISTENER_PORT", defaultValue="9090", description="GMS listener port")})
    @Element
    @Param(name="properties", optional=true)
    public List<Property> getProperty();

    @Element(value="*")
    public List<ClusterExtension> getExtensions();

    default public String getReference() {
        return this.getConfigRef();
    }

    default public List<Server> getInstances() {
        ServiceLocator habitat = Objects.requireNonNull(Dom.unwrap((ConfigBeanProxy)this)).getHabitat();
        Domain domain = (Domain)habitat.getService(Domain.class, new Annotation[0]);
        ArrayList<Server> instances = new ArrayList<Server>();
        for (ServerRef serverRef : this.getServerRef()) {
            Server server = domain.getServerNamed(serverRef.getRef());
            if (server == null) continue;
            instances.add(domain.getServerNamed(serverRef.getRef()));
        }
        return instances;
    }

    default public ServerRef getServerRefByRef(String refName) {
        for (ServerRef serverRef : this.getServerRef()) {
            if (!serverRef.getRef().equals(refName)) continue;
            return serverRef;
        }
        return null;
    }

    default public boolean isCluster() {
        return true;
    }

    default public boolean isServer() {
        return false;
    }

    default public boolean isDas() {
        return false;
    }

    default public boolean isInstance() {
        return false;
    }

    default public boolean isVirtual() {
        return !this.getExtensionsByType(VirtualMachineExtension.class).isEmpty();
    }

    default public ApplicationRef getApplicationRef(String appName) {
        for (ApplicationRef appRef : this.getApplicationRef()) {
            if (!appRef.getRef().equals(appName)) continue;
            return appRef;
        }
        return null;
    }

    default public ResourceRef getResourceRef(SimpleJndiName refName) {
        for (ResourceRef resourceRef : this.getResourceRef()) {
            if (!resourceRef.getRef().equals(refName.toString())) continue;
            return resourceRef;
        }
        return null;
    }

    default public boolean isResourceRefExists(SimpleJndiName refName) {
        return this.getResourceRef(refName) != null;
    }

    default public void createResourceRef(String enabled, SimpleJndiName refName) throws TransactionFailure {
        ConfigSupport.apply(param -> {
            ResourceRef newResourceRef = (ResourceRef)param.createChild(ResourceRef.class);
            newResourceRef.setEnabled(enabled);
            newResourceRef.setRef(refName.toString());
            param.getResourceRef().add(newResourceRef);
            return newResourceRef;
        }, (ConfigBeanProxy)this);
    }

    default public void deleteResourceRef(SimpleJndiName refName) throws TransactionFailure {
        ResourceRef resourceRef = this.getResourceRef(refName);
        if (resourceRef != null) {
            ConfigSupport.apply(param -> param.getResourceRef().remove(resourceRef), (ConfigBeanProxy)this);
        }
    }

    default public <T extends ClusterExtension> List<T> getExtensionsByType(Class<T> type) {
        ArrayList<ClusterExtension> extensions = new ArrayList<ClusterExtension>();
        for (ClusterExtension extension : this.getExtensions()) {
            try {
                type.cast(extension);
                extensions.add(extension);
            }
            catch (ClassCastException classCastException) {}
        }
        return extensions;
    }

    default public <T extends ClusterExtension> T getExtensionsByTypeAndName(Class<T> type, String name) {
        for (ClusterExtension extension : this.getExtensions()) {
            try {
                if (!extension.getName().equals(name)) continue;
                return (T)((ClusterExtension)type.cast(extension));
            }
            catch (ClassCastException classCastException) {
            }
        }
        return null;
    }

    @Service
    @PerLookup
    public static class DeleteDecorator
    implements DeletionDecorator<Clusters, Cluster> {
        @Param(name="nodeagent", optional=true, obsolete=true)
        String nodeagent;
        @Param(name="autohadboverride", optional=true, obsolete=true)
        String autohadboverride;
        @Inject
        private Domain domain;
        @Inject
        Configs configs;
        @Inject
        private ServerEnvironment env;
        @Inject
        CommandRunner runner;

        @Override
        public void decorate(AdminCommandContext context, Clusters parent, Cluster child) throws PropertyVetoException, TransactionFailure {
            Object c;
            String propName;
            Logger logger = ConfigApiLoggerInfo.getLogger();
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Cluster.class);
            ActionReport report = context.getActionReport();
            AdminCommand command = this.runner.getCommand("copy-config", report);
            if (command == null) {
                String msg = localStrings.getLocalString("cannot.execute.command", "Cluster software is not installed");
                throw new TransactionFailure(msg);
            }
            String instanceConfig = child.getConfigRef();
            Config config = this.configs.getConfigByName(instanceConfig);
            Transaction tx = Transaction.getTransaction((ConfigBeanProxy)parent);
            List<ServerRef> serverRefs = child.getServerRef();
            StringBuffer namesOfServers = new StringBuffer();
            if (serverRefs.size() > 0) {
                for (ServerRef serverRef : serverRefs) {
                    namesOfServers.append(new StringBuffer(serverRef.getRef()).append(','));
                }
                String msg = localStrings.getLocalString("Cluster.hasInstances", "Cluster {0} contains server instances {1} and must not contain any instances", new Object[]{child.getName(), namesOfServers.toString()});
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00004", new Object[]{child.getName(), namesOfServers.toString()});
                throw new TransactionFailure(msg);
            }
            Config serverConfig = this.configs.getConfigByName("server-config");
            SystemProperty gmsProp = serverConfig.getSystemProperty(propName = String.format("GMS_LISTENER_PORT-%s", child.getName()));
            if (gmsProp != null && tx != null) {
                c = (Config)tx.enroll((ConfigBeanProxy)serverConfig);
                List<SystemProperty> propList = c.getSystemProperty();
                propList.remove(gmsProp);
            }
            if (config == null || this.domain.getReferenceContainersOf(config).size() > 1 || !instanceConfig.equals(child.getName() + "-config")) {
                return;
            }
            try {
                File configConfigDir = new File(this.env.getConfigDirPath(), config.getName());
                FileUtils.whack((File)configConfigDir);
            }
            catch (Exception configConfigDir) {
                // empty catch block
            }
            try {
                if (tx != null) {
                    c = (Configs)tx.enroll((ConfigBeanProxy)this.configs);
                    List<Config> configList = c.getConfig();
                    configList.remove(config);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00005", new Object[]{instanceConfig, ex});
                String msg = ex.getMessage() != null ? ex.getMessage() : localStrings.getLocalString("deleteConfigFailed", "Unable to remove config {0}", new Object[]{instanceConfig});
                report.setMessage(msg);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                report.setFailureCause((Throwable)ex);
                throw ex;
            }
        }
    }

    @Service
    @PerLookup
    public static class Decorator
    implements CreationDecorator<Cluster> {
        @Param(name="config", optional=true)
        String configRef;
        @Param(optional=true, obsolete=true)
        String hosts;
        @Param(optional=true, obsolete=true)
        String haagentport;
        @Param(optional=true, obsolete=true)
        String haadminpassword;
        @Param(optional=true, obsolete=true)
        String haadminpasswordfile;
        @Param(optional=true, obsolete=true)
        String devicesize;
        @Param(optional=true, obsolete=true)
        String haproperty;
        @Param(optional=true, obsolete=true)
        String autohadb;
        @Param(optional=true, obsolete=true)
        String portbase;
        @Inject
        ServiceLocator habitat;
        @Inject
        ServerEnvironment env;
        @Inject
        Domain domain;
        @Inject
        CommandRunner runner;

        @Override
        public void decorate(AdminCommandContext context, Cluster instance) throws TransactionFailure, PropertyVetoException {
            String discoveryUriList;
            Logger logger = ConfigApiLoggerInfo.getLogger();
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(Cluster.class);
            Transaction tx = Transaction.getTransaction((ConfigBeanProxy)instance);
            CopyConfig command = (CopyConfig)this.runner.getCommand("copy-config", context.getActionReport());
            if (command == null) {
                throw new TransactionFailure(localStrings.getLocalString("cannot.execute.command", "Cluster software is not installed"));
            }
            String instanceName = instance.getName();
            if (instance.getGmsBindInterfaceAddress() == null) {
                instance.setGmsBindInterfaceAddress(String.format("${GMS-BIND-INTERFACE-ADDRESS-%s}", instanceName));
            }
            if (this.configRef == null) {
                Config config = (Config)this.habitat.getService(Config.class, "default-config", new Annotation[0]);
                if (config == null) {
                    config = (Config)this.habitat.getAllServices(Config.class, new Annotation[0]).iterator().next();
                    logger.log(Level.WARNING, "NCLS-CFGAPI-00001", new Object[]{config.getName(), instance.getName()});
                }
                Configs configs = this.domain.getConfigs();
                Configs writableConfigs = (Configs)tx.enroll((ConfigBeanProxy)configs);
                String configName = instance.getName() + "-config";
                instance.setConfigRef(configName);
                command.copyConfig(writableConfigs, config, configName, logger);
            } else {
                Config specifiedConfig = this.domain.getConfigs().getConfigByName(this.configRef);
                if (specifiedConfig == null) {
                    throw new TransactionFailure(localStrings.getLocalString("noSuchConfig", "Configuration {0} does not exist.", new Object[]{this.configRef}));
                }
            }
            Property gmsListenerPort = instance.getProperty("GMS_LISTENER_PORT");
            boolean needToAddGmsListenerPort = false;
            if (gmsListenerPort == null) {
                needToAddGmsListenerPort = true;
                gmsListenerPort = (Property)instance.createChild(Property.class);
                gmsListenerPort.setName("GMS_LISTENER_PORT");
                gmsListenerPort.setValue(String.format("${GMS_LISTENER_PORT-%s}", instanceName));
            }
            String DEFAULT_BROADCAST = "udpmulticast";
            String broadcastProtocol = instance.getBroadcast();
            Property discoveryUriListProp = instance.getProperty("GMS_DISCOVERY_URI_LIST");
            String string = discoveryUriList = discoveryUriListProp != null ? discoveryUriListProp.getValue() : null;
            if (discoveryUriList != null && DEFAULT_BROADCAST.equals(broadcastProtocol)) {
                instance.setBroadcast("tcp");
                broadcastProtocol = "tcp";
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "NCLS-CFGAPI-00002", instance.getBroadcast());
                logger.log(Level.FINE, "NCLS-CFGAPI-00003", discoveryUriList);
            }
            if (DEFAULT_BROADCAST.equals(broadcastProtocol)) {
                if (instance.getGmsMulticastAddress() == null) {
                    instance.setGmsMulticastAddress(this.generateHeartbeatAddress());
                }
                if (instance.getGmsMulticastPort() == null) {
                    instance.setGmsMulticastPort(this.generateHeartbeatPort());
                }
                if (needToAddGmsListenerPort) {
                    instance.getProperty().add(gmsListenerPort);
                }
            } else {
                String GENERATE = "generate";
                if (discoveryUriListProp == null) {
                    discoveryUriListProp = (Property)instance.createChild(Property.class);
                    discoveryUriListProp.setName("GMS_DISCOVERY_URI_LIST");
                    discoveryUriListProp.setValue("generate");
                    instance.getProperty().add(discoveryUriListProp);
                }
                String TCPPORT = gmsListenerPort.getValue();
                if ("generate".equals(discoveryUriListProp.getValue())) {
                    if (TCPPORT == null || TCPPORT.trim().charAt(0) == '$') {
                        TCPPORT = Integer.toString(SharedSecureRandom.SECURE_RANDOM.nextInt(110) + 9090);
                        gmsListenerPort.setValue(TCPPORT);
                        if (needToAddGmsListenerPort) {
                            instance.getProperty().add(gmsListenerPort);
                        }
                    }
                } else {
                    String propName;
                    Config config = (Config)this.habitat.getService(Config.class, "server-config", new Annotation[0]);
                    if (config != null && config.getProperty(propName = String.format("GMS_LISTENER_PORT-%s", instanceName)) == null) {
                        Config writeableConfig = (Config)tx.enroll((ConfigBeanProxy)config);
                        SystemProperty gmsListenerPortSysProp = (SystemProperty)instance.createChild(SystemProperty.class);
                        gmsListenerPortSysProp.setName(propName);
                        if (TCPPORT == null || TCPPORT.trim().charAt(0) == '$') {
                            String generateGmsListenerPort = Integer.toString(SharedSecureRandom.SECURE_RANDOM.nextInt(110) + 9090);
                            gmsListenerPortSysProp.setValue(generateGmsListenerPort);
                        } else {
                            gmsListenerPortSysProp.setValue(TCPPORT);
                        }
                        writeableConfig.getSystemProperty().add(gmsListenerPortSysProp);
                    }
                    if (needToAddGmsListenerPort) {
                        instance.getProperty().add(gmsListenerPort);
                    }
                }
            }
            Resources resources = this.domain.getResources();
            for (Resource resource : resources.getResources()) {
                if (!Resource.copyToInstance(resource)) continue;
                String name = null;
                if (resource instanceof BindableResource) {
                    name = ((BindableResource)resource).getJndiName();
                }
                if (resource instanceof Named) {
                    name = ((Named)resource).getName();
                }
                if (name == null) {
                    throw new TransactionFailure("Cannot add un-named resources to the new server instance");
                }
                ResourceRef newResourceRef = (ResourceRef)instance.createChild(ResourceRef.class);
                newResourceRef.setRef(name);
                instance.getResourceRef().add(newResourceRef);
            }
            for (Application application : this.domain.getApplications().getApplications()) {
                if (!application.getObjectType().equals("system-all") && !application.getObjectType().equals("system-instance")) continue;
                ApplicationRef newAppRef = (ApplicationRef)instance.createChild(ApplicationRef.class);
                newAppRef.setRef(application.getName());
                instance.getApplicationRef().add(newAppRef);
            }
            if (this.hosts != null || this.haagentport != null || this.haadminpassword != null || this.haadminpasswordfile != null || this.devicesize != null || this.haproperty != null || this.autohadb != null || this.portbase != null) {
                context.getActionReport().setActionExitCode(ActionReport.ExitCode.WARNING);
                context.getActionReport().setMessage("Obsolete options used.");
            }
        }

        private String generateHeartbeatPort() {
            int MIN_GMS_MULTICAST_PORT = 2048;
            int MAX_GMS_MULTICAST_PORT = 32000;
            int portInterval = 29952;
            return Integer.toString(Math.round((float)(Math.random() * (double)portInterval)) + 2048);
        }

        private String generateHeartbeatAddress() {
            int MAX_GMS_MULTICAST_ADDRESS_SUBRANGE = 255;
            StringBuffer heartbeatAddressBfr = new StringBuffer("228.9.");
            heartbeatAddressBfr.append(Math.round(Math.random() * 255.0)).append('.').append(Math.round(Math.random() * 255.0));
            return heartbeatAddressBfr.toString();
        }
    }
}

