/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.lang.model.tck;

import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.ParameterInfo;
import org.jboss.cdi.lang.model.tck.BridgeMethodsClass;
import org.jboss.cdi.lang.model.tck.BridgeMethodsGenericClass;
import org.jboss.cdi.lang.model.tck.LangModelUtils;

public class BridgeMethods {
    BridgeMethodsClass covariantReturnTypes;
    BridgeMethodsGenericClass generics;

    public static void verify(ClassInfo clazz) {
        BridgeMethods.verifyCovariantReturnTypes(LangModelUtils.classOfField(clazz, "covariantReturnTypes"));
        BridgeMethods.verifyGenerics(LangModelUtils.classOfField(clazz, "generics"));
    }

    private static void verifyCovariantReturnTypes(ClassInfo clazz) {
        assert (clazz.methods().size() == 2);
        assert (clazz.methods().stream().filter(it -> "numberMethod".equals(it.name())).filter(it -> it.returnType().asClass().declaration().name().equals("java.lang.Number")).count() == 1L);
        assert (clazz.methods().stream().filter(it -> "numberMethod".equals(it.name())).filter(it -> it.returnType().asClass().declaration().name().equals("java.lang.Integer")).count() == 1L);
    }

    private static void verifyGenerics(ClassInfo clazz) {
        assert (clazz.methods().size() == 2);
        assert (clazz.methods().stream().filter(it -> "genericMethod".equals(it.name()) && it.parameters().size() == 1 && ((ParameterInfo)it.parameters().get(0)).type().isTypeVariable() && ((ParameterInfo)it.parameters().get(0)).type().asTypeVariable().name().equals("T")).count() == 1L);
        assert (clazz.methods().stream().filter(it -> "genericMethod".equals(it.name()) && it.parameters().size() == 1 && ((ParameterInfo)it.parameters().get(0)).type().isClass() && ((ParameterInfo)it.parameters().get(0)).type().asClass().declaration().name().equals("java.lang.String")).count() == 1L);
    }
}

