/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.invokers.basic;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.InvokerFactory;
import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.build.compatible.spi.Synthesis;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.invoke.Invoker;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderCreator;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderExtensionBase;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.1")
public class ExcessArgumentsInvokerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ExcessArgumentsInvokerTest.class)).withClasses(MyService.class)).withBuildCompatibleExtension(TestExtension.class)).withClasses(InvokerHolder.class, InvokerHolderCreator.class, InvokerHolderExtensionBase.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="behavior_of_invoke", id="k")
    public void test(MyService service, InvokerHolder invokers) throws Exception {
        Invoker hello = invokers.get("hello");
        Assert.assertEquals((String)((String)hello.invoke((Object)service, new Object[]{"a", "ignored"})), (String)"foobar_a");
        Assert.assertEquals((String)((String)hello.invoke((Object)new MyService(), new Object[]{"b", 1, 2, 3})), (String)"foobar_b");
        Invoker helloStatic = invokers.get("helloStatic");
        Assert.assertEquals((String)((String)helloStatic.invoke(null, new Object[]{"c", new Object()})), (String)"quux_c");
        Assert.assertEquals((String)((String)helloStatic.invoke(null, new Object[]{"d", List.of(), Set.of()})), (String)"quux_d");
    }

    @ApplicationScoped
    public static class MyService {
        public String hello(String param) {
            return "foobar_" + param;
        }

        public static String helloStatic(String param) {
            return "quux_" + param;
        }
    }

    public static class TestExtension
    extends InvokerHolderExtensionBase
    implements BuildCompatibleExtension {
        @Registration(types={MyService.class})
        public void myServiceRegistration(BeanInfo bean, InvokerFactory invokers) {
            this.registerInvokers(bean, invokers, Set.of("hello", "helloStatic"));
        }

        @Synthesis
        public void synthesis(SyntheticComponents syn) {
            this.synthesizeInvokerHolder(syn);
        }
    }
}

