/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes;

import jakarta.decorator.Decorator;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.Alpha;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.AlphaStereotype;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.Bravo;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.BravoDecorator;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.BravoInterceptor;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.BravoInterface;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.BravoProducer;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.BravoQualifier;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.Charlie;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.CharlieInterface;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.CharlieProducer;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.CharlieQualifier;
import org.jboss.cdi.tck.tests.full.extensions.lifecycle.processBeanAttributes.VerifyingExtension;
import org.jboss.shrinkwrap.api.BeanDiscoveryMode;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class VerifyValuesTest
extends AbstractTest {
    @Inject
    private VerifyingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        WebArchive archive = (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(VerifyValuesTest.class)).withBeansXml(new BeansXml(BeanDiscoveryMode.ALL).alternatives(Alpha.class, BravoProducer.class, CharlieProducer.class).interceptors(BravoInterceptor.class).decorators(BravoDecorator.class))).withExtension(VerifyingExtension.class)).build();
        return archive;
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="baa")})
    public void testManagedBeanAnnotated() {
        Annotated alphaAnnotated = this.extension.getAnnotatedMap().get(Alpha.class);
        Assert.assertNotNull((Object)alphaAnnotated);
        Assert.assertTrue((boolean)(alphaAnnotated instanceof AnnotatedType));
        AnnotatedType alphaAnnotatedType = (AnnotatedType)alphaAnnotated;
        Assert.assertEquals((Object)alphaAnnotatedType.getJavaClass(), Alpha.class);
        Assert.assertEquals((int)alphaAnnotatedType.getMethods().size(), (int)0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="bac")})
    public void testProducerMethodAnnotated() {
        Annotated bravoAnnotated = this.extension.getAnnotatedMap().get(Bravo.class);
        Assert.assertNotNull((Object)bravoAnnotated);
        Assert.assertTrue((boolean)(bravoAnnotated instanceof AnnotatedMethod));
        AnnotatedMethod bravoAnnotatedMethod = (AnnotatedMethod)bravoAnnotated;
        Assert.assertEquals((String)bravoAnnotatedMethod.getJavaMember().getName(), (String)"createBravo");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="aa"), @SpecAssertion(section="bean_discovery_steps", id="jc")})
    public void testProducerMethodBeanAttributes() {
        BeanAttributes<Bravo> attributes = this.extension.getProducedBravoAttributes();
        Assert.assertNotNull(attributes);
        Assert.assertEquals(RequestScoped.class, (Object)attributes.getScope());
        this.verifyName(attributes, "createBravo");
        Assert.assertTrue((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{BravoInterface.class, Object.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getStereotypes(), new Type[]{AlphaStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), BravoQualifier.class, Named.class, Any.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="bad")})
    public void testProducerFieldAnnotated() {
        Annotated charlieAnnotated = this.extension.getAnnotatedMap().get(Charlie.class);
        Assert.assertNotNull((Object)charlieAnnotated);
        Assert.assertTrue((boolean)(charlieAnnotated instanceof AnnotatedField));
        AnnotatedField charlieAnnotatedField = (AnnotatedField)charlieAnnotated;
        Assert.assertEquals((String)charlieAnnotatedField.getJavaMember().getName(), (String)"charlie");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="aa"), @SpecAssertion(section="bean_discovery_steps", id="jc")})
    public void testProducerFieldBeanAttributes() {
        BeanAttributes<Charlie> attributes = this.extension.getProducedCharlieAttributes();
        Assert.assertNotNull(attributes);
        Assert.assertEquals(ApplicationScoped.class, (Object)attributes.getScope());
        this.verifyName(attributes, "charlie");
        Assert.assertFalse((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Object.class, Charlie.class, CharlieInterface.class}));
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getStereotypes(), new Type[]{AlphaStereotype.class}));
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)attributes.getQualifiers(), CharlieQualifier.class, Named.class, Any.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="ab"), @SpecAssertion(section="process_bean_attributes", id="bb")})
    public void testInterceptorBeanAttributes() {
        BeanAttributes<BravoInterceptor> attributes = this.extension.getBravoInterceptorAttributes();
        Assert.assertNotNull(attributes);
        Assert.assertEquals(Dependent.class, (Object)attributes.getScope());
        Assert.assertFalse((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Object.class, BravoInterceptor.class}));
        Assert.assertTrue((boolean)attributes.getStereotypes().isEmpty());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="ac"), @SpecAssertion(section="process_bean_attributes", id="bb")})
    public void testDecoratorBeanAttributes() {
        BeanAttributes<BravoDecorator> attributes = this.extension.getBravoDecoratorAttributes();
        Assert.assertNotNull(attributes);
        Assert.assertEquals(Dependent.class, (Object)attributes.getScope());
        Assert.assertFalse((boolean)attributes.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(attributes.getTypes(), new Type[]{Object.class, BravoDecorator.class, BravoInterface.class}));
        Assert.assertTrue((attributes.getStereotypes().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Class)attributes.getStereotypes().iterator().next()).equals(Decorator.class));
    }

    private void verifyName(BeanAttributes<?> attributes, String name) {
        Assert.assertEquals((String)name, (String)attributes.getName());
        for (Annotation qualifier : attributes.getQualifiers()) {
            if (!Named.class.equals(qualifier.annotationType())) continue;
            Assert.assertEquals((String)name, (String)((Named)qualifier).value());
            return;
        }
        Assert.fail((String)"@Named qualifier not found.");
    }
}

