/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.lifecycle.bbd;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;

public class ManagerObserver
implements Extension {
    private static boolean afterBeanDiscoveryCalled = false;
    private static boolean afterDeploymentValidationCalled = false;

    public void managerInitialized(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        afterBeanDiscoveryCalled = true;
    }

    public void managerDeployed(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        assert (afterBeanDiscoveryCalled) : "AfterBeanDiscovery should have been called before AfterDeploymentValidation";
        afterDeploymentValidationCalled = true;
    }

    public static boolean isAfterBeanDiscoveryCalled() {
        return afterBeanDiscoveryCalled;
    }

    public static void reset() {
        afterBeanDiscoveryCalled = false;
        afterDeploymentValidationCalled = false;
    }

    public static boolean isAfterDeploymentValidationCalled() {
        return afterDeploymentValidationCalled;
    }
}

