/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.afterBeanDiscovery.annotated;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.jboss.cdi.tck.tests.full.extensions.afterBeanDiscovery.annotated.Alpha;
import org.jboss.cdi.tck.tests.full.extensions.afterBeanDiscovery.annotated.Bar;
import org.jboss.cdi.tck.tests.full.extensions.afterBeanDiscovery.annotated.Bravo;
import org.jboss.cdi.tck.tests.full.extensions.afterBeanDiscovery.annotated.Charlie;
import org.jboss.cdi.tck.tests.full.extensions.afterBeanDiscovery.annotated.Foo;
import org.jboss.cdi.tck.util.AddForwardingAnnotatedTypeAction;
import org.jboss.cdi.tck.util.annotated.AnnotatedTypeWrapper;

public class ModifyingExtension
implements Extension {
    private static final String BASE_ID_BRAVO = ModifyingExtension.class.getName() + "_b";
    private static final String BASE_ID_CHARLIE = ModifyingExtension.class.getName() + "_c";
    private AnnotatedType<Foo> aplha;
    private AnnotatedType<Foo> bravo;
    private AnnotatedType<Foo> charlie;
    private AnnotatedType<Bar> bar;
    private List<AnnotatedType<Foo>> allFoo = new ArrayList<AnnotatedType<Foo>>();

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery event, final BeanManager beanManager) {
        new AddForwardingAnnotatedTypeAction<Foo>(){

            @Override
            public String getBaseId() {
                return BASE_ID_BRAVO;
            }

            @Override
            public AnnotatedType<Foo> delegate() {
                return new AnnotatedTypeWrapper<Foo>(beanManager.createAnnotatedType(Foo.class), false, new Annotation[]{Bravo.BravoLiteral.INSTANCE, Any.Literal.INSTANCE});
            }
        }.perform(event);
        new AddForwardingAnnotatedTypeAction<Foo>(){

            @Override
            public String getBaseId() {
                return BASE_ID_CHARLIE;
            }

            @Override
            public AnnotatedType<Foo> delegate() {
                return new AnnotatedTypeWrapper<Foo>(beanManager.createAnnotatedType(Foo.class), false, Charlie.CharlieLiteral.INSTANCE);
            }
        }.perform(event);
    }

    public void observeProcessAnnotatedType(@Observes ProcessAnnotatedType<Foo> event) {
        if (!(event instanceof ProcessSyntheticAnnotatedType)) {
            event.setAnnotatedType(new AnnotatedTypeWrapper(event.getAnnotatedType(), false, Alpha.AlphaLiteral.INSTANCE));
        }
    }

    public void observeAfterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        for (AnnotatedType annotatedType : event.getAnnotatedTypes(Foo.class)) {
            this.allFoo.add((AnnotatedType<Foo>)annotatedType);
        }
        this.bravo = event.getAnnotatedType(Foo.class, AddForwardingAnnotatedTypeAction.buildId(BASE_ID_BRAVO, Foo.class));
        this.charlie = event.getAnnotatedType(Foo.class, AddForwardingAnnotatedTypeAction.buildId(BASE_ID_CHARLIE, Foo.class));
        this.aplha = event.getAnnotatedType(Foo.class, null);
        this.bar = event.getAnnotatedType(Bar.class, null);
    }

    public AnnotatedType<Foo> getAplha() {
        return this.aplha;
    }

    public AnnotatedType<Foo> getBravo() {
        return this.bravo;
    }

    public AnnotatedType<Foo> getCharlie() {
        return this.charlie;
    }

    public List<AnnotatedType<Foo>> getAllFoo() {
        return this.allFoo;
    }

    public AnnotatedType<Bar> getBar() {
        return this.bar;
    }
}

