/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.validation.connector;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.validation.connector.Activator;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class ValidationFailedDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        if (!(element instanceof EObject) && !(element instanceof ECPProject)) {
            return;
        }
        Integer severity = null;
        if (element instanceof EObject) {
            ECPProject project = ECPUtil.getECPProjectManager().getProject(element);
            if (project != null && project.isOpen()) {
                severity = Activator.getDefault().getValidationService(project).getDiagnostic(element).getSeverity();
            }
        } else if (element instanceof ECPProject && ((ECPProject)element).isOpen()) {
            if (ECPUtil.getECPProjectManager().getProject(((ECPProject)element).getName()) == null) {
                return;
            }
            severity = Activator.getDefault().getValidationService((ECPProject)element).getRootDiagnostic().getSeverity();
        }
        if (severity == null) {
            return;
        }
        switch (severity) {
            case 4: {
                decoration.addOverlay(Activator.getImageDescriptor("icons/error_decorate.png"), 3);
                break;
            }
            case 2: {
                decoration.addOverlay(Activator.getImageDescriptor("icons/warning_decorate.png"), 3);
                break;
            }
            case 0: {
                decoration.addOverlay(null);
                break;
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

