/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;

public final class NumericalHelper {
    private NumericalHelper() {
    }

    public static DecimalFormat setupFormat(Locale locale, Class<?> instanceClass) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        format.setParseIntegerOnly(NumericalHelper.isInteger(instanceClass));
        format.setParseBigDecimal(instanceClass.equals(BigDecimal.class) || instanceClass.equals(BigInteger.class));
        format.setGroupingUsed(false);
        if (NumericalHelper.isDouble(instanceClass)) {
            format.setMaximumFractionDigits(100);
        } else {
            format.setMaximumFractionDigits(0);
        }
        return format;
    }

    public static Number getDefaultValue(Class<?> instanceClass) {
        if (instanceClass.isPrimitive()) {
            try {
                if (Double.class.getField("TYPE").get(null).equals(instanceClass) || Float.class.getField("TYPE").get(null).equals(instanceClass) || Integer.class.getField("TYPE").get(null).equals(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass) || Short.class.getField("TYPE").get(null).equals(instanceClass)) {
                    return 0;
                }
            }
            catch (IllegalArgumentException ex) {
                Activator.logException(ex);
            }
            catch (SecurityException ex) {
                Activator.logException(ex);
            }
            catch (IllegalAccessException ex) {
                Activator.logException(ex);
            }
            catch (NoSuchFieldException ex) {
                Activator.logException(ex);
            }
        } else {
            if (BigDecimal.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Double.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Float.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (BigInteger.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Integer.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Long.class.isAssignableFrom(instanceClass)) {
                return null;
            }
            if (Short.class.isAssignableFrom(instanceClass)) {
                return null;
            }
        }
        return null;
    }

    public static boolean isDouble(Class<?> instanceClass) {
        block9: {
            if (instanceClass.isPrimitive()) {
                try {
                    return Double.class.getField("TYPE").get(null).equals(instanceClass) || Float.class.getField("TYPE").get(null).equals(instanceClass);
                }
                catch (IllegalArgumentException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (SecurityException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (IllegalAccessException ex) {
                    Activator.logException(ex);
                    break block9;
                }
                catch (NoSuchFieldException ex) {
                    Activator.logException(ex);
                    break block9;
                }
            }
            if (BigDecimal.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Double.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Float.class.isAssignableFrom(instanceClass)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInteger(Class<?> instanceClass) {
        block10: {
            if (instanceClass.isPrimitive()) {
                try {
                    return Integer.class.getField("TYPE").get(null).equals(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass) || Short.class.getField("TYPE").get(null).equals(instanceClass);
                }
                catch (IllegalArgumentException ex) {
                    Activator.logException(ex);
                    break block10;
                }
                catch (SecurityException ex) {
                    Activator.logException(ex);
                    break block10;
                }
                catch (IllegalAccessException ex) {
                    Activator.logException(ex);
                    break block10;
                }
                catch (NoSuchFieldException ex) {
                    Activator.logException(ex);
                    break block10;
                }
            }
            if (BigInteger.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Integer.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Long.class.isAssignableFrom(instanceClass)) {
                return true;
            }
            if (Short.class.isAssignableFrom(instanceClass)) {
                return true;
            }
        }
        return false;
    }

    public static Object numberToInstanceClass(Number number, Class<?> instanceClass) {
        if (instanceClass.isPrimitive()) {
            try {
                if (Double.class.getField("TYPE").get(null).equals(instanceClass)) {
                    return number.doubleValue();
                }
                if (Integer.class.getField("TYPE").get(null).equals(instanceClass)) {
                    if (number.doubleValue() >= 2.147483647E9) {
                        return Integer.MAX_VALUE;
                    }
                    if (number.doubleValue() <= -2.147483648E9) {
                        return Integer.MIN_VALUE;
                    }
                    return number.intValue();
                }
                if (Long.class.getField("TYPE").get(null).equals(instanceClass)) {
                    if (number.doubleValue() >= 9.223372036854776E18) {
                        return Long.MAX_VALUE;
                    }
                    if (number.doubleValue() <= -9.223372036854776E18) {
                        return Long.MIN_VALUE;
                    }
                    return number.longValue();
                }
                if (Float.class.getField("TYPE").get(null).equals(instanceClass)) {
                    return Float.valueOf(number.floatValue());
                }
                if (Short.class.getField("TYPE").get(null).equals(instanceClass)) {
                    if (number.doubleValue() >= 32767.0) {
                        return (short)Short.MAX_VALUE;
                    }
                    if (number.doubleValue() <= -32768.0) {
                        return (short)Short.MIN_VALUE;
                    }
                    return number.shortValue();
                }
            }
            catch (IllegalArgumentException ex) {
                Activator.logException(ex);
            }
            catch (SecurityException ex) {
                Activator.logException(ex);
            }
            catch (IllegalAccessException ex) {
                Activator.logException(ex);
            }
            catch (NoSuchFieldException ex) {
                Activator.logException(ex);
            }
        } else {
            if (BigDecimal.class.isAssignableFrom(instanceClass)) {
                return number;
            }
            if (Double.class.isAssignableFrom(instanceClass)) {
                return number.doubleValue();
            }
            if (BigInteger.class.isAssignableFrom(instanceClass)) {
                return ((BigDecimal)number).toBigInteger();
            }
            if (Integer.class.isAssignableFrom(instanceClass)) {
                return number.intValue();
            }
            if (Long.class.isAssignableFrom(instanceClass)) {
                return number.longValue();
            }
            if (Float.class.isAssignableFrom(instanceClass)) {
                return Float.valueOf(number.floatValue());
            }
            if (Short.class.isAssignableFrom(instanceClass)) {
                return number.shortValue();
            }
        }
        return number;
    }
}

