/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.decorators;

import java.util.ArrayList;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.TestStatus;
import org.eclipse.ease.lang.unittest.ui.Activator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class TestStatusDecorator
implements ILightweightLabelDecorator {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof ITestContainer) {
            TestStatus status = ((ITestContainer)element).getStatus();
            this.addOverlay((ITestContainer)element, decoration);
            if (status != TestStatus.PASS) {
                ArrayList testEntities = new ArrayList(((ITestContainer)element).getCopyOfChildren());
                int valid = 0;
                for (ITestEntity entity : testEntities) {
                    if (entity.getStatus() != TestStatus.PASS) continue;
                    ++valid;
                }
                if (testEntities.size() > 0 && valid != testEntities.size()) {
                    decoration.addSuffix(" (" + valid + "/" + testEntities.size() + " valid)");
                }
            }
        }
    }

    public static ImageDescriptor getImage(String image) {
        return Activator.getImageDescriptor("org.eclipse.ease.lang.unittest.ui", "/icons/ovr16/" + image);
    }

    private void addOverlay(ITestContainer element, IDecoration decoration) {
        switch (element.getStatus()) {
            case PASS: {
                decoration.addOverlay(TestStatusDecorator.getImage("success.png"), 2);
                break;
            }
            case ERROR: {
                decoration.addOverlay(TestStatusDecorator.getImage("error.png"), 2);
                break;
            }
            case FAILURE: {
                decoration.addOverlay(TestStatusDecorator.getImage("failure.png"), 2);
                break;
            }
            case RUNNING: {
                decoration.addOverlay(TestStatusDecorator.getImage("running.png"), 2);
                break;
            }
            case DISABLED: {
                decoration.addOverlay(TestStatusDecorator.getImage("ignore.png"), 2);
                break;
            }
        }
        if (!element.getMetadata().isEmpty()) {
            decoration.addOverlay(TestStatusDecorator.getImage("metadata.png"), 1);
        }
    }
}

