/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.handlers;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.Logger;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.ui.dialogs.CreateReportDialog;
import org.eclipse.ease.lang.unittest.ui.handlers.AbstractViewToolbarHandler;
import org.eclipse.ease.lang.unittest.ui.views.UnitTestView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateReport
extends AbstractViewToolbarHandler {
    public final Object execute(ExecutionEvent event) throws ExecutionException {
        block15: {
            UnitTestView view = CreateReport.getView(event, UnitTestView.class);
            if (view != null) {
                ITestEntity testEntity = (ITestEntity)((ITestContainer)view.getFileTreeViewer().getInput()).getCopyOfChildren().get(0);
                CreateReportDialog dialog = new CreateReportDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
                if (dialog.open() == 0) {
                    try {
                        String filename = dialog.getFileName();
                        String extension = "." + dialog.getReport().getDefaultExtension();
                        if (!filename.toLowerCase().endsWith(extension)) {
                            filename = String.valueOf(filename) + extension;
                        }
                        FileWriter writer = new FileWriter(new File(filename));
                        writer.write(dialog.getReport().createReport(dialog.getTitle(), dialog.getDescription(), testEntity));
                        writer.close();
                        try {
                            if (!dialog.isOpenReport()) break block15;
                            if (Platform.getOS().startsWith("win")) {
                                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + new File(filename).toURI().toString());
                                break block15;
                            }
                            if (Platform.getOS().startsWith("linux")) {
                                String desktop = System.getenv("XDG_CURRENT_DESKTOP");
                                if (desktop == null) {
                                    desktop = System.getenv("sun.desktop");
                                }
                                if ("KDE".equalsIgnoreCase(desktop)) {
                                    try {
                                        Runtime.getRuntime().exec("kfmclient exec " + new File(filename).toURI().toString());
                                    }
                                    catch (IOException e) {
                                        Runtime.getRuntime().exec("xdg-open " + new File(filename).toURI().toString());
                                    }
                                } else if ("GNOME".equalsIgnoreCase(desktop)) {
                                    Runtime.getRuntime().exec("gnome-open " + new File(filename).toURI().toString());
                                }
                                break block15;
                            }
                            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Could not open report", (String)("Support for your platform (" + Platform.getOS() + ") not implemented. Please raise a bug if needed."));
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Could not open report", (String)("Support for your platform (" + Platform.getOS() + ") not implemented. Please raise a bug if needed."));
                        }
                    }
                    catch (IOException e) {
                        MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Create Report failed", (String)"Could not open file for writing. Report could not be saved");
                        Logger.error((String)"org.eclipse.ease.lang.unittest.ui", (String)("Could not create report file \"" + dialog.getFileName() + "\""), (Throwable)e);
                    }
                }
            }
        }
        return null;
    }
}

