/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.scriptarchive.ui.export;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ease.lang.scriptarchive.ui.export.ZipFileExporter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;

public class ArchiveFileExportOperation
implements IRunnableWithProgress {
    private ZipFileExporter exporter;
    private final String destinationFilename;
    private IProgressMonitor monitor;
    private List<IResource> resourcesToExport;
    private IResource resource;
    private final List<IStatus> errorTable = new ArrayList<IStatus>(1);
    private boolean useCompression = true;
    private boolean resolveLinks = false;
    private boolean createLeadupStructure = true;

    public ArchiveFileExportOperation(List<IResource> resources, String filename) {
        Iterator<IResource> elementsEnum = resources.iterator();
        while (elementsEnum.hasNext()) {
            IResource currentResource = elementsEnum.next();
            if (!this.isDescendent(resources, currentResource)) continue;
            elementsEnum.remove();
        }
        this.resourcesToExport = resources;
        this.destinationFilename = filename;
    }

    public ArchiveFileExportOperation(IResource res, String filename) {
        this.resource = res;
        this.destinationFilename = filename;
    }

    public ArchiveFileExportOperation(IResource res, List<IResource> resources, String filename) {
        this(res, filename);
        this.resourcesToExport = resources;
    }

    protected void addError(String message, Throwable e) {
        this.errorTable.add((IStatus)new Status(4, "org.eclipse.ease.lang.scriptarchive.ui", 0, message, e));
    }

    protected int countChildrenOf(IResource checkResource) throws CoreException {
        if (checkResource.getType() == 1) {
            return 1;
        }
        int count = 0;
        if (checkResource.isAccessible()) {
            IResource[] children = ((IContainer)checkResource).members();
            int i = 0;
            while (i < children.length) {
                count += this.countChildrenOf(children[i]);
                ++i;
            }
        }
        return count;
    }

    protected int countSelectedResources() throws CoreException {
        int result = 0;
        Iterator<IResource> resources = this.resourcesToExport.iterator();
        while (resources.hasNext()) {
            result += this.countChildrenOf(resources.next());
        }
        return result;
    }

    protected void exportResource(IResource exportResource) throws InterruptedException {
        this.exportResource(exportResource, 1);
    }

    private String createDestinationName(int leadupDepth, IResource exportResource) {
        IPath fullPath = exportResource.getFullPath();
        if (this.createLeadupStructure) {
            return fullPath.makeRelative().toString();
        }
        return fullPath.removeFirstSegments(fullPath.segmentCount() - leadupDepth).makeRelative().toString();
    }

    protected void exportResource(IResource exportResource, int leadupDepth) throws InterruptedException {
        if (!exportResource.isAccessible() || !this.resolveLinks && exportResource.isLinked()) {
            return;
        }
        if (exportResource.getType() == 1) {
            String destinationName = this.createDestinationName(leadupDepth, exportResource);
            this.monitor.subTask(destinationName);
            try {
                this.exporter.write((IFile)exportResource, destinationName);
            }
            catch (IOException e) {
                this.addError("Error exporting " + exportResource.getFullPath().makeRelative() + ": " + e.getMessage(), e);
            }
            catch (CoreException e) {
                this.addError("Error exporting " + exportResource.getFullPath().makeRelative() + ": " + e.getMessage(), e);
            }
            this.monitor.worked(1);
            ModalContext.checkCanceled((IProgressMonitor)this.monitor);
        } else {
            IResource[] children = null;
            try {
                children = ((IContainer)exportResource).members();
            }
            catch (CoreException e) {
                this.addError("Error exporting " + exportResource.getFullPath() + ": " + e.getMessage(), e);
            }
            if (children.length == 0) {
                String destinationName = this.createDestinationName(leadupDepth, exportResource);
                try {
                    this.exporter.write((IContainer)exportResource, String.valueOf(destinationName) + '/');
                }
                catch (IOException e) {
                    this.addError("Error exporting " + exportResource.getFullPath().makeRelative() + ": " + e.getMessage(), e);
                }
            }
            int i = 0;
            while (i < children.length) {
                this.exportResource(children[i], leadupDepth + 1);
                ++i;
            }
        }
    }

    protected void exportSpecifiedResources() throws InterruptedException {
        for (IResource currentResource : this.resourcesToExport) {
            this.exportResource(currentResource);
        }
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        return new MultiStatus("org.eclipse.ease.lang.scriptarchive.ui", 0, errors, "Problems were encountered during export:", null);
    }

    protected void initialize() throws IOException {
        this.exporter = new ZipFileExporter(this.destinationFilename, this.useCompression, this.resolveLinks);
    }

    protected boolean isDescendent(List<IResource> resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.contains(parent)) {
            return true;
        }
        return this.isDescendent(resources, (IResource)parent);
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        this.monitor = progressMonitor;
        try {
            this.initialize();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e, "Unable to open destination file: " + e.getMessage());
        }
        try {
            int totalWork = -1;
            try {
                totalWork = this.resourcesToExport == null ? this.countChildrenOf(this.resource) : this.countSelectedResources();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.monitor.beginTask("Exporting:", totalWork);
            if (this.resourcesToExport == null) {
                this.exportResource(this.resource);
            } else {
                this.exportSpecifiedResources();
            }
            try {
                this.exporter.finished();
            }
            catch (IOException e) {
                throw new InvocationTargetException(e, "Unable to close destination file: " + e.getMessage());
            }
        }
        finally {
            this.monitor.done();
        }
    }

    public void setCreateLeadupStructure(boolean value) {
        this.createLeadupStructure = value;
    }

    public void setUseCompression(boolean value) {
        this.useCompression = value;
    }

    public void setIncludeLinkedResources(boolean value) {
        this.resolveLinks = value;
    }
}

