/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.platform.FilesystemHandle;
import org.eclipse.ease.modules.platform.IFileHandle;
import org.eclipse.ease.modules.platform.ResourceHandle;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ResourcesModule
extends AbstractScriptModule {
    public static final String MODULE_ID = "/System/Resources";
    @WrapToScript
    public static final int READ = 1;
    @WrapToScript
    public static final int WRITE = 2;
    @WrapToScript
    public static final int APPEND = 4;
    private static final String LINE_DELIMITER = System.getProperty("line.separator");

    @WrapToScript
    public static IWorkspaceRoot getWorkspace() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @WrapToScript
    public static IProject getProject(String name) {
        return ResourcesModule.getWorkspace().getProject(name);
    }

    @WrapToScript
    public Object getFile(String location, @ScriptParameter(defaultValue="true") boolean exists) {
        return ResourceTools.resolveFile((Object)location, (Object)this.getScriptEngine().getExecutedFile(), (boolean)exists);
    }

    @WrapToScript
    public static IProject createProject(String name) {
        IProject project = ResourcesModule.getProject(name);
        if (!project.exists()) {
            try {
                project.create((IProgressMonitor)new NullProgressMonitor());
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return project;
    }

    @WrapToScript
    public Object createFolder(Object location) throws CoreException {
        Object folder = ResourceTools.resolveFolder((Object)location, (Object)this.getScriptEngine().getExecutedFile(), (boolean)false);
        if (folder instanceof IFolder) {
            if (!((IFolder)folder).exists()) {
                ((IFolder)folder).create(true, true, (IProgressMonitor)new NullProgressMonitor());
                return folder;
            }
        } else if (folder instanceof File && !((File)folder).exists() && ((File)folder).mkdirs()) {
            return folder;
        }
        return null;
    }

    @WrapToScript
    public Object createFile(Object location) throws Exception {
        IFileHandle handle = this.getFileHandle(location, 2);
        return handle.getFile();
    }

    @WrapToScript
    public IFileHandle openFile(Object location, @ScriptParameter(defaultValue="1") int mode) throws Exception {
        return this.getFileHandle(location, mode);
    }

    @WrapToScript
    public boolean fileExists(Object location) {
        return ResourceTools.resolveFile((Object)location, (Object)this.getScriptEngine().getExecutedFile(), (boolean)true) != null;
    }

    @WrapToScript
    public static void closeFile(IFileHandle handle) {
        handle.close();
    }

    @WrapToScript
    public String readFile(Object location, @ScriptParameter(defaultValue="-1") int bytes) throws Exception {
        IFileHandle handle = this.getFileHandle(location, 1);
        if (handle != null) {
            String result = handle.read(bytes);
            if (!(location instanceof IFileHandle)) {
                handle.close();
            }
            return result;
        }
        throw new IOException("File \"" + location + "\" not found");
    }

    @WrapToScript
    public void copyFile(Object sourceLocation, Object targetLocation) throws Exception {
        IFileHandle handle = this.writeFile(targetLocation, this.readFile(sourceLocation, -1), 2);
        if (handle != null) {
            handle.close();
        }
    }

    @WrapToScript
    public void deleteFile(Object source) throws CoreException {
        Object file = ResourceTools.resolveFile((Object)source, (Object)this.getScriptEngine().getExecutedFile(), (boolean)true);
        if (file instanceof IFile) {
            ((IFile)file).delete(true, (IProgressMonitor)new NullProgressMonitor());
        } else if (file instanceof File && ((File)file).isFile()) {
            ((File)file).delete();
        }
    }

    @WrapToScript
    public void deleteFolder(Object source) throws CoreException {
        Object folder = ResourceTools.resolveFolder((Object)source, (Object)this.getScriptEngine().getExecutedFile(), (boolean)true);
        if (folder instanceof IFolder) {
            ((IFolder)folder).delete(true, (IProgressMonitor)new NullProgressMonitor());
        } else if (folder instanceof File && ((File)folder).isFile()) {
            ((File)folder).delete();
        }
    }

    @WrapToScript
    public void deleteProject(Object source) throws CoreException {
        IProject localProject;
        Object project = ResourceTools.resolveFolder((Object)source, (Object)this.getScriptEngine().getExecutedFile(), (boolean)true);
        if (project instanceof IProject) {
            ((IProject)project).delete(true, (IProgressMonitor)new NullProgressMonitor());
        } else if (source != null && (localProject = ResourcesModule.getProject(source.toString())) != null) {
            localProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @WrapToScript
    public String readLine(Object location) throws Exception {
        IFileHandle handle = this.getFileHandle(location, 1);
        if (handle != null) {
            String result = handle.readLine();
            if (!(location instanceof IFileHandle)) {
                handle.close();
            }
            return result;
        }
        throw new IOException("File \"" + location + "\" not found");
    }

    @WrapToScript
    public IFileHandle writeFile(Object location, Object data, @ScriptParameter(defaultValue="2") int mode) throws Exception {
        IFileHandle handle = this.getFileHandle(location, mode);
        if (handle != null) {
            if (data instanceof byte[]) {
                handle.write((byte[])data);
            } else if (data != null) {
                handle.write(data.toString());
            }
        } else {
            throw new IOException("Could not access resource: " + location);
        }
        return handle;
    }

    @WrapToScript
    public IFileHandle writeLine(Object location, String data, @ScriptParameter(defaultValue="2") int mode) throws Exception {
        IFileHandle handle = this.getFileHandle(location, mode);
        if (handle == null) {
            throw new IOException("Could not access resource: " + location);
        }
        handle.write(String.valueOf(data) + LINE_DELIMITER);
        return handle;
    }

    private IFileHandle getFileHandle(Object location, int mode) throws Exception {
        IFileHandle handle = null;
        if (location instanceof IFileHandle) {
            handle = (IFileHandle)location;
        } else if (location instanceof File) {
            handle = new FilesystemHandle((File)location, mode);
        } else if (location instanceof IFile) {
            handle = new ResourceHandle((IFile)location, mode);
        } else if (location != null) {
            handle = this.getFileHandle(ResourceTools.resolveFile((Object)location, (Object)this.getScriptEngine().getExecutedFile(), (mode == 1 ? 1 : 0) != 0), mode);
        }
        if (handle != null && !handle.exists()) {
            handle.createFile(true);
        }
        return handle;
    }

    @WrapToScript
    public String showFileSelectionDialog(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object rootFolder, final @ScriptParameter(defaultValue="0") int type, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String title, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String message) {
        Object root = ResourceTools.resolveFolder((Object)rootFolder, (Object)this.getScriptEngine().getExecutedFile(), (boolean)true);
        if (rootFolder == null) {
            root = ResourcesModule.getWorkspace();
        }
        if (root instanceof File) {
            int mode;
            switch (type) {
                case 2: 
                case 4: {
                    mode = 8192;
                    break;
                }
                default: {
                    mode = 4096;
                }
            }
            final File dialogRoot = (File)root;
            RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

                public void run() {
                    FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), mode);
                    if (title != null) {
                        dialog.setText(title);
                    }
                    dialog.setFilterPath(dialogRoot.getAbsolutePath());
                    this.setResult(dialog.open());
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (String)runnable.getResult();
        }
        if (root instanceof IContainer) {
            final IContainer dialogRoot = (IContainer)root;
            RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

                public void run() {
                    if (type == 2 || type == 4) {
                        SaveAsDialog dialog = new SaveAsDialog(Display.getDefault().getActiveShell());
                        if (!dialogRoot.equals((Object)ResourcesModule.getWorkspace())) {
                            dialog.setOriginalFile(dialogRoot.getFile((IPath)new Path("newFile")));
                        }
                        dialog.setTitle(title);
                        dialog.setMessage(message);
                        if (dialog.open() == 0) {
                            this.setResult("workspace:/" + dialog.getResult().toPortableString());
                        }
                    } else {
                        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                        dialog.setTitle(title);
                        dialog.setMessage(message);
                        dialog.setInput((Object)dialogRoot);
                        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                        if (dialog.open() == 0) {
                            this.setResult("workspace:/" + ((IResource)dialog.getFirstResult()).getFullPath().toPortableString());
                        }
                    }
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (String)runnable.getResult();
        }
        return null;
    }

    @WrapToScript
    public String showFolderSelectionDialog(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object rootFolder, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String title, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String message) {
        Object root = ResourceTools.resolveFolder((Object)rootFolder, (Object)this.getScriptEngine().getExecutedFile(), (boolean)true);
        if (rootFolder == null) {
            root = ResourcesModule.getWorkspace();
        }
        if (root instanceof File) {
            final File dialogRoot = (File)root;
            RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

                public void run() {
                    DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
                    if (title != null) {
                        dialog.setText(title);
                    }
                    if (message != null) {
                        dialog.setMessage(message);
                    }
                    dialog.setFilterPath(dialogRoot.getAbsolutePath());
                    this.setResult(dialog.open());
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (String)runnable.getResult();
        }
        if (root instanceof IContainer) {
            final IContainer dialogRoot = (IContainer)root;
            RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

                public void run() {
                    ContainerSelectionDialog dialog = new ContainerSelectionDialog(Display.getDefault().getActiveShell(), dialogRoot, true, message);
                    dialog.setTitle(title);
                    if (dialog.open() == 0) {
                        this.setResult("workspace:/" + ((IPath)dialog.getResult()[0]).toPortableString());
                    }
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (String)runnable.getResult();
        }
        return null;
    }

    @WrapToScript
    public Object[] findFiles(String pattern, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object rootFolder, @ScriptParameter(defaultValue="true") boolean recursive) {
        Pattern regExp = !pattern.startsWith("^") ? Pattern.compile(pattern.replace("*", ".*").replace('?', '.')) : Pattern.compile(pattern);
        ArrayList<Object> result = new ArrayList<Object>();
        Object root = ResourceTools.resolveFolder((Object)rootFolder, (Object)this.getScriptEngine().getExecutedFile(), (boolean)true);
        if (root == null) {
            root = ResourcesModule.getWorkspace();
        }
        if (root instanceof IContainer) {
            HashSet<IContainer> toVisit = new HashSet<IContainer>();
            toVisit.add((IContainer)root);
            do {
                IContainer container = (IContainer)toVisit.iterator().next();
                toVisit.remove(container);
                try {
                    IResource[] iResourceArray = container.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource child = iResourceArray[n2];
                        if (child instanceof IFile) {
                            if (regExp.matcher(child.getName()).matches()) {
                                result.add(child);
                            }
                        } else if (recursive && child instanceof IContainer) {
                            toVisit.add((IContainer)child);
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
            } while (!toVisit.isEmpty());
        } else if (root instanceof File) {
            HashSet<File> toVisit = new HashSet<File>();
            toVisit.add((File)root);
            do {
                File container = (File)toVisit.iterator().next();
                toVisit.remove(container);
                File[] fileArray = container.listFiles();
                int n = fileArray.length;
                int n3 = 0;
                while (n3 < n) {
                    File child = fileArray[n3];
                    if (child.isFile()) {
                        if (regExp.matcher(child.getName()).matches()) {
                            result.add(child);
                        }
                    } else if (recursive && child.isDirectory()) {
                        toVisit.add(child);
                    }
                    ++n3;
                }
            } while (!toVisit.isEmpty());
        }
        return result.toArray(new Object[result.size()]);
    }

    @WrapToScript
    public boolean linkProject(String location) {
        Object resolvedLocation = ResourceTools.resolveFolder((Object)location, (Object)this.getScriptEngine().getExecutedFile(), (boolean)true);
        if (resolvedLocation instanceof IContainer) {
            Logger.warning((String)"org.eclipse.ease.modules.platform", (String)("The folder to link is already part of the workspace: " + location));
            return false;
        }
        if (resolvedLocation instanceof File) {
            Path projectPath = new Path(((File)resolvedLocation).getAbsoluteFile() + File.separator + ".project");
            try {
                IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)projectPath);
                IProject project = ResourcesModule.getProject(description.getName());
                project.create(description, null);
                project.open(null);
                return true;
            }
            catch (CoreException e) {
                Logger.error((String)"org.eclipse.ease.modules.platform", (String)"Could not link to project", (Throwable)e);
                return false;
            }
        }
        Logger.warning((String)"org.eclipse.ease.modules.platform", (String)("Could not resolve location: " + location));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapToScript
    public void refreshResource(IResource resource) throws CoreException {
        ProgressMonitor monitor = new ProgressMonitor();
        resource.refreshLocal(2, (IProgressMonitor)monitor);
        while (!monitor.isDone()) {
            ProgressMonitor progressMonitor = monitor;
            synchronized (progressMonitor) {
                try {
                    System.out.println("waiting");
                    ((Object)((Object)monitor)).wait(1000L);
                    System.out.println("wakeup");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @WrapToScript
    public String readStream(InputStream input) throws IOException {
        return ResourceTools.toString((InputStream)input);
    }

    @WrapToScript
    public void createProblemMarker(String severity, Object location, int lineNumber, String message, @ScriptParameter(defaultValue="org.eclipse.core.resources.problemmarker") String type, @ScriptParameter(defaultValue="true") boolean permanent) throws CoreException {
        Object file = ResourceTools.resolveFile((Object)location, (Object)this.getScriptEngine().getExecutedFile(), (boolean)true);
        if (file instanceof IFile) {
            int intSeverity = 0;
            if ("error".equals(severity)) {
                intSeverity = 2;
            }
            if ("warning".equals(severity)) {
                intSeverity = 1;
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("lineNumber", lineNumber);
            attributes.put("severity", intSeverity);
            attributes.put("message", message);
            attributes.put("transient", !permanent);
            MarkerUtilities.createMarker((IResource)((IFile)file), attributes, (String)type);
        }
    }

    private class ProgressMonitor
    extends NullProgressMonitor {
        private boolean fDone = false;

        private ProgressMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            this.fDone = true;
            ProgressMonitor progressMonitor = this;
            synchronized (progressMonitor) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        public boolean isDone() {
            return this.fDone;
        }
    }
}

