/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.unittest.components.TestFile;
import org.eclipse.ease.modules.unittest.components.TestSuite;
import org.eclipse.ease.modules.unittest.ui.Activator;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class TestSuiteLabelProvider
extends LabelProvider {
    private final LocalResourceManager fResourceManager;

    public TestSuiteLabelProvider(LocalResourceManager resourceManager) {
        this.fResourceManager = resourceManager;
    }

    public String getText(Object element) {
        if (element instanceof TestSuite) {
            IFile file = ((TestSuite)element).getModel().getFile();
            return file != null ? file.getName() : "<dynamic>";
        }
        if (element instanceof IPath) {
            return ((IPath)element).lastSegment();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof TestSuite) {
            return this.fResourceManager.createImage(Activator.getImageDescriptor("/icons/eobj16/testsuite.png"));
        }
        if (element instanceof IPath) {
            return this.fResourceManager.createImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        }
        if (element instanceof TestFile) {
            return this.fResourceManager.createImage(PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(((TestFile)element).getFile().toString()));
        }
        return super.getImage(element);
    }
}

