/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.modules.unittest.ITestListener;
import org.eclipse.ease.modules.unittest.components.Test;
import org.eclipse.ease.modules.unittest.components.TestEntity;
import org.eclipse.ease.modules.unittest.components.TestResult;
import org.eclipse.ease.modules.unittest.components.TestStatus;

public abstract class TestComposite
extends TestEntity
implements ITestListener {
    public static final String CURRENT_TESTCOMPOSITE = "__internal_testObject";
    private static final String GLOBAL_TEST_SCOPE = "[outside test scope]";
    private IScriptEngine fEngine = null;
    private final List<Test> fTests = new LinkedList<Test>();
    private Test fCurrentTest = null;
    private Test fGlobalTestScope = null;

    public TestComposite(TestComposite parent) {
        super(parent);
    }

    @Override
    public TestStatus getStatus() {
        TestStatus status = super.getStatus();
        for (Test test : this.getTests()) {
            status = status.merge(test.getStatus());
        }
        for (TestEntity testEntity : this.getChildren()) {
            status = status.merge(testEntity.getStatus());
        }
        return status;
    }

    @Override
    public void notify(Object testObject, TestStatus status) {
        this.fireTestEvent(testObject, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTest(Test test) {
        this.endTest();
        List<Test> list = this.fTests;
        synchronized (list) {
            if (!this.fTests.contains(test)) {
                this.fTests.add(test);
            }
        }
        this.fCurrentTest = test;
        test.addTestListener(this);
        test.setStatus(TestStatus.RUNNING);
    }

    public void endTest() {
        if (this.fCurrentTest != null) {
            this.fCurrentTest.setStatus(TestStatus.PASS);
            this.fCurrentTest.removeTestListener(this);
        }
        this.fCurrentTest = this.fGlobalTestScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        List<Test> list = this.fTests;
        synchronized (list) {
            this.fTests.clear();
        }
        this.fGlobalTestScope = null;
        this.fCurrentTest = null;
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Test getCurrentTest() {
        if (this.fCurrentTest == null) {
            this.fGlobalTestScope = new Test(this, GLOBAL_TEST_SCOPE, true);
            List<Test> list = this.fTests;
            synchronized (list) {
                this.fTests.add(0, this.fGlobalTestScope);
            }
            this.addTest(this.fGlobalTestScope);
        }
        return this.fCurrentTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Test> getTests() {
        ArrayList<Test> result = new ArrayList<Test>();
        List<Test> list = this.fTests;
        synchronized (list) {
            for (Test test : this.fTests) {
                if (test.isTransient() && test.getStatus() == TestStatus.PASS && test.getMetaData().isEmpty()) continue;
                result.add(test);
            }
        }
        return result;
    }

    public void addTestResult(TestStatus status, String message) {
        this.addTestResult(status, message, this.getStackTrace());
    }

    public void addTestResult(TestStatus status, String message, List<IScriptDebugFrame> trace) {
        this.getCurrentTest().addMessage(new TestResult(status, message, trace));
    }

    protected void setScriptEngine(IScriptEngine scriptEngine) {
        this.fEngine = scriptEngine;
    }

    protected IScriptEngine getScriptEngine() {
        return this.fEngine;
    }

    private List<IScriptDebugFrame> getStackTrace() {
        if (this.fEngine instanceof IDebugEngine) {
            return ((IDebugEngine)this.fEngine).getStackTrace();
        }
        if (this.fEngine instanceof AbstractScriptEngine) {
            return ((AbstractScriptEngine)this.fEngine).getStackTrace();
        }
        return Collections.emptyList();
    }

    public abstract Collection<? extends TestEntity> getChildren();

    public abstract Object getFile();
}

