/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.ICodeParser;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.completion.ICompletionProvider;
import org.eclipse.ease.ui.completion.ScriptCompletionProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;

public class CodeCompletionAggregator
implements IContentProposalProvider {
    public static final String COMPLETION_PROCESSOR = "org.eclipse.ease.ui.codeCompletionProvider";
    public static final String ATTRIBUTE_SCRIPT_TYPE = "scriptType";
    public static final String ATTRIBUTE_CLASS = "class";
    private ICodeParser fCodeParser;
    private Collection<ICompletionProvider> fCompletionProviders = Collections.emptySet();
    private IScriptEngine fScriptEngine;

    private static Collection<ICompletionProvider> getProviders(String scriptType) {
        IConfigurationElement[] elements;
        ArrayList<ICompletionProvider> providers = new ArrayList<ICompletionProvider>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(COMPLETION_PROCESSOR);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String registeredType;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (scriptType == null || (registeredType = element.getAttribute(ATTRIBUTE_SCRIPT_TYPE)) == null || registeredType.isEmpty() || scriptType.equals(registeredType)) {
                try {
                    Object candidate = element.createExecutableExtension(ATTRIBUTE_CLASS);
                    if (candidate instanceof ICompletionProvider) {
                        providers.add((ICompletionProvider)candidate);
                    }
                }
                catch (CoreException e) {
                    Logger.error((String)"org.eclipse.ease.ui", (String)("Invalid completion provider detected in " + element.getContributor().getName()), (Throwable)e);
                }
            }
            ++n2;
        }
        return providers;
    }

    public void setCodeParser(ICodeParser codeParser) {
        this.fCodeParser = codeParser;
    }

    public char[] getActivationChars() {
        return new char[]{'.'};
    }

    public void setScriptEngine(IScriptEngine scriptEngine) {
        this.fScriptEngine = scriptEngine;
        if (this.fScriptEngine != null) {
            this.setScriptType((ScriptType)this.fScriptEngine.getDescription().getSupportedScriptTypes().get(0));
        }
    }

    public void setScriptType(ScriptType scriptType) {
        this.setCodeParser(scriptType.getCodeParser());
        this.fCompletionProviders = CodeCompletionAggregator.getProviders(scriptType.getName());
    }

    public List<ScriptCompletionProposal> getCompletionProposals(Object resource, String relevantText, int insertOffset, int selectionRange, IProgressMonitor monitor) {
        LinkedList<ScriptCompletionProposal> proposals = new LinkedList<ScriptCompletionProposal>();
        ICompletionContext context = this.createContext(resource, relevantText, insertOffset, selectionRange);
        for (ICompletionProvider provider : this.fCompletionProviders) {
            try {
                if (!provider.isActive(context)) continue;
                proposals.addAll(provider.getProposals(context));
            }
            catch (Exception ex) {
                Logger.error((String)"org.eclipse.ease.ui", (String)("Could not get proposals from ICompletionProvider <" + provider.getClass().getName() + ">"), (Throwable)ex);
            }
        }
        return proposals;
    }

    private ICompletionContext createContext(Object resource, String relevantText, int insertOffset, int selectionRange) {
        if (this.fCodeParser != null) {
            return this.fCodeParser.getContext(this.fScriptEngine, resource, relevantText, insertOffset, selectionRange);
        }
        return null;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        List<ScriptCompletionProposal> proposals = this.getCompletionProposals(null, contents, position, 0, null);
        Collections.sort(proposals);
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }
}

