/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino.debugger;

import java.util.List;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.debugging.EventDispatchJob;
import org.eclipse.ease.debugging.IEventProcessor;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.lang.javascript.rhino.RhinoScriptEngine;
import org.eclipse.ease.lang.javascript.rhino.debugger.LineNumberDebugger;
import org.eclipse.ease.lang.javascript.rhino.debugger.RhinoDebugger;
import org.eclipse.ease.lang.javascript.rhino.debugger.model.RhinoDebugTarget;
import org.mozilla.javascript.debug.Debugger;

public class RhinoDebuggerEngine
extends RhinoScriptEngine
implements IDebugEngine {
    public RhinoDebuggerEngine() {
        super("Rhino Debugger");
        this.setDebugger(new LineNumberDebugger((IScriptEngine)this));
    }

    public void setOptimizationLevel(int level) {
    }

    public void setupDebugger(ILaunch launch, boolean suspendOnStartup, boolean suspendOnScriptLoad, boolean showDynamicCode) {
        RhinoDebugTarget debugTarget = new RhinoDebugTarget(launch, suspendOnStartup, suspendOnScriptLoad, showDynamicCode);
        launch.addDebugTarget((IDebugTarget)debugTarget);
        RhinoDebugger debugger = new RhinoDebugger((IScriptEngine)this, showDynamicCode);
        this.setDebugger(debugger);
        EventDispatchJob dispatcher = new EventDispatchJob((IEventProcessor)debugTarget, (IEventProcessor)debugger);
        debugTarget.setDispatcher(dispatcher);
        debugger.setDispatcher(dispatcher);
        dispatcher.schedule();
    }

    public List<IScriptDebugFrame> getStackTrace() {
        Debugger debugger = this.getDebugger();
        if (debugger instanceof RhinoDebugger) {
            return ((RhinoDebugger)debugger).getStacktrace();
        }
        return super.getStackTrace();
    }
}

