/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.ui;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ease.lang.javascript.ui.ModuleProposalCalculator;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposalComputer;

public class ModuleCompletionProposal
extends ModuleProposalCalculator
implements IJavaCompletionProposalComputer {
    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        Collection<ModuleDefinition> modules = this.getLoadedModules(context);
        try {
            Matcher matcher = this.matchLastToken(context);
            if (matcher.matches()) {
                if (".".equals(matcher.group(1))) {
                    return Collections.EMPTY_LIST;
                }
                List<CompletionProposal> proposals = this.createProposals(context, modules, matcher.group(2));
                return proposals;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return Collections.EMPTY_LIST;
    }

    private List<CompletionProposal> createProposals(ContentAssistInvocationContext context, Collection<ModuleDefinition> modules, String prefix) {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        for (ModuleDefinition definition : modules) {
            for (Field field : definition.getFields()) {
                if (!field.getName().startsWith(prefix)) continue;
                proposals.add(new CompletionProposal(field.getName(), context.getInvocationOffset() - prefix.length(), prefix.length(), field.getName().length()));
            }
            for (Method method : definition.getMethods()) {
                if (!method.getName().startsWith(prefix)) continue;
                proposals.add(new CompletionProposal(String.valueOf(method.getName()) + "()", context.getInvocationOffset() - prefix.length(), prefix.length(), method.getName().length() + 2));
            }
        }
        return proposals;
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }
}

