/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.IHeaderParser;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.repository.IScript;
import org.eclipse.ease.ui.scripts.repository.impl.RepositoryService;
import org.eclipse.ui.PlatformUI;

public class InputStreamParser {
    private static final int MAX_LINES = 50;
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile(".*script-type:\\s*(.*)", 2);
    private final RepositoryService fRepositoryService;

    public InputStreamParser(RepositoryService repositoryService) {
        this.fRepositoryService = repositoryService;
    }

    protected RepositoryService getRepositoryService() {
        return this.fRepositoryService;
    }

    protected IScript getScriptByLocation(String location) {
        for (IScript script : this.getRepositoryService().getScripts()) {
            if (!script.getLocation().equals(location)) continue;
            return script;
        }
        return null;
    }

    protected Map<String, String> extractParameters(ScriptType type, InputStream stream) {
        IHeaderParser parser = type.getHeaderParser();
        if (parser != null) {
            return parser.parser(stream);
        }
        return Collections.emptyMap();
    }

    protected ScriptType getScriptType(InputStream contents) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(contents));
        try {
            String line = reader.readLine();
            int lineCount = 50;
            while (line != null && lineCount-- > 0) {
                IScriptService scriptService;
                ScriptType scriptType;
                Matcher matcher = CONTENT_TYPE_PATTERN.matcher(line);
                if (!matcher.matches() || (scriptType = (ScriptType)(scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class)).getAvailableScriptTypes().get(matcher.group(1))) == null) continue;
                return scriptType;
            }
        }
        catch (IOException iOException) {}
        return null;
    }
}

