/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Map;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.repository.IRepositoryFactory;
import org.eclipse.ease.ui.repository.IScript;
import org.eclipse.ease.ui.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.impl.InputStreamParser;
import org.eclipse.ease.ui.scripts.repository.impl.RepositoryService;
import org.eclipse.ui.PlatformUI;

public class FileSystemParser
extends InputStreamParser {
    public FileSystemParser(RepositoryService repositoryService) {
        super(repositoryService);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(File file, IScriptLocation entry) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile() || entry.isRecursive()) {
                    this.parse(child, entry);
                }
                ++n2;
            }
            return;
        } else {
            String location = file.toURI().toString();
            IScript script = this.getScriptByLocation(location);
            try {
                IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
                if (script == null) {
                    ScriptType scriptType = scriptService.getScriptType(file.toURI().toASCIIString());
                    if (scriptType == null) return;
                    script = IRepositoryFactory.eINSTANCE.createScript();
                    script.setEntry(entry);
                    script.setLocation(location);
                    Map<String, String> parameters = this.extractParameters(scriptType, new FileInputStream(file));
                    script.getScriptParameters().clear();
                    script.getScriptParameters().putAll(parameters);
                    script.setTimestamp(file.lastModified());
                    this.getRepositoryService().addScript(script);
                    return;
                }
                if (script.getTimestamp() != file.lastModified()) {
                    ScriptType scriptType = scriptService.getScriptType(file.toURI().toASCIIString());
                    Map<String, String> parameters = this.extractParameters(scriptType, new FileInputStream(file));
                    script.setTimestamp(file.lastModified());
                    this.getRepositoryService().updateScript(script, parameters);
                    return;
                }
                script.setUpdatePending(false);
                return;
            }
            catch (FileNotFoundException e) {
                Logger.logError((String)("Cannot locate script file: " + file), (Throwable)e);
            }
        }
    }
}

