/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino.completion;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.ui.completion.ModuleCompletionProvider;
import org.eclipse.jface.fieldassist.ContentProposal;

public class RhinoCompletionProvider
extends ModuleCompletionProvider {
    private static final Pattern VARIABLES_PATTERN = Pattern.compile(".*?(\\p{Alnum}+)\\s*=\\s*[^=]+");
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("function\\s+(\\p{Alpha}\\p{Alnum}*)\\(");
    private final Collection<String> fVariables = new HashSet<String>();
    private final Collection<String> fFunctions = new HashSet<String>();

    public void addCode(String code) {
        Matcher matcher = VARIABLES_PATTERN.matcher(code);
        while (matcher.find()) {
            this.fVariables.add(matcher.group(1));
        }
        matcher = FUNCTION_PATTERN.matcher(code);
        while (matcher.find()) {
            this.fFunctions.add(matcher.group(1));
        }
        super.addCode(code);
    }

    protected void modifyProposals(Collection<ContentProposal> proposals, String contents) {
        Matcher matcher = this.matchLastToken(contents);
        if (matcher.matches() && !".".equals(matcher.group(1))) {
            for (String variable : this.fVariables) {
                if (!variable.startsWith(matcher.group(2)) || matcher.group(2).length() >= variable.length()) continue;
                proposals.add(new ContentProposal(variable.substring(matcher.group(2).length()), variable, "local variable"));
            }
            for (String function : this.fFunctions) {
                if (!function.startsWith(matcher.group(2)) || matcher.group(2).length() >= function.length()) continue;
                proposals.add(new ContentProposal(function.substring(matcher.group(2).length()), function, "local function"));
            }
        }
    }
}

