/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.ui.common.validation;

import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;
import org.eclipse.dirigible.ide.ui.common.validation.Messages;

public class ValidationStatus
implements IValidationStatus {
    private static final String OK_STATUS = Messages.ValidationStatus_OK_STATUS;
    private static final String WARNING_STATUS = Messages.ValidationStatus_WARNING_STATUS;
    private static final String ERROR_STATUS = Messages.ValidationStatus_ERROR_STATUS;
    private final Type type;
    private final String message;

    public static ValidationStatus createOk() {
        return new ValidationStatus(Type.OK, null);
    }

    public static ValidationStatus createWarning(String message) {
        return new ValidationStatus(Type.WARNING, message);
    }

    public static ValidationStatus createError(String message) {
        return new ValidationStatus(Type.ERROR, message);
    }

    private ValidationStatus(Type type, String message) {
        this.type = type;
        this.message = message;
    }

    @Override
    public boolean hasErrors() {
        return this.type == Type.ERROR;
    }

    @Override
    public boolean hasWarnings() {
        return this.type == Type.WARNING;
    }

    @Override
    public boolean isOK() {
        return !this.hasWarnings() && !this.hasErrors();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String toString() {
        if (this.hasErrors()) {
            return String.valueOf(ERROR_STATUS) + this.getMessage();
        }
        if (this.hasWarnings()) {
            return String.valueOf(WARNING_STATUS) + this.getMessage();
        }
        return OK_STATUS;
    }

    public static IValidationStatus getValidationStatus(IValidationStatus validationStatus_1, IValidationStatus validationStatus_2) {
        if (validationStatus_1.hasErrors()) {
            if (validationStatus_2.hasErrors()) {
                return ValidationStatus.createError(String.valueOf(validationStatus_1.getMessage()) + " \n" + validationStatus_2.getMessage());
            }
            return validationStatus_1;
        }
        if (validationStatus_2.hasErrors()) {
            return validationStatus_2;
        }
        if (validationStatus_1.hasWarnings()) {
            if (validationStatus_2.hasWarnings()) {
                return ValidationStatus.createWarning(String.valueOf(validationStatus_1.getMessage()) + " \n" + validationStatus_2.getMessage());
            }
            return validationStatus_1;
        }
        return validationStatus_2;
    }

    private static enum Type {
        OK,
        ERROR,
        WARNING;

    }
}

