/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository.ui.command;

import java.io.IOException;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.dirigible.ide.repository.ui.command.Messages;
import org.eclipse.dirigible.ide.repository.ui.command.RefreshHandler;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteHandler
extends AbstractHandler {
    private static final String CONFIRM_DELETE = Messages.DeleteHandler_CONFIRM_DELETE;
    private static final String ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS_D = Messages.DeleteHandler_ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS_D;
    private static final String EMPTY_STRING = "";
    private static final String ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEM = Messages.DeleteHandler_ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEM;
    private static final String SOME_OR_ALL_OF_THE_FILES_COULD_NOT_BE_DELETED = Messages.DeleteHandler_SOME_OR_ALL_OF_THE_FILES_COULD_NOT_BE_DELETED;
    private static final String DELETE_ERROR = Messages.DeleteHandler_DELETE_ERROR;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            this.execute((IStructuredSelection)selection);
            RefreshHandler.refreshActivePart(event);
        }
        return null;
    }

    public void execute(IStructuredSelection selection) {
        ResourceComparator comparator = new ResourceComparator();
        TreeSet<IEntity> resources = new TreeSet<IEntity>(comparator);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IEntity) {
                resources.add((IEntity)element);
            }
            ++n2;
        }
        this.execute(resources);
    }

    private void execute(SortedSet<IEntity> resources) {
        if (resources.size() == 0) {
            return;
        }
        if (!DeleteHandler.confirmDelete(resources.size())) {
            return;
        }
        IOException throwable = null;
        for (IEntity resource : resources) {
            try {
                resource.delete();
            }
            catch (IOException ex) {
                if (throwable != null) continue;
                throwable = ex;
            }
        }
        if (throwable != null) {
            MessageDialog.openWarning(null, (String)DELETE_ERROR, (String)SOME_OR_ALL_OF_THE_FILES_COULD_NOT_BE_DELETED);
        }
    }

    private static boolean confirmDelete(int count) {
        String message = EMPTY_STRING;
        message = count == 1 ? ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEM : String.format(ARE_YOU_SURE_YOU_WANT_TO_DELETE_SELECTED_ITEMS_D, count);
        return MessageDialog.openConfirm(null, (String)CONFIRM_DELETE, (String)message);
    }

    private class ResourceComparator
    implements Comparator<IEntity> {
        private ResourceComparator() {
        }

        @Override
        public int compare(IEntity o1, IEntity o2) {
            String path1 = o1.getPath().toString();
            String path2 = o2.getPath().toString();
            return path2.compareTo(path1);
        }
    }
}

