/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ws.util;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import com.ibm.wsdl.extensions.schema.SchemaImportImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.datatools.enablement.oda.ws.util.MultipleNodeList;
import org.eclipse.datatools.enablement.oda.ws.util.WSLeafNode;
import org.eclipse.datatools.enablement.oda.ws.util.WSNonLeafNode;
import org.eclipse.datatools.enablement.oda.ws.util.WSUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLAdvisor {
    public static final String RE_DELIMITER_OPEARTION = "\\Q$-$\\E";
    public static final String XML_DECLARATION = "<?xml version=\"1.0\"?>";
    public static final String SOAP_ENVELOPE_START = "<SOAP-ENV:Envelope";
    public static final String SOAP_ENVELOPE_END = "</SOAP-ENV:Envelope>";
    public static final String SOAP_HEADER_START = "<SOAP-ENV:Header>";
    public static final String SOAP_HEADER_END = "</SOAP-ENV:Header>";
    public static final String SOAP_BODY_START = "<SOAP-ENV:Body>";
    public static final String SOAP_BODY_END = "</SOAP-ENV:Body>";
    public static final String NS_SOAP_ENV = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String NS_SOAP_ENC = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String NS_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String NS_KEY_SOAP_ENV = "SOAP-ENV";
    public static final String NS_KEY_SOAP_ENC = "SOAP-ENC";
    public static final String NS_KEY_XSI = "xsi";
    public static final String NS_KEY_XSD = "xsd";
    public static final String NS_KEY_DEFAULT = "m";
    public static final String NS_DEFAULT = "m:";
    public static final String EMPTY_STRING = "";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String REF = "ref";
    public static final String BASE = "base";
    public static final String SIMPLE_TYPE = "simpleType";
    public static final String COMPLEX_TYPE = "complexType";
    public static final String CHOICE = "choice";
    private static Map definitionMap = new HashMap();
    private static List primitiveDataTypeList;

    public static Definition getDefinition(String wsdlURI) throws WSDLException {
        if (definitionMap.containsKey(wsdlURI)) {
            return (Definition)definitionMap.get(wsdlURI);
        }
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", true);
        reader.setFeature("javax.wsdl.importDocuments", true);
        Definition definition = reader.readWSDL(null, wsdlURI);
        definitionMap.put(wsdlURI, definition);
        return definition;
    }

    public static Definition getDefinitionWithoutExcpe(String wsdlURI) {
        try {
            return WSDLAdvisor.getDefinition(wsdlURI);
        }
        catch (WSDLException wSDLException) {
            return null;
        }
    }

    public static String getLocationURI(String wsdlURI, String operationTrace) {
        String locationURI = EMPTY_STRING;
        if (!WSDLAdvisor.checkOperationTrace(operationTrace)) {
            return locationURI;
        }
        Definition definition = WSDLAdvisor.getDefinitionWithoutExcpe(wsdlURI);
        if (WSUtil.isNull(definition)) {
            return locationURI;
        }
        String[] opSplit = operationTrace.split(RE_DELIMITER_OPEARTION);
        Service service = definition.getService(new QName(definition.getTargetNamespace(), opSplit[0]));
        if (WSUtil.isNull(service)) {
            return null;
        }
        Port port = service.getPort(opSplit[1]);
        List extElements = port.getExtensibilityElements();
        if (!WSUtil.isNull(extElements)) {
            int i = 0;
            while (i < extElements.size()) {
                if (extElements.get(i) instanceof SOAPAddress) {
                    locationURI = ((SOAPAddress)extElements.get(i)).getLocationURI();
                    break;
                }
                if (extElements.get(i) instanceof HTTPAddress) {
                    locationURI = ((HTTPAddress)extElements.get(i)).getLocationURI();
                    break;
                }
                ++i;
            }
        }
        return locationURI;
    }

    private static boolean checkOperationTrace(String operationTrace) {
        if (WSUtil.isNull(operationTrace)) {
            return false;
        }
        String[] opSplit = operationTrace.split(RE_DELIMITER_OPEARTION);
        return opSplit.length == 3;
    }

    public static String getSOAPActionURI(String wsdlURI, String operationTrace) {
        String soapActionURI = EMPTY_STRING;
        BindingOperation bindingOperation = WSDLAdvisor.getBindingOperation(wsdlURI, operationTrace);
        if (WSUtil.isNull(bindingOperation)) {
            return soapActionURI;
        }
        List extElements = bindingOperation.getExtensibilityElements();
        if (!WSUtil.isNull(extElements)) {
            int i = 0;
            while (i < extElements.size()) {
                if (extElements.get(i) instanceof SOAPOperation) {
                    soapActionURI = ((SOAPOperation)extElements.get(i)).getSoapActionURI();
                    break;
                }
                ++i;
            }
        }
        return soapActionURI;
    }

    public static String retrieveDocument(Operation operation) {
        String result = EMPTY_STRING;
        if (WSUtil.isNull(operation)) {
            return result;
        }
        Element element = operation.getDocumentationElement();
        if (!WSUtil.isNull(element)) {
            NodeList nodes = element.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 3) {
                    result = String.valueOf(result) + node.getNodeValue();
                }
                ++i;
            }
        }
        return result;
    }

    private static BindingOperation getBindingOperation(String wsdlURI, String operationTrace) {
        if (!WSDLAdvisor.checkOperationTrace(operationTrace)) {
            return null;
        }
        Definition definition = WSDLAdvisor.getDefinitionWithoutExcpe(wsdlURI);
        if (WSUtil.isNull(definition)) {
            return null;
        }
        String[] opSplit = operationTrace.split(RE_DELIMITER_OPEARTION);
        Service service = definition.getService(new QName(definition.getTargetNamespace(), opSplit[0]));
        if (WSUtil.isNull(service)) {
            return null;
        }
        Port port = service.getPort(opSplit[1]);
        BindingOperation bindingOperation = port.getBinding().getBindingOperation(opSplit[2], null, null);
        return bindingOperation;
    }

    public String getSOAPRequestTemplate(String wsdlURI, String operationTrace) {
        String template = EMPTY_STRING;
        if (!WSDLAdvisor.checkOperationTrace(operationTrace)) {
            return template;
        }
        Definition definition = WSDLAdvisor.getDefinitionWithoutExcpe(wsdlURI);
        if (WSUtil.isNull(definition)) {
            return template;
        }
        String inOrOutput = "in";
        template = String.valueOf(WSDLAdvisor.buildStart()) + this.buildHeader(wsdlURI, operationTrace, inOrOutput) + this.buildBody(wsdlURI, operationTrace, inOrOutput) + WSDLAdvisor.buildEnd();
        return template;
    }

    public String getLocalSOAPResponseTemplate(String wsdlURI, String operationTrace) {
        String template = EMPTY_STRING;
        if (!WSDLAdvisor.checkOperationTrace(operationTrace)) {
            return template;
        }
        Definition definition = WSDLAdvisor.getDefinitionWithoutExcpe(wsdlURI);
        if (WSUtil.isNull(definition)) {
            return template;
        }
        String inOrOutput = "out";
        template = String.valueOf(WSDLAdvisor.buildStart()) + this.buildHeader(wsdlURI, operationTrace, inOrOutput) + this.buildBody(wsdlURI, operationTrace, inOrOutput) + WSDLAdvisor.buildEnd();
        return template;
    }

    private static String buildStart() {
        return XML_DECLARATION + WSDLAdvisor.enter() + SOAP_ENVELOPE_START + WSDLAdvisor.buildNamespaceDeclarations();
    }

    private static String buildEnd() {
        return String.valueOf(WSDLAdvisor.enter()) + WSDLAdvisor.tab(1) + SOAP_BODY_END + WSDLAdvisor.enter() + SOAP_ENVELOPE_END;
    }

    private static String enter() {
        return "\n";
    }

    private static String tab(int num) {
        String tabs = EMPTY_STRING;
        int i = 0;
        while (i < num) {
            tabs = String.valueOf(tabs) + "\t";
            ++i;
        }
        return tabs;
    }

    private static String buildNamespaceDeclarations() {
        HashMap namespaceURIs = new HashMap();
        WSDLAdvisor.checkNamespace(namespaceURIs, NS_KEY_SOAP_ENV, NS_SOAP_ENV);
        WSDLAdvisor.checkNamespace(namespaceURIs, NS_KEY_SOAP_ENC, NS_SOAP_ENC);
        WSDLAdvisor.checkNamespace(namespaceURIs, NS_KEY_XSI, NS_XSI);
        WSDLAdvisor.checkNamespace(namespaceURIs, NS_KEY_XSD, NS_XSD);
        String result = EMPTY_STRING;
        Set uris = namespaceURIs.keySet();
        for (String uri : uris) {
            String prefix = (String)namespaceURIs.get(uri);
            result = String.valueOf(result) + WSDLAdvisor.enter() + "xmlns:" + prefix + "=\"" + uri + "\"";
        }
        return String.valueOf(result) + ">";
    }

    private static void checkNamespace(Map namespaceURIs, String namespace, String namespaceURI) {
        String resultNS = namespace;
        if (namespaceURI != null && (resultNS = (String)namespaceURIs.get(namespaceURI)) == null) {
            resultNS = namespace;
            while (namespaceURIs.containsValue(resultNS)) {
                resultNS = String.valueOf(resultNS) + "_" + Integer.toString(namespaceURIs.size());
            }
            namespaceURIs.put(namespaceURI, resultNS);
        }
    }

    private String buildHeader(String wsdlURI, String operationTrace, String inOrOutput) {
        String result = EMPTY_STRING;
        BindingOperation bindingOperation = WSDLAdvisor.getBindingOperation(wsdlURI, operationTrace);
        if (WSUtil.isNull(bindingOperation)) {
            return result;
        }
        BindingInput bindingInput = bindingOperation.getBindingInput();
        List extElements = bindingInput.getExtensibilityElements();
        if (!WSUtil.isNull(extElements)) {
            int i = 0;
            while (i < extElements.size()) {
                if (extElements.get(i) instanceof SOAPHeader) {
                    SOAPHeader soapHeader = (SOAPHeader)extElements.get(i);
                    String nameSpace = soapHeader.getMessage().getNamespaceURI();
                    String localPart = soapHeader.getPart();
                    if (WSUtil.isNull(localPart)) break;
                    ArrayList paramNameList = new ArrayList();
                    ArrayList paramTypeList = new ArrayList();
                    WSDLAdvisor.addParamComplexType(wsdlURI, localPart, paramNameList, paramTypeList);
                    result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(1) + SOAP_HEADER_START;
                    result = inOrOutput == "in" ? String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + NS_DEFAULT + localPart + " " + WSDLAdvisor.getQNameSpace(nameSpace) + ">" : String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + localPart + " " + WSDLAdvisor.getQNameSpace(nameSpace) + ">";
                    result = String.valueOf(result) + this.buildParametersByList(wsdlURI, NS_DEFAULT, paramNameList, paramTypeList, 3, inOrOutput);
                    result = inOrOutput == "in" ? String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + NS_DEFAULT + localPart + ">" : String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + localPart + ">";
                    result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(1) + SOAP_HEADER_END;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private WSNonLeafNode generateTargetNode(String wsdlURI, String localPart) {
        Definition definition = WSDLAdvisor.getDefinitionWithoutExcpe(wsdlURI);
        Types types = definition.getTypes();
        if (types != null && types.getExtensibilityElements() != null) {
            List extElements = types.getExtensibilityElements();
            ArrayList<Element> elementList = new ArrayList<Element>();
            int i = 0;
            while (i < extElements.size()) {
                if (extElements.get(i) instanceof SchemaImpl) {
                    elementList.add(((SchemaImpl)extElements.get(i)).getElement());
                    for (Object value : ((SchemaImpl)extElements.get(i)).getImports().values()) {
                        if (!(value instanceof Collection)) continue;
                        for (Object o : (Collection)value) {
                            SchemaImportImpl sii;
                            if (!(o instanceof SchemaImportImpl) || !((sii = (SchemaImportImpl)o).getReferencedSchema() instanceof SchemaImpl)) continue;
                            elementList.add(((SchemaImpl)sii.getReferencedSchema()).getElement());
                        }
                    }
                }
                ++i;
            }
            String[] parentNode = new String[]{EMPTY_STRING};
            WSNonLeafNode node = this.generateNode(localPart, elementList.toArray(new Element[0]), parentNode, null);
            if (node.getNodeList().size() >= 0) {
                return node;
            }
        }
        WSNonLeafNode newNode = new WSNonLeafNode();
        newNode.setName(localPart);
        ArrayList lowerLeverList = new ArrayList();
        newNode.setNodeList(lowerLeverList);
        return newNode;
    }

    private WSNonLeafNode handleAnonymousComplexNode(Node node, Element[] element, String[] parentNode, String[] anonymousComplexParentNode) {
        WSNonLeafNode newNode = new WSNonLeafNode();
        ArrayList lowerLeverList = new ArrayList();
        Node nodeName = node.getAttributes().getNamedItem(NAME);
        String stringName = null;
        stringName = nodeName != null ? nodeName.getNodeValue() : node.getNodeName();
        newNode.setName(stringName);
        int k = 0;
        while (k < anonymousComplexParentNode.length) {
            if (stringName.equals(anonymousComplexParentNode[k].toString())) {
                newNode.setNodeList(lowerLeverList);
                return newNode;
            }
            ++k;
        }
        String[] subNodeParents = this.generateSubNodeParents(stringName, parentNode);
        String[] subAnonymousNodeParents = this.generateSubNodeParents(stringName, anonymousComplexParentNode);
        Node middleNode = this.getSignificantNode(node);
        if (middleNode != null) {
            NodeList subs = middleNode.getChildNodes();
            int i = 0;
            while (i < subs.getLength()) {
                Node sub = subs.item(i);
                if (sub.getNodeType() == 1) {
                    NamedNodeMap nodeMap = sub.getAttributes();
                    if (!WSUtil.isNull(nodeMap.getNamedItem(NAME))) {
                        this.handleNodes(element, lowerLeverList, subNodeParents, subAnonymousNodeParents, sub);
                    } else if (!WSUtil.isNull(nodeMap.getNamedItem(REF))) {
                        this.addRef(lowerLeverList, sub, element, subNodeParents);
                    } else {
                        this.handleAnonymousComplexNode(sub, element, subNodeParents, subAnonymousNodeParents);
                    }
                }
                ++i;
            }
        }
        newNode.setNodeList(lowerLeverList);
        return newNode;
    }

    private boolean isComplexType(Node node, Element[] element) {
        NodeList nodes = this.getChildNodes(element);
        int i = 0;
        while (i < nodes.getLength()) {
            NamedNodeMap nodeMap;
            Node XMLNode = nodes.item(i);
            if (XMLNode.getNodeType() == 1 && !WSUtil.isNull(nodeMap = XMLNode.getAttributes()) && !WSUtil.isNull(nodeMap.getNamedItem(NAME)) && !WSUtil.isNull(node.getAttributes().getNamedItem(TYPE)) && WSDLAdvisor.getParamTypeLocalPart(node.getAttributes().getNamedItem(TYPE).getNodeValue()).equalsIgnoreCase(nodeMap.getNamedItem(NAME).getNodeValue()) && WSDLAdvisor.getParamTypeLocalPart(XMLNode.getNodeName()).equals(COMPLEX_TYPE)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isNestedSimpleType(Node XMLNode) {
        NodeList nodes = XMLNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && WSDLAdvisor.getParamTypeLocalPart(node.getNodeName()).equals(SIMPLE_TYPE)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getSimpleTypeBase(String wsdlURI, String typeName) {
        Definition definition = WSDLAdvisor.getDefinitionWithoutExcpe(wsdlURI);
        Types types = definition.getTypes();
        if (types != null && types.getExtensibilityElements() != null) {
            List extElements = types.getExtensibilityElements();
            ArrayList<Element> elementList = new ArrayList<Element>();
            int i = 0;
            while (i < extElements.size()) {
                if (extElements.get(i) instanceof SchemaImpl) {
                    elementList.add(((SchemaImpl)extElements.get(i)).getElement());
                }
                ++i;
            }
            (new String[1])[0] = EMPTY_STRING;
            NodeList nodes = this.getChildNodes(elementList.toArray(new Element[0]));
            Node XMLNode = this.findElementNodeByName(nodes, typeName);
            if (XMLNode != null && WSDLAdvisor.getParamTypeLocalPart(XMLNode.getNodeName()).equals(SIMPLE_TYPE)) {
                return this.getSimpleTypeBase(XMLNode);
            }
        }
        return null;
    }

    private String getSimpleTypeBase(Node node) {
        NodeList subNodes = node.getChildNodes();
        int i = 0;
        while (i < subNodes.getLength()) {
            Node subNode = subNodes.item(i);
            NamedNodeMap subNodeMap = subNode.getAttributes();
            if (!WSUtil.isNull(subNodeMap) && !WSUtil.isNull(subNodeMap.getNamedItem(BASE))) {
                return subNodeMap.getNamedItem(BASE).getNodeValue();
            }
            ++i;
        }
        return null;
    }

    private void addNestedSimpleType(List lowerLeverList, Node node) {
        NodeList subs = node.getChildNodes();
        int i = 0;
        while (i < subs.getLength()) {
            Node sub = subs.item(i);
            if (sub.getNodeType() == 1 && WSDLAdvisor.getParamTypeLocalPart(sub.getNodeName()).equals(SIMPLE_TYPE)) {
                NodeList subNodes = sub.getChildNodes();
                int j = 0;
                while (j < subs.getLength()) {
                    NamedNodeMap subNodeMap;
                    Node subNode = subNodes.item(i);
                    if (subNode.getNodeType() == 1 && !WSUtil.isNull((subNodeMap = subNode.getAttributes()).getNamedItem(BASE)) && !WSUtil.isNull(subNode.getParentNode().getParentNode().getAttributes().getNamedItem(NAME))) {
                        WSLeafNode leafNode = new WSLeafNode();
                        leafNode.setName(subNode.getParentNode().getParentNode().getAttributes().getNamedItem(NAME).getNodeValue());
                        leafNode.setType(subNodeMap.getNamedItem(BASE).getNodeValue());
                        lowerLeverList.add(leafNode);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private boolean isAnonymousComplexType(Node XMLNode) {
        NodeList nodes = XMLNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && WSDLAdvisor.getParamTypeLocalPart(node.getNodeName()).equals(COMPLEX_TYPE) && !WSUtil.isNull(XMLNode.getAttributes().getNamedItem(NAME))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Node getSignificantNode(Node XMLNode) {
        NodeList nodes = XMLNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            NamedNodeMap nodeMap;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && !WSUtil.isNull(nodeMap = node.getAttributes())) {
                if (!WSUtil.isNull(nodeMap.getNamedItem(NAME)) || !WSUtil.isNull(nodeMap.getNamedItem(REF))) {
                    return this.getSignificantParentNode(node);
                }
                return this.getSignificantNode(node);
            }
            ++i;
        }
        return null;
    }

    private Node getSignificantParentNode(Node node) {
        Node parentNode = node.getParentNode();
        while (this.isChoiceNode(parentNode)) {
            if (!WSUtil.isNull(parentNode.getParentNode())) {
                parentNode = parentNode.getParentNode();
                continue;
            }
            return parentNode;
        }
        return parentNode;
    }

    private String[] generateSubNodeParents(String nodeName, String[] parentNode) {
        String[] subNodeParents = new String[parentNode.length + 1];
        System.arraycopy(parentNode, 0, subNodeParents, 0, parentNode.length);
        subNodeParents[subNodeParents.length - 1] = nodeName;
        return subNodeParents;
    }

    private NodeList getChildNodes(Element[] element) {
        return new MultipleNodeList(element);
    }

    public WSNonLeafNode generateNode(String nodeName, Element[] element, String[] parentNode, String complexTypeName) {
        String localPart = complexTypeName != null ? complexTypeName : nodeName;
        ArrayList lowerLeverList = new ArrayList();
        WSNonLeafNode newNode = new WSNonLeafNode();
        newNode.setName(nodeName);
        int k = 0;
        while (k < parentNode.length) {
            if (nodeName.equals(parentNode[k].toString())) {
                newNode.setNodeList(lowerLeverList);
                return newNode;
            }
            ++k;
        }
        String[] subNodeParents = this.generateSubNodeParents(localPart, parentNode);
        NodeList nodes = this.getChildNodes(element);
        Node XMLNode = null;
        if (complexTypeName != null) {
            XMLNode = this.findComplexTypeNodeByName(nodes, localPart);
        }
        if (XMLNode == null) {
            XMLNode = this.findElementNodeByName(nodes, localPart);
        }
        if (XMLNode != null) {
            Node middleNode = this.getSignificantNode(XMLNode);
            this.genetateLowerLeverList(element, lowerLeverList, subNodeParents, middleNode, null);
        }
        newNode.setNodeList(lowerLeverList);
        return newNode;
    }

    private Node findElementNodeByName(NodeList nodes, String name) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node XMLNode = nodes.item(i);
            NamedNodeMap XMLNodeNodeMap = XMLNode.getAttributes();
            if (!WSUtil.isNull(XMLNodeNodeMap) && !WSUtil.isNull(XMLNodeNodeMap.getNamedItem(NAME)) && name.equalsIgnoreCase(XMLNodeNodeMap.getNamedItem(NAME).getNodeValue())) {
                return XMLNode;
            }
            ++i;
        }
        return null;
    }

    private Node findComplexTypeNodeByName(NodeList nodes, String name) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node XMLNode = nodes.item(i);
            NamedNodeMap XMLNodeNodeMap = XMLNode.getAttributes();
            if (!WSUtil.isNull(XMLNodeNodeMap) && !WSUtil.isNull(XMLNodeNodeMap.getNamedItem(NAME)) && name.equalsIgnoreCase(XMLNodeNodeMap.getNamedItem(NAME).getNodeValue()) && XMLNode.getLocalName().equalsIgnoreCase(COMPLEX_TYPE)) {
                return XMLNode;
            }
            ++i;
        }
        return null;
    }

    private void genetateLowerLeverList(Element[] element, List lowerLeverList, String[] subNodeParents, Node middleNode, String[] anonymousComplexParentNode) {
        if (middleNode == null) {
            return;
        }
        NodeList subs = middleNode.getChildNodes();
        int j = 0;
        while (j < subs.getLength()) {
            Node sub = subs.item(j);
            if (sub == null) {
                return;
            }
            if (this.isChoiceNode(sub)) {
                this.genetateLowerLeverList(element, lowerLeverList, subNodeParents, sub, anonymousComplexParentNode);
            }
            if (sub.getNodeType() == 1) {
                this.handleNodes(element, lowerLeverList, subNodeParents, anonymousComplexParentNode, sub);
            }
            ++j;
        }
    }

    private boolean isChoiceNode(Node node) {
        return WSDLAdvisor.getParamTypeLocalPart(node.getNodeName()).equals(CHOICE);
    }

    private void handleNodes(Element[] element, List lowerLeverList, String[] subNodeParents, String[] anonymousComplexParentNode, Node sub) {
        NamedNodeMap nodeMap = sub.getAttributes();
        if (!WSUtil.isNull(nodeMap.getNamedItem(TYPE)) && nodeMap.getNamedItem(TYPE).getNodeValue() != REF) {
            String XMLType = WSDLAdvisor.getParamTypeLocalPart(nodeMap.getNamedItem(TYPE).getNodeValue());
            if (WSDLAdvisor.isPrimitiveDataType(XMLType)) {
                this.addSimpleType(lowerLeverList, nodeMap);
            } else if (this.isComplexType(sub, element)) {
                this.addComplexType(lowerLeverList, nodeMap, element, subNodeParents);
            } else {
                this.addSimpleType(lowerLeverList, nodeMap);
            }
        } else if (!WSUtil.isNull(nodeMap.getNamedItem(REF))) {
            this.addRef(lowerLeverList, sub, element, subNodeParents);
        } else {
            if (this.isNestedSimpleType(sub)) {
                this.addNestedSimpleType(lowerLeverList, sub);
            }
            if (this.isAnonymousComplexType(sub)) {
                if (anonymousComplexParentNode == null) {
                    anonymousComplexParentNode = new String[]{EMPTY_STRING};
                }
                lowerLeverList.add(this.handleAnonymousComplexNode(sub, element, subNodeParents, anonymousComplexParentNode));
            }
        }
    }

    private void addSimpleType(List lowerLeverList, NamedNodeMap nodeMap) {
        String XMLType = WSDLAdvisor.getParamTypeLocalPart(nodeMap.getNamedItem(TYPE).getNodeValue());
        WSLeafNode leafNode = new WSLeafNode();
        leafNode.setName(nodeMap.getNamedItem(NAME).getNodeValue());
        leafNode.setType(XMLType);
        lowerLeverList.add(leafNode);
    }

    private void addComplexType(List lowerLeverList, NamedNodeMap nodeMap, Element[] element, String[] parentNode) {
        String nodeName = WSDLAdvisor.getParamTypeLocalPart(nodeMap.getNamedItem(NAME).getNodeValue());
        String complexTyneName = WSDLAdvisor.getParamTypeLocalPart(nodeMap.getNamedItem(TYPE).getNodeValue());
        lowerLeverList.add(this.generateNode(nodeName, element, parentNode, complexTyneName));
    }

    private void addRef(List lowerLeverList, Node node, Element[] element, String[] parentNode) {
        NodeList nodes = this.getChildNodes(element);
        int i = 0;
        while (i < nodes.getLength()) {
            NamedNodeMap nodeMap;
            Node XMLNode = nodes.item(i);
            if (XMLNode.getNodeType() == 1 && !WSUtil.isNull(nodeMap = XMLNode.getAttributes()) && !WSUtil.isNull(nodeMap.getNamedItem(NAME)) && WSDLAdvisor.getParamTypeLocalPart(node.getAttributes().getNamedItem(REF).getNodeValue()).equalsIgnoreCase(nodeMap.getNamedItem(NAME).getNodeValue()) && this.isNestedSimpleType(XMLNode)) {
                this.addNestedSimpleType(lowerLeverList, XMLNode);
                return;
            }
            ++i;
        }
        NamedNodeMap nodeMap = node.getAttributes();
        String nodeName = WSDLAdvisor.getParamTypeLocalPart(nodeMap.getNamedItem(REF).getNodeValue());
        lowerLeverList.add(this.generateNode(nodeName, element, parentNode, null));
    }

    private String buildInputParameters(String wsdlURI, String nameSpace, String name, int tabCount) {
        String result = EMPTY_STRING;
        WSNonLeafNode newNode = this.generateTargetNode(wsdlURI, name);
        this.setParentName(newNode);
        result = this.builderRequestParameters(newNode, nameSpace, tabCount);
        return result;
    }

    private void setParentName(WSNonLeafNode rootNode) {
        ArrayList<WSLeafNode> leafNodeList = new ArrayList<WSLeafNode>();
        this.getAllLeafNode(rootNode, leafNodeList);
        int i = 0;
        while (i < leafNodeList.size()) {
            boolean existSameName = false;
            int j = 0;
            while (j < leafNodeList.size()) {
                if (((WSLeafNode)leafNodeList.get(i)).getName().equals(((WSLeafNode)leafNodeList.get(j)).getName()) && j != i) {
                    existSameName = true;
                    break;
                }
                ++j;
            }
            if (!existSameName) {
                ((WSLeafNode)leafNodeList.get(i)).setPrefix(EMPTY_STRING);
            }
            ++i;
        }
    }

    private void getAllLeafNode(WSNonLeafNode node, List<WSLeafNode> leafNodeList) {
        List nodeList = node.getNodeList();
        int i = 0;
        while (i < nodeList.size()) {
            if (nodeList.get(i) instanceof WSLeafNode) {
                ((WSLeafNode)nodeList.get(i)).setPrefix(String.valueOf(node.getName()) + ".");
                leafNodeList.add((WSLeafNode)nodeList.get(i));
            } else if (nodeList.get(i) instanceof WSNonLeafNode) {
                this.getAllLeafNode((WSNonLeafNode)nodeList.get(i), leafNodeList);
            }
            ++i;
        }
    }

    private String builderRequestParameters(WSNonLeafNode newNode, String nameSpace, int tabCount) {
        String result = EMPTY_STRING;
        List nodeList = newNode.getNodeList();
        int i = 0;
        while (i < nodeList.size()) {
            if (nodeList.get(i) instanceof WSLeafNode) {
                WSLeafNode leafnode = (WSLeafNode)nodeList.get(i);
                result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + leafnode.getName() + WSDLAdvisor.buildParamType(leafnode.getType()) + ">&?" + leafnode.getPrefix() + leafnode.getName() + "?&</" + nameSpace + leafnode.getName() + ">";
            } else if (nodeList.get(i) instanceof WSNonLeafNode) {
                WSNonLeafNode nonLeafnode = (WSNonLeafNode)nodeList.get(i);
                result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + nonLeafnode.getName() + ">";
                result = String.valueOf(result) + this.builderRequestParameters(nonLeafnode, nameSpace, tabCount + 1);
                result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "</" + nameSpace + nonLeafnode.getName() + ">";
            }
            ++i;
        }
        return result;
    }

    private String builderResponseParameters(WSNonLeafNode newNode) {
        String result = EMPTY_STRING;
        List nodeList = newNode.getNodeList();
        int i = 0;
        while (i < nodeList.size()) {
            if (nodeList.get(i) instanceof WSLeafNode) {
                WSLeafNode leafnode = (WSLeafNode)nodeList.get(i);
                result = String.valueOf(result) + WSDLAdvisor.enter() + "<" + leafnode.getName() + ">" + "</" + leafnode.getName() + ">";
            } else if (nodeList.get(i) instanceof WSNonLeafNode) {
                WSNonLeafNode nonLeafnode = (WSNonLeafNode)nodeList.get(i);
                result = String.valueOf(result) + WSDLAdvisor.enter() + "<" + nonLeafnode.getName() + ">";
                result = String.valueOf(result) + this.builderResponseParameters(nonLeafnode);
                result = String.valueOf(result) + WSDLAdvisor.enter() + "</" + nonLeafnode.getName() + ">";
            }
            ++i;
        }
        return result;
    }

    private String buildOutputParameters(String wsdlURI, String name) {
        String result = EMPTY_STRING;
        WSNonLeafNode newNode = this.generateTargetNode(wsdlURI, name);
        result = this.builderResponseParameters(newNode);
        return result;
    }

    private static String getParamTypeLocalPart(String paramType) {
        return paramType.substring(paramType.lastIndexOf(":") + 1);
    }

    private static String buildParamType(String paramType) {
        String result = EMPTY_STRING;
        if (WSUtil.isNull(paramType)) {
            return result;
        }
        result = String.valueOf(result) + " xsi:type=\"xsd:" + WSDLAdvisor.getParamTypeLocalPart(paramType) + "\"";
        return result;
    }

    private String buildBody(String wsdlURI, String operationTrace, String inOrOutput) {
        String result = String.valueOf(WSDLAdvisor.enter()) + WSDLAdvisor.tab(1) + SOAP_BODY_START;
        result = WSDLAdvisor.isRPC(wsdlURI, operationTrace) ? String.valueOf(result) + this.buildBodyRPC(wsdlURI, operationTrace, inOrOutput) : String.valueOf(result) + this.buildBodyDoc(wsdlURI, operationTrace, inOrOutput);
        return result;
    }

    private static boolean isRPC(String wsdlURI, String operationTrace) {
        boolean isRPC = false;
        Definition definition = WSDLAdvisor.getDefinitionWithoutExcpe(wsdlURI);
        String[] opSplit = operationTrace.split(RE_DELIMITER_OPEARTION);
        Service service = definition.getService(new QName(definition.getTargetNamespace(), opSplit[0]));
        Port port = service.getPort(opSplit[1]);
        Binding binding = port.getBinding();
        List extElements = binding.getExtensibilityElements();
        if (!WSUtil.isNull(extElements)) {
            int i = 0;
            while (i < extElements.size()) {
                if (extElements.get(i) instanceof SOAPBinding) {
                    isRPC = !WSUtil.isNull(((SOAPBinding)extElements.get(i)).getStyle()) && ((SOAPBinding)extElements.get(i)).getStyle().equalsIgnoreCase("rpc");
                    break;
                }
                ++i;
            }
        }
        return isRPC;
    }

    private String buildBodyRPC(String wsdlURI, String operationTrace, String inOrOutput) {
        String result = EMPTY_STRING;
        BindingOperation bindingOperation = WSDLAdvisor.getBindingOperation(wsdlURI, operationTrace);
        if (WSUtil.isNull(bindingOperation)) {
            return result;
        }
        Operation operation = bindingOperation.getOperation();
        List partOrder = operation.getParameterOrdering();
        List parts = null;
        parts = inOrOutput.equals("in") ? operation.getInput().getMessage().getOrderedParts(partOrder) : operation.getOutput().getMessage().getOrderedParts(null);
        if (!WSUtil.isNull(parts) && !parts.isEmpty()) {
            ArrayList<String> paramNameList = new ArrayList<String>();
            ArrayList<String> paramTypeList = new ArrayList<String>();
            int i = 0;
            while (i < parts.size()) {
                Part part = (Part)parts.get(i);
                QName typeName = part.getTypeName();
                paramNameList.add(part.getName());
                paramTypeList.add(typeName == null ? EMPTY_STRING : typeName.getLocalPart());
                ++i;
            }
            result = inOrOutput.equals("in") ? String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + NS_DEFAULT + operation.getName() + " " + WSDLAdvisor.getQNameSpace(WSDLAdvisor.getNameSpaceRPC(bindingOperation)) + ">" : String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + operation.getName() + " " + WSDLAdvisor.getQNameSpace(WSDLAdvisor.getNameSpaceRPC(bindingOperation)) + ">";
            result = String.valueOf(result) + this.buildParametersByList(wsdlURI, EMPTY_STRING, paramNameList, paramTypeList, 3, inOrOutput);
            result = inOrOutput == "in" ? String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + NS_DEFAULT + operation.getName() + ">" : String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + operation.getName() + ">";
        }
        return result;
    }

    private static String getNameSpaceRPC(BindingOperation bindingOperation) {
        BindingInput bindingInput = bindingOperation.getBindingInput();
        List extElements = bindingInput.getExtensibilityElements();
        String nameSpace = EMPTY_STRING;
        if (!WSUtil.isNull(extElements)) {
            int i = 0;
            while (i < extElements.size()) {
                if (extElements.get(i) instanceof SOAPBody) {
                    nameSpace = ((SOAPBody)extElements.get(i)).getNamespaceURI();
                    break;
                }
                ++i;
            }
        }
        return nameSpace;
    }

    private static String getQNameSpace(String nameSpace) {
        if (WSUtil.isNull(nameSpace)) {
            return EMPTY_STRING;
        }
        return "xmlns:m=\"" + nameSpace + "\"";
    }

    private String buildBodyDoc(String wsdlURI, String operationTrace, String inOrOutput) {
        String result = EMPTY_STRING;
        BindingOperation bindingOperation = WSDLAdvisor.getBindingOperation(wsdlURI, operationTrace);
        if (WSUtil.isNull(bindingOperation)) {
            return result;
        }
        Operation operation = bindingOperation.getOperation();
        List partOrder = operation.getParameterOrdering();
        List parts = inOrOutput == "in" ? operation.getInput().getMessage().getOrderedParts(partOrder) : operation.getOutput().getMessage().getOrderedParts(partOrder);
        if (!WSUtil.isNull(parts) && !parts.isEmpty()) {
            int i = 0;
            while (i < parts.size()) {
                Part part = (Part)parts.get(i);
                if (!(WSUtil.isNull(part.getName()) && WSUtil.isNull(part.getElementName()) && WSUtil.isNull(part.getTypeName()))) {
                    result = !WSUtil.isNull(part.getElementName()) ? (inOrOutput == "in" ? this.compositeInputBodyDoc(wsdlURI, part.getElementName().getLocalPart(), result) : this.compositeOutputBodyDoc(wsdlURI, part.getElementName().getLocalPart(), result)) : (inOrOutput == "in" ? String.valueOf(result) + this.compositeSimpleInputParameter(part.getName(), part.getTypeName().getLocalPart()) : String.valueOf(result) + this.compositeSimpleOutputParameter(part.getName()));
                }
                ++i;
            }
        }
        return result;
    }

    private String compositeSimpleInputParameter(String name, String type) {
        String nameSpace = NS_DEFAULT;
        int tabCount = 3;
        String result = String.valueOf(WSDLAdvisor.enter()) + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + name + WSDLAdvisor.buildParamType(type) + ">&?" + name + "?&</" + nameSpace + name + ">";
        return result;
    }

    private String compositeSimpleOutputParameter(String name) {
        String result = String.valueOf(WSDLAdvisor.enter()) + WSDLAdvisor.tab(2) + "<" + name + ">";
        result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + name + ">";
        return result;
    }

    private String compositeInputBodyDoc(String wsdlURI, String name, String result) {
        result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + NS_DEFAULT + name + " " + WSDLAdvisor.getQNameSpace(WSDLAdvisor.getNameSpaceDoc(wsdlURI)) + ">";
        result = String.valueOf(result) + this.buildInputParameters(wsdlURI, NS_DEFAULT, name, 3);
        result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + NS_DEFAULT + name + ">";
        return result;
    }

    private String compositeOutputBodyDoc(String wsdlURI, String name, String result) {
        result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "<" + name + ">";
        result = String.valueOf(result) + this.buildOutputParameters(wsdlURI, name);
        result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(2) + "</" + name + ">";
        return result;
    }

    private static void addParamComplexType(String wsdlURI, String localPart, List paramNameList, List paramTypeList) {
        Definition definition = WSDLAdvisor.getDefinitionWithoutExcpe(wsdlURI);
        Types types = definition.getTypes();
        List extElements = types.getExtensibilityElements();
        int i = 0;
        while (i < extElements.size()) {
            if (extElements.get(i) instanceof SchemaImpl) {
                Element element = ((SchemaImpl)extElements.get(i)).getElement();
                List teList = WSDLAdvisor.retrieveTargetElementList(element, localPart);
                int j = 0;
                while (j < teList.size()) {
                    Element te = (Element)teList.get(j);
                    if (!WSUtil.isNull(te)) {
                        paramNameList.add(te.getAttribute(NAME));
                        paramTypeList.add(te.getAttribute(TYPE));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static List retrieveTargetElementList(Element element, String localPart) {
        ArrayList teList = new ArrayList();
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            NamedNodeMap nodeMap;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && !WSUtil.isNull(nodeMap = node.getAttributes()) && !WSUtil.isNull(nodeMap.getNamedItem(NAME)) && localPart.equalsIgnoreCase(nodeMap.getNamedItem(NAME).getNodeValue())) {
                if (WSUtil.isNull(nodeMap.getNamedItem(TYPE))) {
                    WSDLAdvisor.retrieveNamedElements(teList, node);
                } else {
                    WSDLAdvisor.retrieveTargetElementList(element, nodeMap.getNamedItem(TYPE).getNodeName());
                }
            }
            ++i;
        }
        return teList;
    }

    private static void retrieveNamedElements(List teList, Node node) {
        NodeList subs = node.getChildNodes();
        int i = 0;
        while (i < subs.getLength()) {
            Node sub = subs.item(i);
            if (sub.getNodeType() == 1) {
                NamedNodeMap subMap = sub.getAttributes();
                if (WSUtil.isNull(subMap) || WSUtil.isNull(subMap.getNamedItem(NAME))) {
                    WSDLAdvisor.retrieveNamedElements(teList, sub);
                } else {
                    teList.add((Element)sub);
                }
            }
            ++i;
        }
    }

    private String buildParametersByList(String wsdlURI, String nameSpace, List paramNames, List paramTypes, int tabCount, String inOrOutput) {
        String result = EMPTY_STRING;
        int i = 0;
        while (i < paramNames.size()) {
            String paramName = paramNames.get(i).toString();
            String paramType = paramTypes.get(i).toString();
            if (!WSDLAdvisor.isPrimitiveDataType(paramType)) {
                WSNonLeafNode newNode = this.generateTargetNode(wsdlURI, paramType);
                if (newNode.getNodeList() == null || newNode.getNodeList().size() == 0) {
                    String simpleType;
                    result = inOrOutput == "in" ? ((simpleType = this.getSimpleTypeBase(wsdlURI, paramType)) == null ? String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + paramName + ">&?" + paramName + "?&</" + nameSpace + paramName + ">" : String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + paramName + WSDLAdvisor.buildParamType(simpleType) + ">&?" + paramName + "?&</" + nameSpace + paramName + ">") : String.valueOf(result) + WSDLAdvisor.enter() + "<" + paramName + ">" + "</" + paramName + ">";
                } else if (inOrOutput == "in") {
                    result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + paramName + ">";
                    result = String.valueOf(result) + this.buildParametersByTypeTree(wsdlURI, nameSpace, newNode, tabCount + 1, inOrOutput);
                    result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "</" + nameSpace + paramName + ">";
                } else {
                    result = String.valueOf(result) + WSDLAdvisor.enter() + "<" + paramName + ">";
                    result = String.valueOf(result) + this.buildParametersByTypeTree(wsdlURI, nameSpace, newNode, tabCount, inOrOutput);
                    result = String.valueOf(result) + WSDLAdvisor.enter() + "</" + paramName + ">";
                }
            } else {
                result = inOrOutput == "in" ? String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + paramName + WSDLAdvisor.buildParamType(paramType) + ">&?" + paramName + "?&</" + nameSpace + paramName + ">" : String.valueOf(result) + WSDLAdvisor.enter() + "<" + paramName + ">" + "</" + paramName + ">";
            }
            ++i;
        }
        return result;
    }

    private String buildParametersByTypeTree(String wsdlURI, String nameSpace, WSNonLeafNode typeTree, int tabCount, String inOrOutput) {
        String result = EMPTY_STRING;
        List subNode = typeTree.getNodeList();
        int i = 0;
        while (i < subNode.size()) {
            if (subNode.get(i) instanceof WSLeafNode) {
                WSLeafNode leafnode = (WSLeafNode)subNode.get(i);
                result = String.valueOf(result) + this.buildParametersByType(wsdlURI, nameSpace, leafnode.getName(), leafnode.getType(), tabCount, inOrOutput);
            } else if (subNode.get(i) instanceof WSNonLeafNode) {
                WSNonLeafNode nonLeafnode = (WSNonLeafNode)subNode.get(i);
                if (inOrOutput == "in") {
                    result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + nonLeafnode.getName() + ">";
                    result = String.valueOf(result) + this.buildParametersByTypeTree(wsdlURI, nameSpace, nonLeafnode, tabCount + 1, inOrOutput);
                    result = String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "</" + nameSpace + nonLeafnode.getName() + ">";
                } else {
                    result = String.valueOf(result) + WSDLAdvisor.enter() + "<" + nonLeafnode.getName() + ">";
                    result = String.valueOf(result) + this.buildParametersByTypeTree(wsdlURI, nameSpace, nonLeafnode, tabCount, inOrOutput);
                    result = String.valueOf(result) + WSDLAdvisor.enter() + "</" + nonLeafnode.getName() + ">";
                }
            }
            ++i;
        }
        return result;
    }

    private String buildParametersByType(String wsdlURI, String nameSpace, String paramName, String paramType, int tabCount, String inOrOutput) {
        String result = EMPTY_STRING;
        result = !WSDLAdvisor.isPrimitiveDataType(paramType) ? (inOrOutput == "in" ? String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + paramName + WSDLAdvisor.buildParamType(paramType) + ">&?" + paramName + "?&</" + nameSpace + paramName + ">" : String.valueOf(result) + WSDLAdvisor.enter() + "<" + paramName + ">" + "</" + paramName + ">") : (inOrOutput == "in" ? String.valueOf(result) + WSDLAdvisor.enter() + WSDLAdvisor.tab(tabCount) + "<" + nameSpace + paramName + ">&?" + paramName + "?&</" + nameSpace + paramName + ">" : String.valueOf(result) + WSDLAdvisor.enter() + "<" + paramName + ">" + "</" + paramName + ">");
        return result;
    }

    private static String getNameSpaceDoc(String wsdlURI) {
        String namespace = EMPTY_STRING;
        Definition definition = WSDLAdvisor.getDefinitionWithoutExcpe(wsdlURI);
        Types types = definition.getTypes();
        if (types == null) {
            return namespace;
        }
        List extElements = types.getExtensibilityElements();
        int i = 0;
        while (i < extElements.size()) {
            if (extElements.get(i) instanceof SchemaImpl) {
                Element element = ((SchemaImpl)extElements.get(i)).getElement();
                namespace = element.getAttribute("targetNamespace");
                return namespace;
            }
            ++i;
        }
        return namespace;
    }

    private static boolean isPrimitiveDataType(String dataType) {
        if (WSUtil.isNull(dataType)) {
            return true;
        }
        return WSDLAdvisor.getDataTypeList().contains(dataType.substring(dataType.indexOf(":") + 1).toLowerCase());
    }

    private static List getDataTypeList() {
        if (WSUtil.isNull(primitiveDataTypeList)) {
            primitiveDataTypeList = new ArrayList();
        }
        if (primitiveDataTypeList.isEmpty()) {
            primitiveDataTypeList.clear();
        }
        WSDLAdvisor.initDataTypeList();
        return primitiveDataTypeList;
    }

    private static void initDataTypeList() {
        primitiveDataTypeList.add("short");
        primitiveDataTypeList.add("int");
        primitiveDataTypeList.add("float");
        primitiveDataTypeList.add("double");
        primitiveDataTypeList.add("decimal");
        primitiveDataTypeList.add("string");
        primitiveDataTypeList.add("boolean");
        primitiveDataTypeList.add("datetime");
        primitiveDataTypeList.add("date");
        primitiveDataTypeList.add("time");
        primitiveDataTypeList.add("integer");
    }
}

