/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.impl;

import java.io.File;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignPackage;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DataSourceDesignImpl
extends EObjectImpl
implements DataSourceDesign,
IAdaptable {
    public static final String copyright = "Copyright (c) 2005, 2010 Actuate Corporation";
    private static final String RESOURCE_FILE_SUFFIX = ".properties";
    protected static final String NAME_EDEFAULT = null;
    protected String m_name = NAME_EDEFAULT;
    protected static final String ODA_EXTENSION_ID_EDEFAULT = null;
    protected String m_odaExtensionId = ODA_EXTENSION_ID_EDEFAULT;
    protected static final String ODA_EXTENSION_DATA_SOURCE_ID_EDEFAULT = null;
    protected String m_odaExtensionDataSourceId = ODA_EXTENSION_DATA_SOURCE_ID_EDEFAULT;
    protected static final String DISPLAY_NAME_EDEFAULT = null;
    protected String m_displayName = DISPLAY_NAME_EDEFAULT;
    protected Properties m_publicProperties;
    protected Properties m_privateProperties;
    protected static final String LINKED_PROFILE_NAME_EDEFAULT = null;
    protected String m_linkedProfileName = LINKED_PROFILE_NAME_EDEFAULT;
    protected static final String LINKED_PROFILE_STORE_FILE_PATH_EDEFAULT = null;
    protected String m_linkedProfileStoreFilePath = LINKED_PROFILE_STORE_FILE_PATH_EDEFAULT;
    protected ResourceIdentifiers m_hostResourceIdentifiers;
    protected static final String RESOURCE_FILE_EDEFAULT = null;
    protected String m_resourceFile = RESOURCE_FILE_EDEFAULT;
    private static final String CONN_PROFILE_NAME_PROP = "OdaConnProfileName";
    private static final String CONN_PROFILE_STORE_FILE_PATH_PROP = "OdaConnProfileStorePath";

    protected DataSourceDesignImpl() {
    }

    protected EClass eStaticClass() {
        return DesignPackage.Literals.DATA_SOURCE_DESIGN;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return EcoreUtil.copy((EObject)this);
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String newName) {
        String oldName = this.m_name;
        this.m_name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.m_name));
        }
    }

    public String getOdaExtensionId() {
        return this.m_odaExtensionId;
    }

    public void setOdaExtensionId(String newOdaExtensionId) {
        String oldOdaExtensionId = this.m_odaExtensionId;
        this.m_odaExtensionId = newOdaExtensionId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldOdaExtensionId, (Object)this.m_odaExtensionId));
        }
    }

    public String getOdaExtensionDataSourceId() {
        String assignedValue = this.getOdaExtensionDataSourceIdGen();
        if (assignedValue != null) {
            return assignedValue;
        }
        return this.getOdaExtensionId();
    }

    protected String getOdaExtensionDataSourceIdGen() {
        return this.m_odaExtensionDataSourceId;
    }

    public void setOdaExtensionDataSourceId(String newOdaExtensionDataSourceId) {
        String oldOdaExtensionDataSourceId = this.m_odaExtensionDataSourceId;
        this.m_odaExtensionDataSourceId = newOdaExtensionDataSourceId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldOdaExtensionDataSourceId, (Object)this.m_odaExtensionDataSourceId));
        }
    }

    public String getDisplayName() {
        return DesignUtil.getDefaultResourceString(this.getDisplayNameGen());
    }

    protected String getDisplayNameGen() {
        return this.m_displayName;
    }

    public void setDisplayName(String newDisplayName) {
        String newAttrValue = DesignUtil.addDefaultToResourceAttribute(newDisplayName, this.getDisplayNameGen());
        this.setDisplayNameGen(newAttrValue);
    }

    protected void setDisplayNameGen(String newDisplayName) {
        String oldDisplayName = this.m_displayName;
        this.m_displayName = newDisplayName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldDisplayName, (Object)this.m_displayName));
        }
    }

    public String getDisplayNameKey() {
        return DesignUtil.getResourceKey(this.getDisplayNameGen());
    }

    public void setDisplayNameKey(String newDisplayNameKey) {
        String newAttrValue = DesignUtil.addKeyToResourceAttribute(newDisplayNameKey, this.getDisplayNameGen());
        this.setDisplayNameGen(newAttrValue);
    }

    public Properties getPublicProperties() {
        String filePath;
        String profileName = this.getLinkedProfileNameGen();
        if (profileName != null) {
            this.setLinkedProfileName(profileName);
        }
        if ((filePath = this.getLinkedProfileStoreFilePathGen()) != null) {
            this.setLinkedProfileStoreFilePath(filePath);
        }
        return this.getPublicPropertiesGen();
    }

    protected Properties getPublicPropertiesGen() {
        return this.m_publicProperties;
    }

    public NotificationChain basicSetPublicProperties(Properties newPublicProperties, NotificationChain msgs) {
        Properties oldPublicProperties = this.m_publicProperties;
        this.m_publicProperties = newPublicProperties;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldPublicProperties, (Object)newPublicProperties);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setPublicProperties(Properties newPublicProperties) {
        if (newPublicProperties != this.m_publicProperties) {
            NotificationChain msgs = null;
            if (this.m_publicProperties != null) {
                msgs = ((InternalEObject)this.m_publicProperties).eInverseRemove((InternalEObject)this, -5, null, msgs);
            }
            if (newPublicProperties != null) {
                msgs = ((InternalEObject)newPublicProperties).eInverseAdd((InternalEObject)this, -5, null, msgs);
            }
            if ((msgs = this.basicSetPublicProperties(newPublicProperties, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newPublicProperties, (Object)newPublicProperties));
        }
    }

    public Properties getPrivateProperties() {
        return this.m_privateProperties;
    }

    public NotificationChain basicSetPrivateProperties(Properties newPrivateProperties, NotificationChain msgs) {
        Properties oldPrivateProperties = this.m_privateProperties;
        this.m_privateProperties = newPrivateProperties;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldPrivateProperties, (Object)newPrivateProperties);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setPrivateProperties(Properties newPrivateProperties) {
        if (newPrivateProperties != this.m_privateProperties) {
            NotificationChain msgs = null;
            if (this.m_privateProperties != null) {
                msgs = ((InternalEObject)this.m_privateProperties).eInverseRemove((InternalEObject)this, -6, null, msgs);
            }
            if (newPrivateProperties != null) {
                msgs = ((InternalEObject)newPrivateProperties).eInverseAdd((InternalEObject)this, -6, null, msgs);
            }
            if ((msgs = this.basicSetPrivateProperties(newPrivateProperties, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newPrivateProperties, (Object)newPrivateProperties));
        }
    }

    public String getLinkedProfileName() {
        String profileName = this.getLinkedProfileNameGen();
        if (profileName != null) {
            return profileName;
        }
        return this.getLinkedProfileNameInProperties();
    }

    protected String getLinkedProfileNameGen() {
        return this.m_linkedProfileName;
    }

    protected String getLinkedProfileNameInProperties() {
        Properties props = this.getPublicPropertiesGen();
        if (props == null) {
            return null;
        }
        return props.getProperty(CONN_PROFILE_NAME_PROP);
    }

    public void setLinkedProfileName(String newLinkedProfileName) {
        this.setLinkedProfileNameGen(null);
        this.setLinkedProfileNameAsProperty(newLinkedProfileName);
    }

    protected void setLinkedProfileNameGen(String newLinkedProfileName) {
        String oldLinkedProfileName = this.m_linkedProfileName;
        this.m_linkedProfileName = newLinkedProfileName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldLinkedProfileName, (Object)this.m_linkedProfileName));
        }
    }

    protected void setLinkedProfileNameAsProperty(String newLinkedProfileName) {
        Properties publicProps = this.getPublicPropertiesGen();
        if (publicProps == null) {
            publicProps = DesignFactory.eINSTANCE.createProperties();
            this.basicSetPublicProperties(publicProps, null);
        }
        publicProps.setProperty(CONN_PROFILE_NAME_PROP, newLinkedProfileName);
    }

    public String getLinkedProfileStoreFilePath() {
        String filePath = this.getLinkedProfileStoreFilePathGen();
        if (filePath != null) {
            return filePath;
        }
        return this.getLinkedProfileStoreFilePathInProperties();
    }

    protected String getLinkedProfileStoreFilePathGen() {
        return this.m_linkedProfileStoreFilePath;
    }

    protected String getLinkedProfileStoreFilePathInProperties() {
        Properties props = this.getPublicPropertiesGen();
        if (props == null) {
            return null;
        }
        return props.getProperty(CONN_PROFILE_STORE_FILE_PATH_PROP);
    }

    public void setLinkedProfileStoreFilePath(String newLinkedProfileStoreFilePath) {
        this.setLinkedProfileStoreFilePathGen(null);
        this.setLinkedProfileStoreFilePathAsProperty(newLinkedProfileStoreFilePath);
    }

    protected void setLinkedProfileStoreFilePathGen(String newLinkedProfileStoreFilePath) {
        String oldLinkedProfileStoreFilePath = this.m_linkedProfileStoreFilePath;
        this.m_linkedProfileStoreFilePath = newLinkedProfileStoreFilePath;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldLinkedProfileStoreFilePath, (Object)this.m_linkedProfileStoreFilePath));
        }
    }

    public ResourceIdentifiers getHostResourceIdentifiers() {
        return this.m_hostResourceIdentifiers;
    }

    public NotificationChain basicSetHostResourceIdentifiers(ResourceIdentifiers newHostResourceIdentifiers, NotificationChain msgs) {
        ResourceIdentifiers oldHostResourceIdentifiers = this.m_hostResourceIdentifiers;
        this.m_hostResourceIdentifiers = newHostResourceIdentifiers;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldHostResourceIdentifiers, (Object)newHostResourceIdentifiers);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setHostResourceIdentifiers(ResourceIdentifiers newHostResourceIdentifiers) {
        if (newHostResourceIdentifiers != this.m_hostResourceIdentifiers) {
            NotificationChain msgs = null;
            if (this.m_hostResourceIdentifiers != null) {
                msgs = ((InternalEObject)this.m_hostResourceIdentifiers).eInverseRemove((InternalEObject)this, -9, null, msgs);
            }
            if (newHostResourceIdentifiers != null) {
                msgs = ((InternalEObject)newHostResourceIdentifiers).eInverseAdd((InternalEObject)this, -9, null, msgs);
            }
            if ((msgs = this.basicSetHostResourceIdentifiers(newHostResourceIdentifiers, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newHostResourceIdentifiers, (Object)newHostResourceIdentifiers));
        }
    }

    public String getResourceFile() {
        return this.m_resourceFile;
    }

    public void setResourceFile(String newResourceFile) {
        if (newResourceFile != null && !newResourceFile.endsWith(RESOURCE_FILE_SUFFIX)) {
            throw new IllegalArgumentException(Messages.bind((String)Messages.design_invalidResourceFileName, (Object)newResourceFile));
        }
        this.setResourceFileGen(newResourceFile);
    }

    protected void setResourceFileGen(String newResourceFile) {
        String oldResourceFile = this.m_resourceFile;
        this.m_resourceFile = newResourceFile;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldResourceFile, (Object)this.m_resourceFile));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return this.basicSetPublicProperties(null, msgs);
            }
            case 5: {
                return this.basicSetPrivateProperties(null, msgs);
            }
            case 8: {
                return this.basicSetHostResourceIdentifiers(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getOdaExtensionId();
            }
            case 2: {
                return this.getOdaExtensionDataSourceId();
            }
            case 3: {
                return this.getDisplayNameGen();
            }
            case 4: {
                return this.getPublicProperties();
            }
            case 5: {
                return this.getPrivateProperties();
            }
            case 6: {
                return this.getLinkedProfileName();
            }
            case 7: {
                return this.getLinkedProfileStoreFilePath();
            }
            case 8: {
                return this.getHostResourceIdentifiers();
            }
            case 9: {
                return this.getResourceFile();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.setOdaExtensionId((String)newValue);
                return;
            }
            case 2: {
                this.setOdaExtensionDataSourceId((String)newValue);
                return;
            }
            case 3: {
                this.setDisplayNameGen((String)newValue);
                return;
            }
            case 4: {
                this.setPublicProperties((Properties)newValue);
                return;
            }
            case 5: {
                this.setPrivateProperties((Properties)newValue);
                return;
            }
            case 6: {
                this.setLinkedProfileName((String)newValue);
                return;
            }
            case 7: {
                this.setLinkedProfileStoreFilePath((String)newValue);
                return;
            }
            case 8: {
                this.setHostResourceIdentifiers((ResourceIdentifiers)newValue);
                return;
            }
            case 9: {
                this.setResourceFile((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setOdaExtensionId(ODA_EXTENSION_ID_EDEFAULT);
                return;
            }
            case 2: {
                this.setOdaExtensionDataSourceId(ODA_EXTENSION_DATA_SOURCE_ID_EDEFAULT);
                return;
            }
            case 3: {
                this.setDisplayNameGen(DISPLAY_NAME_EDEFAULT);
                return;
            }
            case 4: {
                this.setPublicProperties(null);
                return;
            }
            case 5: {
                this.setPrivateProperties(null);
                return;
            }
            case 6: {
                this.setLinkedProfileName(LINKED_PROFILE_NAME_EDEFAULT);
                return;
            }
            case 7: {
                this.setLinkedProfileStoreFilePath(LINKED_PROFILE_STORE_FILE_PATH_EDEFAULT);
                return;
            }
            case 8: {
                this.setHostResourceIdentifiers(null);
                return;
            }
            case 9: {
                this.setResourceFile(RESOURCE_FILE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.m_name != null : !NAME_EDEFAULT.equals(this.m_name);
            }
            case 1: {
                return ODA_EXTENSION_ID_EDEFAULT == null ? this.m_odaExtensionId != null : !ODA_EXTENSION_ID_EDEFAULT.equals(this.m_odaExtensionId);
            }
            case 2: {
                return ODA_EXTENSION_DATA_SOURCE_ID_EDEFAULT == null ? this.m_odaExtensionDataSourceId != null : !ODA_EXTENSION_DATA_SOURCE_ID_EDEFAULT.equals(this.m_odaExtensionDataSourceId);
            }
            case 3: {
                return DISPLAY_NAME_EDEFAULT == null ? this.m_displayName != null : !DISPLAY_NAME_EDEFAULT.equals(this.m_displayName);
            }
            case 4: {
                return this.m_publicProperties != null;
            }
            case 5: {
                return this.m_privateProperties != null;
            }
            case 6: {
                return LINKED_PROFILE_NAME_EDEFAULT == null ? this.m_linkedProfileName != null : !LINKED_PROFILE_NAME_EDEFAULT.equals(this.m_linkedProfileName);
            }
            case 7: {
                return LINKED_PROFILE_STORE_FILE_PATH_EDEFAULT == null ? this.m_linkedProfileStoreFilePath != null : !LINKED_PROFILE_STORE_FILE_PATH_EDEFAULT.equals(this.m_linkedProfileStoreFilePath);
            }
            case 8: {
                return this.m_hostResourceIdentifiers != null;
            }
            case 9: {
                return RESOURCE_FILE_EDEFAULT == null ? this.m_resourceFile != null : !RESOURCE_FILE_EDEFAULT.equals(this.m_resourceFile);
            }
        }
        return super.eIsSet(featureID);
    }

    protected void setLinkedProfileStoreFilePathAsProperty(String newLinkedProfileStoreFilePath) {
        Properties publicProps = this.getPublicPropertiesGen();
        if (publicProps == null) {
            publicProps = DesignFactory.eINSTANCE.createProperties();
            this.basicSetPublicProperties(publicProps, null);
        }
        publicProps.setProperty(CONN_PROFILE_STORE_FILE_PATH_PROP, newLinkedProfileStoreFilePath);
    }

    public File getLinkedProfileStoreFile() {
        String storeFilePath = this.getLinkedProfileStoreFilePath();
        return DesignUtil.convertPathToFile(storeFilePath);
    }

    public void setLinkedProfileStoreFile(File storageFile) {
        String filePath = DesignUtil.convertFileToPath(storageFile);
        this.setLinkedProfileStoreFilePath(filePath);
    }

    public boolean hasLinkToProfile() {
        String profileName = this.getLinkedProfileName();
        return profileName != null && profileName.trim().length() > 0;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.m_name);
        result.append(", odaExtensionId: ");
        result.append(this.m_odaExtensionId);
        result.append(", odaExtensionDataSourceId: ");
        result.append(this.m_odaExtensionDataSourceId);
        result.append(", displayName: ");
        result.append(this.m_displayName);
        result.append(", linkedProfileName: ");
        result.append(this.m_linkedProfileName);
        result.append(", linkedProfileStoreFilePath: ");
        result.append(this.m_linkedProfileStoreFilePath);
        result.append(", resourceFile: ");
        result.append(this.m_resourceFile);
        result.append(')');
        return result.toString();
    }
}

