/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class HasLanguageConfigurationPropertyTester
extends PropertyTester {
    private static <T> @Nullable T adapt(@Nullable Object sourceObject, Class<T> adapter) {
        return (T)Adapters.adapt((Object)sourceObject, adapter);
    }

    public boolean test(@Nullable Object receiver, @Nullable String property, Object @Nullable [] args, @Nullable Object expectedValue) {
        ContentTypeInfo info;
        ITextEditor editor = HasLanguageConfigurationPropertyTester.adapt(receiver, ITextEditor.class);
        if (editor == null) {
            return false;
        }
        IEditorInput input = editor.getEditorInput();
        IDocumentProvider docProvider = editor.getDocumentProvider();
        if (docProvider == null || input == null) {
            return false;
        }
        IDocument document = docProvider.getDocument((Object)input);
        if (document == null) {
            return false;
        }
        try {
            info = ContentTypeHelper.findContentTypes((IDocument)document);
        }
        catch (CoreException e) {
            return false;
        }
        if (info == null) {
            return false;
        }
        LanguageConfigurationRegistryManager registry = LanguageConfigurationRegistryManager.getInstance();
        return registry.getLanguageConfigurationFor(info.getContentTypes()) != null;
    }
}

