/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.completion.APIToolsJavadocCompletionProposal;
import org.eclipse.swt.graphics.Image;

public class APIToolsJavadocCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private String fErrorMessage = null;
    private Image fImageHandle = null;
    private ASTParser fParser = null;
    HashMap<String, Boolean> fExistingTags = null;

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        CompletionContext corecontext;
        IJavaProject project;
        JavaContentAssistInvocationContext jcontext = null;
        if (context instanceof JavaContentAssistInvocationContext && Util.isApiProject((IJavaProject)(project = (jcontext = (JavaContentAssistInvocationContext)context).getProject())) && (corecontext = jcontext.getCoreContext()).isInJavadoc()) {
            return this.computeJavadocProposals(jcontext, corecontext);
        }
        return Collections.emptyList();
    }

    List<ICompletionProposal> computeJavadocProposals(JavaContentAssistInvocationContext jcontext, CompletionContext corecontext) {
        ICompilationUnit cunit = jcontext.getCompilationUnit();
        if (cunit != null) {
            try {
                int offset = jcontext.getInvocationOffset();
                IJavaElement element = cunit.getElementAt(offset);
                if (!this.isVisible(element)) {
                    return Collections.emptyList();
                }
                ImageDescriptor imagedesc = jcontext.getLabelProvider().createImageDescriptor(CompletionProposal.create((int)19, (int)offset));
                this.fImageHandle = imagedesc == null ? null : imagedesc.createImage();
                int type = this.getType(element);
                int member = 16;
                switch (element.getElementType()) {
                    case 9: {
                        IMethod method = (IMethod)element;
                        member = 4;
                        if (!method.isConstructor()) break;
                        member = 32;
                        break;
                    }
                    case 8: {
                        member = 8;
                        break;
                    }
                }
                IApiJavadocTag[] tags = ApiPlugin.getJavadocTagManager().getTagsForType(type, member);
                int tagcount = tags.length;
                if (tagcount > 0) {
                    ArrayList<APIToolsJavadocCompletionProposal> list = null;
                    this.collectExistingTags(element, jcontext);
                    String completiontext = null;
                    int tokenstart = corecontext.getTokenStart();
                    int length = offset - tokenstart;
                    int i = 0;
                    while (i < tagcount) {
                        if (this.acceptTag(tags[i], element)) {
                            completiontext = tags[i].getCompleteTag(type, member);
                            if (this.appliesToContext(jcontext.getDocument(), completiontext, tokenstart, length > 0 ? length : 1)) {
                                if (list == null) {
                                    list = new ArrayList<APIToolsJavadocCompletionProposal>(tagcount - i);
                                }
                                list.add(new APIToolsJavadocCompletionProposal(corecontext, completiontext, tags[i].getTagName(), this.fImageHandle));
                            }
                        }
                        ++i;
                    }
                    if (list != null) {
                        return list;
                    }
                }
            }
            catch (JavaModelException e) {
                this.fErrorMessage = e.getMessage();
            }
        }
        return Collections.emptyList();
    }

    boolean isVisible(IJavaElement element) throws JavaModelException {
        if (element != null) {
            switch (element.getElementType()) {
                case 8: 
                case 9: {
                    IMember member = (IMember)element;
                    int flags = member.getFlags();
                    IType type = member.getDeclaringType();
                    if (!Flags.isPublic((int)flags) && !Flags.isProtected((int)flags) && (type == null || !type.isInterface())) break;
                    return this.isVisible((IJavaElement)type);
                }
                case 7: {
                    IType type = (IType)element;
                    int flags = type.getFlags();
                    if (type.isLocal() && !type.isAnonymous() || Flags.isPrivate((int)flags)) {
                        return false;
                    }
                    if (type.isMember()) {
                        if ((!Flags.isPublic((int)flags) || !Flags.isStatic((int)flags)) && !Flags.isPublic((int)flags) && !Flags.isProtected((int)flags) && !type.isInterface()) break;
                        return this.isVisible((IJavaElement)type.getDeclaringType());
                    }
                    return Flags.isPublic((int)flags) || type.isInterface();
                }
            }
        }
        return false;
    }

    private boolean acceptTag(IApiJavadocTag tag, IJavaElement element) throws JavaModelException {
        Boolean fragments;
        if (this.fExistingTags != null && (fragments = this.fExistingTags.get(tag.getTagName())) != null && Boolean.FALSE.equals(fragments)) {
            return false;
        }
        switch (element.getElementType()) {
            case 7: {
                IType type = (IType)element;
                int flags = type.getFlags();
                String tagname = tag.getTagName();
                if (Flags.isAbstract((int)flags)) {
                    return !tagname.equals("@noinstantiate");
                }
                if (!Flags.isFinal((int)flags)) break;
                return !tagname.equals("@noextend");
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (Flags.isFinal((int)method.getFlags()) || Flags.isStatic((int)method.getFlags())) {
                    return !tag.getTagName().equals("@nooverride");
                }
                IType type = method.getDeclaringType();
                if (type == null || !Flags.isFinal((int)type.getFlags())) break;
                return !tag.getTagName().equals("@nooverride");
            }
        }
        return true;
    }

    private int getType(IJavaElement element) throws JavaModelException {
        IJavaElement lelement = element;
        while (lelement != null && lelement.getElementType() != 7) {
            lelement = lelement.getParent();
        }
        if (lelement instanceof IType) {
            IType type = (IType)lelement;
            if (type.isAnnotation()) {
                return 128;
            }
            if (type.isInterface()) {
                return 2;
            }
            if (type.isEnum()) {
                return 64;
            }
        }
        return 1;
    }

    private void collectExistingTags(IJavaElement element, JavaContentAssistInvocationContext jcontext) throws JavaModelException {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            ICompilationUnit cunit = jcontext.getCompilationUnit();
            if (cunit != null) {
                BodyDeclaration bodyDeclaration;
                Javadoc javadoc;
                TypeDeclaration typeDeclaration;
                List bodyDeclarations;
                if (cunit.isWorkingCopy()) {
                    cunit.reconcile(0, false, false, null, null);
                }
                this.fParser.setSource(member.getSource().toCharArray());
                this.fParser.setKind(4);
                Map options = element.getJavaProject().getOptions(true);
                options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                this.fParser.setCompilerOptions(options);
                this.fParser.setStatementsRecovery(false);
                this.fParser.setResolveBindings(false);
                this.fParser.setBindingsRecovery(false);
                ASTNode ast = this.fParser.createAST(null);
                TagCollector collector = new TagCollector();
                if (ast.getNodeType() == 55 && (bodyDeclarations = (typeDeclaration = (TypeDeclaration)ast).bodyDeclarations()).size() == 1 && (javadoc = (bodyDeclaration = (BodyDeclaration)bodyDeclarations.iterator().next()).getJavadoc()) != null) {
                    javadoc.accept((ASTVisitor)collector);
                }
            }
        }
    }

    private boolean appliesToContext(IDocument document, String completiontext, int tokenstart, int length) {
        if (length > completiontext.length()) {
            return false;
        }
        try {
            String prefix = document.get(tokenstart, length);
            return prefix.equals(completiontext.substring(0, length));
        }
        catch (BadLocationException e) {
            ApiUIPlugin.log(e);
            return false;
        }
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public void sessionEnded() {
        if (this.fImageHandle != null) {
            this.fImageHandle.dispose();
        }
        this.fParser = null;
        if (this.fExistingTags != null) {
            this.fExistingTags.clear();
            this.fExistingTags = null;
        }
        this.fErrorMessage = null;
    }

    public void sessionStarted() {
        this.fParser = ASTParser.newParser((int)AST.getJLSLatest());
        this.fErrorMessage = null;
    }

    class TagCollector
    extends ASTVisitor {
        TagCollector() {
        }

        public boolean visit(Javadoc node) {
            Set tagnames = ApiPlugin.getJavadocTagManager().getAllTagNames();
            List tags = node.tags();
            if (APIToolsJavadocCompletionProposalComputer.this.fExistingTags == null) {
                APIToolsJavadocCompletionProposalComputer.this.fExistingTags = new HashMap(tags.size());
            }
            String name = null;
            for (TagElement tag : tags) {
                name = tag.getTagName();
                if (name == null || !tagnames.contains(name)) continue;
                APIToolsJavadocCompletionProposalComputer.this.fExistingTags.put(name, tag.fragments().isEmpty());
            }
            return false;
        }
    }
}

