/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.ui.handler;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;

public abstract class AbstractTemplateHandler
extends AbstractHandler {
    private static final String INFO_EXISTS_MESSAGE = "Template was not created since \"{0}\" already exists.";
    private static final String INFO_EXISTS_TITLE = "Template already exists";
    private static final String ERROR_MESSAGE = "Error while importing template.";
    private String templateLocation;
    private String templateOutput;

    public AbstractTemplateHandler(String templateLocation, String templateOutput) {
        this.templateLocation = templateLocation;
        this.templateOutput = templateOutput;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object firstElement;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null & selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            IFile file = (IFile)firstElement;
            IProject project = file.getProject();
            final IFile template = project.getFile(this.templateOutput);
            if (!template.exists()) {
                IWorkbench wb = PlatformUI.getWorkbench();
                IProgressService ps = wb.getProgressService();
                try {
                    ps.busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor pm) throws InvocationTargetException {
                            try {
                                URL url = new URL(AbstractTemplateHandler.this.templateLocation);
                                InputStream inputStream = url.openConnection().getInputStream();
                                template.create(inputStream, false, pm);
                            }
                            catch (Exception e) {
                                Logger.getGlobal().log(Level.SEVERE, AbstractTemplateHandler.ERROR_MESSAGE, e.getCause());
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Logger.getGlobal().log(Level.SEVERE, ERROR_MESSAGE, e.getCause());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                MessageDialog.openInformation((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)INFO_EXISTS_TITLE, (String)MessageFormat.format(INFO_EXISTS_MESSAGE, this.templateOutput));
            }
        }
        return null;
    }
}

