/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.eclipse.cft.server.core.ArchiveEntry;
import org.eclipse.cft.server.core.CFApplicationArchive;

public class ApplicationUtil {
    public static ApplicationArchive asV1ApplicationArchive(CFApplicationArchive cfArchive) {
        if (cfArchive != null) {
            return new V1ApplicationArchiveAdapter(cfArchive);
        }
        return null;
    }

    static class V1ApplicationArchiveAdapter
    implements ApplicationArchive {
        private final CFApplicationArchive cfArchive;

        public V1ApplicationArchiveAdapter(CFApplicationArchive cfArchive) {
            this.cfArchive = cfArchive;
        }

        public String getFilename() {
            return this.cfArchive.getName();
        }

        public Iterable<ApplicationArchive.Entry> getEntries() {
            Iterable<ArchiveEntry> cfEntries = this.cfArchive.getEntries();
            ArrayList<ApplicationArchive.Entry> legacyEntries = new ArrayList<ApplicationArchive.Entry>();
            if (cfEntries != null) {
                for (ArchiveEntry entry : cfEntries) {
                    legacyEntries.add(new V1ArchiveEntry(entry));
                }
            }
            return legacyEntries;
        }
    }

    static class V1ArchiveEntry
    implements ApplicationArchive.Entry {
        private final ArchiveEntry cfEntry;

        public V1ArchiveEntry(ArchiveEntry cfEntry) {
            this.cfEntry = cfEntry;
        }

        public boolean isDirectory() {
            return this.cfEntry.isDirectory();
        }

        public String getName() {
            return this.cfEntry.getName();
        }

        public long getSize() {
            return this.cfEntry.getSize();
        }

        public byte[] getSha1Digest() {
            return this.cfEntry.getSha1Digest();
        }

        public InputStream getInputStream() throws IOException {
            return this.cfEntry.getInputStream();
        }
    }
}

