/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.model;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.eclipse.capra.ui.office.exceptions.CapraOfficeObjectNotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapraOfficeObject {
    private static final Logger LOG = LoggerFactory.getLogger(CapraOfficeObject.class);
    public static final String DOCX = "docx";
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";
    public static final String URI_DELIMITER = "\\\\::";
    private String data = "";
    private String uri = "";

    public CapraOfficeObject() {
    }

    public CapraOfficeObject(String data, String uri) {
        this.data = data;
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getId() {
        int firstDelimiterIndex = this.uri.indexOf(URI_DELIMITER);
        return this.uri.substring(firstDelimiterIndex + URI_DELIMITER.length());
    }

    public File getFile() throws NoSuchFileException {
        String fileId = this.getFileId();
        File officeFile = new File(fileId);
        if (officeFile.exists()) {
            return officeFile;
        }
        throw new NoSuchFileException(fileId);
    }

    public String getFileId() {
        int firstDelimiterIndex = this.uri.indexOf(URI_DELIMITER);
        return this.uri.substring(0, firstDelimiterIndex);
    }

    public static String getObjectIdFromUri(String uri) {
        int firstDelimiterIndex = uri.indexOf(URI_DELIMITER);
        return uri.substring(firstDelimiterIndex + URI_DELIMITER.length());
    }

    public static String getFileIdFromUri(String uri) {
        int delimiterIndex = uri.indexOf(URI_DELIMITER);
        return uri.substring(0, delimiterIndex);
    }

    public void showOfficeObjectInNativeEnvironment() throws CapraOfficeObjectNotFound {
        try {
            Desktop.getDesktop().open(this.getFile());
        }
        catch (IOException e) {
            LOG.error("Could not oben office file.", (Throwable)e);
            throw new CapraOfficeObjectNotFound(this.getId(), e);
        }
    }

    public static String createUri(String fileId, String objectId) {
        return String.valueOf(fileId) + URI_DELIMITER + objectId;
    }

    public String toString() {
        return this.data;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CapraOfficeObject other = (CapraOfficeObject)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

