/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util.pattern.helper;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.ParameterDirection;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.docgen.util.CapellaDataValueServices;
import org.polarsys.capella.docgen.util.CapellaPropertyServices;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class CapellaExchangeItemElementHelper {
    public static String exchangeItemElementToString(ExchangeItemElement exItemElt, String projectName, String outputFolder) {
        String propertyValues;
        StringBuffer buffer = new StringBuffer();
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)exItemElt, projectName, outputFolder));
        buffer.append(" ");
        buffer.append("<b>");
        if (exItemElt.getDirection().equals((Object)ParameterDirection.RETURN)) {
            buffer.append("RETURN ");
        }
        if (exItemElt.isComposite()) {
            buffer.append("{ref}");
        }
        buffer.append(exItemElt.getName());
        buffer.append("[");
        buffer.append(CapellaDataValueServices.getSimpleValueOfDataValue((DataValue)exItemElt.getOwnedMaxCard()));
        buffer.append(",");
        buffer.append(CapellaDataValueServices.getSimpleValueOfDataValue((DataValue)exItemElt.getOwnedMinCard()));
        buffer.append("]");
        buffer.append("</b>");
        buffer.append(" : ");
        if (exItemElt.getAbstractType() != null) {
            buffer.append(CapellaServices.getFullDataPkgHierarchyLink((EObject)exItemElt.getAbstractType()));
        }
        if (exItemElt.getSummary() != null && exItemElt.getSummary().length() > 0) {
            buffer.append("\n<br />");
            buffer.append(exItemElt.getSummary());
        }
        if (exItemElt.getDescription() != null && exItemElt.getDescription().length() > 0) {
            buffer.append("\n<br />");
            buffer.append(StringUtil.transformAREFString((EObject)exItemElt, exItemElt.getDescription(), projectName, outputFolder));
        }
        if ((propertyValues = CapellaPropertyServices.getPropertyValues((EList<AbstractPropertyValue>)exItemElt.getOwnedPropertyValues(), projectName, outputFolder)) != null && propertyValues.length() > 0) {
            buffer.append("<ul class=\"generatedList\">");
            buffer.append(propertyValues);
            buffer.append("</ul>");
        }
        return buffer.toString();
    }
}

