/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.emitter;

import java.awt.Color;
import java.util.Map;
import org.eclipse.birt.report.engine.layout.emitter.IPage;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;

public abstract class AbstractPage
implements IPage {
    protected float pageWidth;
    protected float pageHeight;

    public AbstractPage(int pageWidth, int pageHeight) {
        this.pageWidth = this.convertToPoint(pageWidth);
        this.pageHeight = this.convertToPoint(pageHeight);
    }

    @Override
    public void startClip(int startX, int startY, int width, int height) {
        this.saveState();
        this.clip(this.convertToPoint(startX), this.convertToPoint(startY), this.convertToPoint(width), this.convertToPoint(height));
    }

    @Override
    public void endClip() {
        this.clipEnd();
        this.restoreState();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void drawBackgroundColor(Color color, int x, int y, int width, int height) {
        this.drawBackgroundColor(color, this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height));
    }

    @Override
    public void drawBackgroundImage(int x, int y, int width, int height, int imageWidth, int imageHeight, int repeat, String imageUrl, byte[] imageData, int absPosX, int absPosY) throws Exception {
        if (imageData == null || imageData.length == 0) {
            return;
        }
        this.drawBackgroundImage(this.convertToPoint(x), this.convertToPoint(y), this.convertToPoint(width), this.convertToPoint(height), this.convertToPoint(imageWidth), this.convertToPoint(imageHeight), repeat, imageUrl, imageData, this.convertToPoint(absPosX), this.convertToPoint(absPosY));
    }

    @Override
    public void drawImage(String imageId, byte[] imageData, String extension, int imageX, int imageY, int height, int width, String helpText, Map params) throws Exception {
        this.drawImage(imageId, imageData, extension, this.convertToPoint(imageX), this.convertToPoint(imageY), this.convertToPoint(height), this.convertToPoint(width), helpText, params);
    }

    @Override
    @Deprecated
    public void drawImage(String uri, String extension, int imageX, int imageY, int height, int width, String helpText, Map params) throws Exception {
        this.drawImage(uri, extension, this.convertToPoint(imageX), this.convertToPoint(imageY), this.convertToPoint(height), this.convertToPoint(width), helpText, params);
    }

    @Override
    public void drawLine(int startX, int startY, int endX, int endY, int width, Color color, int lineStyle) {
        this.drawLine(this.convertToPoint(startX), this.convertToPoint(startY), this.convertToPoint(endX), this.convertToPoint(endY), this.convertToPoint(width), color, lineStyle);
    }

    @Override
    public void drawText(String text, int textX, int textY, int textWidth, int textHeight, TextStyle textStyle) {
        float x = this.convertToPoint(textX);
        float y = this.convertToPoint(textY);
        float width = this.convertToPoint(textWidth);
        float height = this.convertToPoint(textHeight);
        FontInfo fontInfo = textStyle.getFontInfo();
        float baseline = this.convertToPoint(fontInfo.getBaseline());
        this.drawText(text, x, y, baseline, width, height, textStyle);
        float lineWidth = fontInfo.getLineWidth();
        Color color = textStyle.getColor();
        if (textStyle.isLinethrough()) {
            this.drawDecorationLine(x, y, width, lineWidth, this.convertToPoint(fontInfo.getLineThroughPosition()), color);
        }
        if (textStyle.isOverline()) {
            this.drawDecorationLine(x, y, width, lineWidth, this.convertToPoint(fontInfo.getOverlinePosition()), color);
        }
        if (textStyle.isUnderline()) {
            this.drawDecorationLine(x, y, width, lineWidth, this.convertToPoint(fontInfo.getUnderlinePosition()), color);
        }
    }

    @Override
    public void showHelpText(String text, int textX, int textY, int width, int height) {
        this.showHelpText(text, this.convertToPoint(textX), this.convertToPoint(textY), this.convertToPoint(width), this.convertToPoint(height));
    }

    protected void drawDecorationLine(float textX, float textY, float width, float lineWidth, float verticalOffset, Color color) {
        this.drawLine(textX, textY += verticalOffset, textX + width, textY, lineWidth, color, 21);
    }

    protected abstract void clip(float var1, float var2, float var3, float var4);

    protected void clipEnd() {
    }

    protected abstract void saveState();

    protected abstract void restoreState();

    protected abstract void drawBackgroundColor(Color var1, float var2, float var3, float var4, float var5);

    protected abstract void drawBackgroundImage(float var1, float var2, float var3, float var4, float var5, float var6, int var7, String var8, byte[] var9, float var10, float var11) throws Exception;

    protected abstract void drawImage(String var1, byte[] var2, String var3, float var4, float var5, float var6, float var7, String var8, Map var9) throws Exception;

    protected abstract void drawImage(String var1, String var2, float var3, float var4, float var5, float var6, String var7, Map var8) throws Exception;

    protected abstract void drawLine(float var1, float var2, float var3, float var4, float var5, Color var6, int var7);

    protected abstract void drawText(String var1, float var2, float var3, float var4, float var5, float var6, TextStyle var7);

    protected void showHelpText(String text, float textX, float textY, float width, float height) {
    }

    protected float convertToPoint(int value) {
        return (float)value / 1000.0f;
    }

    protected float transformY(float y) {
        return this.pageHeight - y;
    }

    protected float transformY(float y, float height) {
        return this.pageHeight - y - height;
    }

    protected float transformY(float y, float height, float containerHeight) {
        return containerHeight - y - height;
    }
}

