/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.parameter;

import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;

public class FormatUtil {
    private static boolean isCustom(String formatCategory) {
        return "Custom".equals(formatCategory) || "Custom".equals(formatCategory) || "Custom".equals(formatCategory);
    }

    public static String format(ParameterHandle handle, String inputStr) throws BirtException {
        if (inputStr == null || inputStr.trim().length() == 0) {
            return null;
        }
        if (handle instanceof ScalarParameterHandle) {
            inputStr = FormatUtil.formatScalarParameter((ScalarParameterHandle)handle, inputStr);
        }
        return inputStr;
    }

    private static String formatScalarParameter(ScalarParameterHandle handle, String inputStr) throws BirtException {
        String dataType;
        String pattern = handle.getPattern();
        String category = handle.getCategory();
        if (pattern == null) {
            if (FormatUtil.isCustom(category)) {
                return inputStr;
            }
            pattern = category;
        }
        if ("dateTime".equals(dataType = handle.getDataType())) {
            Date date = DataTypeUtil.toDate((String)inputStr, (ULocale)ULocale.US);
            DateFormatter formatter = new DateFormatter(pattern);
            inputStr = formatter.format(date);
        } else if ("float".equals(dataType)) {
            inputStr = new NumberFormatter(pattern).format(DataTypeUtil.toDouble((Object)inputStr).doubleValue());
        } else if ("decimal".equals(dataType)) {
            inputStr = new NumberFormatter(pattern).format(DataTypeUtil.toBigDecimal((Object)inputStr));
        } else if ("string".equals(dataType)) {
            inputStr = new StringFormatter(pattern).format(inputStr);
        }
        return inputStr;
    }
}

